"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ListExceptionItems = void 0;
var _react = _interopRequireDefault(require("react"));
var _securitysolutionExceptionListComponents = require("@kbn/securitysolution-exception-list-components");
var _securitysolutionIoTsListTypes = require("@kbn/securitysolution-io-ts-list-types");
var _formatted_date = require("../../../common/components/formatted_date");
var _ui = require("../../utils/ui.helpers");
var _link_to_rule_details = require("../link_to_rule_details");
var _exceptions_utility = require("../exceptions_utility");
var i18n = _interopRequireWildcard(require("../../translations/list_exception_items"));
var _show_value_list_modal = require("../../../value_list/components/show_value_list_modal");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763899475283842490/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/exceptions/components/list_exception_items/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const ListExceptionItemsComponent = ({
  isReadOnly,
  exceptions,
  listType,
  lastUpdated,
  pagination,
  emptyViewerTitle,
  emptyViewerBody,
  emptyViewerButtonText,
  viewerStatus,
  ruleReferences,
  hideUtility = false,
  onDeleteException,
  onEditExceptionItem,
  onPaginationChange,
  onCreateExceptionListItem
}) => {
  const editButtonText = listType === _securitysolutionIoTsListTypes.ExceptionListTypeEnum.ENDPOINT ? i18n.EXCEPTION_ITEM_CARD_EDIT_ENDPOINT_LABEL : i18n.EXCEPTION_ITEM_CARD_EDIT_LABEL;
  const deleteButtonText = listType === _securitysolutionIoTsListTypes.ExceptionListTypeEnum.ENDPOINT ? i18n.EXCEPTION_ITEM_CARD_DELETE_ENDPOINT_LABEL : i18n.EXCEPTION_ITEM_CARD_DELETE_LABEL;
  const exceptionsTitle = listType === _securitysolutionIoTsListTypes.ExceptionListTypeEnum.ENDPOINT ? i18n.EXCEPTION_UTILITY_ENDPOINT_TITLE : i18n.EXCEPTION_UTILITY_TITLE;
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_securitysolutionExceptionListComponents.ExceptionItems, {
    viewerStatus: viewerStatus,
    listType: listType,
    ruleReferences: ruleReferences,
    isReadOnly: isReadOnly,
    exceptions: exceptions,
    emptyViewerTitle: emptyViewerTitle,
    emptyViewerBody: emptyViewerBody,
    emptyViewerButtonText: emptyViewerButtonText,
    pagination: pagination,
    lastUpdated: lastUpdated,
    editActionLabel: editButtonText,
    deleteActionLabel: deleteButtonText,
    onPaginationChange: onPaginationChange,
    onEditExceptionItem: onEditExceptionItem,
    onDeleteException: onDeleteException,
    getFormattedComments: _ui.getFormattedComments,
    securityLinkAnchorComponent: _link_to_rule_details.LinkToRuleDetails,
    formattedDateComponent: _formatted_date.FormattedDate,
    onCreateExceptionListItem: onCreateExceptionListItem,
    exceptionsUtilityComponent: () => hideUtility ? null : /*#__PURE__*/_react.default.createElement(_exceptions_utility.ExceptionsUtility, {
      exceptionsTitle: exceptionsTitle,
      pagination: pagination,
      lastUpdated: lastUpdated,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 101,
        columnNumber: 13
      }
    }),
    showValueListModal: _show_value_list_modal.ShowValueListModal,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 79,
      columnNumber: 7
    }
  }));
};
ListExceptionItemsComponent.displayName = 'ListExceptionItemsComponent';
const ListExceptionItems = exports.ListExceptionItems = /*#__PURE__*/_react.default.memo(ListExceptionItemsComponent);
ListExceptionItems.displayName = 'ListExceptionItems';