"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SELECT_INDEX_LABEL = exports.LOADING_ERROR_MESSAGE = exports.IndexSelectorModal = exports.DEBOUNCE_OPTIONS = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _reactHooks = require("@kbn/react-hooks");
var _use_app_toasts = require("../../../../common/hooks/use_app_toasts");
var _use_fetch_privileged_user_indices = require("../hooks/use_fetch_privileged_user_indices");
var _api = require("../../../api/api");
var _create_index_modal = require("./create_index_modal");
var _use_privileged_monitoring_health = require("../../../hooks/use_privileged_monitoring_health");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763899475283842490/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/entity_analytics/components/privileged_user_monitoring_onboarding/components/select_index_modal.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const SELECT_INDEX_LABEL = exports.SELECT_INDEX_LABEL = _i18n.i18n.translate('xpack.securitySolution.entityAnalytics.privilegedUserMonitoring.selectIndex.comboboxPlaceholder', {
  defaultMessage: 'Select index'
});
const LOADING_ERROR_MESSAGE = exports.LOADING_ERROR_MESSAGE = _i18n.i18n.translate('xpack.securitySolution.entityAnalytics.privilegedUserMonitoring.selectIndex.error', {
  defaultMessage: 'Error loading indices. Please try again later.'
});
const DEBOUNCE_OPTIONS = exports.DEBOUNCE_OPTIONS = {
  wait: 300
};
const IndexSelectorModal = ({
  onClose,
  onImport,
  editDataSource
}) => {
  var _editDataSource$index, _editDataSource$index2, _userStats$maxAllowed;
  const modalTitleId = (0, _eui.useGeneratedHtmlId)();
  const [selectedOptions, setSelected] = (0, _react.useState)((_editDataSource$index = editDataSource === null || editDataSource === void 0 ? void 0 : (_editDataSource$index2 = editDataSource.indexPattern) === null || _editDataSource$index2 === void 0 ? void 0 : _editDataSource$index2.split(',').map(index => ({
    label: index
  }))) !== null && _editDataSource$index !== void 0 ? _editDataSource$index : []);
  const [isCreateIndexModalOpen, {
    on: showCreateIndexModal,
    off: hideCreateIndexModal
  }] = (0, _reactHooks.useBoolean)(false);
  const {
    addError
  } = (0, _use_app_toasts.useAppToasts)();
  const [searchQuery, setSearchQuery] = (0, _react.useState)(undefined);
  const {
    data: indices,
    isFetching,
    error,
    refetch
  } = (0, _use_fetch_privileged_user_indices.useFetchPrivilegedUserIndices)(searchQuery);
  const debouncedSetSearchQuery = (0, _reactHooks.useDebounceFn)(setSearchQuery, DEBOUNCE_OPTIONS);
  const {
    registerPrivMonMonitoredIndices,
    updatePrivMonMonitoredIndices
  } = (0, _api.useEntityAnalyticsRoutes)();
  const {
    userStats
  } = (0, _use_privileged_monitoring_health.useUserLimitStatus)();
  const maxUsersAllowed = (_userStats$maxAllowed = userStats === null || userStats === void 0 ? void 0 : userStats.maxAllowed) !== null && _userStats$maxAllowed !== void 0 ? _userStats$maxAllowed : 10000; // fallback to default config value
  const options = (0, _react.useMemo)(() => {
    var _indices$map;
    return (_indices$map = indices === null || indices === void 0 ? void 0 : indices.map(index => ({
      label: index
    }))) !== null && _indices$map !== void 0 ? _indices$map : [];
  }, [indices]);
  (0, _react.useEffect)(() => {
    if (error != null) {
      addError(error, {
        title: LOADING_ERROR_MESSAGE
      });
    }
  }, [addError, error]);
  const addPrivilegedUsers = (0, _react.useCallback)(async () => {
    if (selectedOptions.length > 0) {
      if (editDataSource !== null && editDataSource !== void 0 && editDataSource.id) {
        await updatePrivMonMonitoredIndices(editDataSource.id, selectedOptions.map(({
          label
        }) => label).join(','));
      } else {
        await registerPrivMonMonitoredIndices(selectedOptions.map(({
          label
        }) => label).join(','));
      }
      onImport(0); // The API does not return the user count because it is not available at this point.
    }
  }, [editDataSource === null || editDataSource === void 0 ? void 0 : editDataSource.id, onImport, registerPrivMonMonitoredIndices, selectedOptions, updatePrivMonMonitoredIndices]);
  const onCreateIndex = (0, _react.useCallback)(indexName => {
    hideCreateIndexModal();
    setSelected(selectedOptions.concat({
      label: indexName
    }));
    refetch();
  }, [hideCreateIndexModal, refetch, selectedOptions, setSelected]);
  return isCreateIndexModalOpen ? /*#__PURE__*/_react.default.createElement(_create_index_modal.CreateIndexModal, {
    onClose: hideCreateIndexModal,
    onCreate: onCreateIndex,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 124,
      columnNumber: 5
    }
  }) : /*#__PURE__*/_react.default.createElement(_eui.EuiModal, {
    onClose: onClose,
    maxWidth: "624px",
    "data-test-subj": "index-selector-modal",
    "aria-labelledby": modalTitleId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 126,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeader, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 132,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeaderTitle, {
    id: modalTitleId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 133,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.entityAnalytics.privilegedUserMonitoring.selectIndex.title",
    defaultMessage: "Select index",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 134,
      columnNumber: 11
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiModalBody, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 140,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 141,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.entityAnalytics.privilegedUserMonitoring.selectIndex.description",
    defaultMessage: "Add your privileged users by selecting one or more indices as a data source. All users specified in the {nameField} field will be defined as privileged users (maximum number allowed: {maxPrivilegedUsersAllowed}).",
    values: {
      nameField: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 146,
          columnNumber: 26
        }
      }, 'user.name'),
      maxPrivilegedUsersAllowed: maxUsersAllowed
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 142,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 151,
      columnNumber: 9
    }
  }), error ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    announceOnMount: true,
    color: "danger",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 154,
      columnNumber: 13
    }
  }, LOADING_ERROR_MESSAGE), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 157,
      columnNumber: 13
    }
  })) : null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.entityAnalytics.privilegedUserMonitoring.selectIndex.comboboxLabel",
      defaultMessage: "Index",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 162,
        columnNumber: 13
      }
    }),
    fullWidth: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 160,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
    isLoading: isFetching && !error,
    fullWidth: true,
    "aria-label": SELECT_INDEX_LABEL,
    placeholder: SELECT_INDEX_LABEL,
    options: options,
    selectedOptions: selectedOptions,
    onChange: setSelected,
    isClearable: true,
    onSearchChange: query => {
      debouncedSetSearchQuery.run(query);
    },
    async: true,
    optionMatcher: _ => false // prevent the combo box from searching on the client side
    ,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 169,
      columnNumber: 11
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiModalFooter, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 186,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 187,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 188,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    iconType: "plusInCircle",
    onClick: showCreateIndexModal,
    "data-test-subj": "create-index-button",
    "aria-label": _i18n.i18n.translate('xpack.securitySolution.entityAnalytics.privilegedUserMonitoring.selectIndex.createIndexButtonAriaLabel', {
      defaultMessage: 'Create index'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 189,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.entityAnalytics.privilegedUserMonitoring.selectIndex.createIndexButtonLabel",
    defaultMessage: "Create index",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 198,
      columnNumber: 15
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 204,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "flexEnd",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 205,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    onClick: onClose,
    "aria-label": _i18n.i18n.translate('xpack.securitySolution.entityAnalytics.privilegedUserMonitoring.selectIndex.cancelButtonAriaLabel', {
      defaultMessage: 'Cancel'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 206,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.entityAnalytics.privilegedUserMonitoring.selectIndex.cancelButtonLabel",
    defaultMessage: "Cancel",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 213,
      columnNumber: 17
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    onClick: addPrivilegedUsers,
    fill: true,
    disabled: selectedOptions.length === 0,
    "data-test-subj": "privileged-user-monitoring-update-button",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 218,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.entityAnalytics.privilegedUserMonitoring.selectIndex.addUserButtonLabel",
    defaultMessage: "Update privileged users",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 224,
      columnNumber: 17
    }
  })))))));
};
exports.IndexSelectorModal = IndexSelectorModal;