"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PrivilegedUserMonitoringValidationStep = void 0;
var _eui = require("@elastic/eui");
var _react = require("@emotion/react");
var _react2 = _interopRequireDefault(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _telemetry = require("../../../../../../common/lib/telemetry");
var _kibana = require("../../../../../../common/lib/kibana");
var _download_blob = require("../../../../../../common/utils/download_blob");
var _helpers = require("../helpers");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763899475283842490/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/entity_analytics/components/privileged_user_monitoring_onboarding/components/file_uploader/components/validation_step.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const CODE_BLOCK_HEIGHT = 250;
const INVALID_FILE_NAME = `invalid_privileged_user_monitoring.csv`;
const PrivilegedUserMonitoringValidationStep = exports.PrivilegedUserMonitoringValidationStep = /*#__PURE__*/_react2.default.memo(({
  validatedFile,
  isLoading,
  onConfirm,
  onReturn
}) => {
  const {
    validLines,
    invalidLines,
    size: fileSize,
    name: fileName
  } = validatedFile;
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const {
    telemetry
  } = (0, _kibana.useKibana)().services;
  const annotations = (0, _helpers.buildAnnotationsFromError)(invalidLines.errors);
  const onConfirmClick = () => {
    telemetry.reportEvent(_telemetry.EntityEventTypes.PrivilegedUserMonitoringCsvImported, {
      file: {
        size: fileSize
      }
    });
    onConfirm();
  };
  return /*#__PURE__*/_react2.default.createElement("div", {
    "data-test-subj": "privileged-user-monitoring-validation-step",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 54,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react2.default.createElement("b", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 55,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react2.default.createElement(_i18nReact.FormattedMessage, {
    defaultMessage: "{fileName} preview",
    id: "xpack.securitySolution.entityAnalytics.privilegedUserMonitoring.validationStep.fileNamePreviewText",
    values: {
      fileName
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 56,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react2.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 62,
      columnNumber: 9
    }
  }), validLines.count > 0 && /*#__PURE__*/_react2.default.createElement(_react2.default.Fragment, null, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "baseline",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 65,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    grow: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 66,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 67,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 68,
      columnNumber: 19
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiIcon, {
    type: 'checkInCircleFilled',
    color: "success",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 69,
      columnNumber: 21
    }
  })), /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 71,
      columnNumber: 19
    }
  }, /*#__PURE__*/_react2.default.createElement("span", {
    "data-test-subj": "privileged-user-monitoring-validLinesMessage",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 72,
      columnNumber: 21
    }
  }, /*#__PURE__*/_react2.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.entityAnalytics.privilegedUserMonitoring.validationStep.validLinesMessage",
    defaultMessage: "{validLinesCount, plural, one {{validLinesCountBold} user will be added} other {{validLinesCountBold} users will be added}}",
    values: {
      validLinesCount: validLines.count,
      validLinesCountBold: /*#__PURE__*/_react2.default.createElement("b", {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 78,
          columnNumber: 48
        }
      }, validLines.count)
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 73,
      columnNumber: 23
    }
  }))))), /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 86,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiButtonEmpty, {
    flush: "right",
    onClick: onReturn,
    size: "xs",
    disabled: isLoading,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 87,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react2.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.entityAnalytics.privilegedUserMonitoring.validationStep.chooseAnotherFileText",
    defaultMessage: "Choose another file",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 88,
      columnNumber: 19
    }
  })))), /*#__PURE__*/_react2.default.createElement(_eui.EuiSpacer, {
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 95,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react2.default.createElement(_eui.EuiCodeBlock, {
    overflowHeight: CODE_BLOCK_HEIGHT,
    lineNumbers: true,
    language: "CSV",
    isVirtualized: true,
    css: (0, _react.css)`
                border: ${euiTheme.border.width.thin} solid ${euiTheme.colors.accentSecondary};
              `,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 96,
      columnNumber: 13
    }
  }, validLines.text), /*#__PURE__*/_react2.default.createElement(_eui.EuiSpacer, {
    size: "l",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 107,
      columnNumber: 13
    }
  })), invalidLines.count > 0 && /*#__PURE__*/_react2.default.createElement(_react2.default.Fragment, null, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "baseline",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 113,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    grow: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 114,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 115,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 116,
      columnNumber: 19
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiIcon, {
    type: 'error',
    color: "danger",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 117,
      columnNumber: 21
    }
  })), /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 119,
      columnNumber: 19
    }
  }, /*#__PURE__*/_react2.default.createElement("span", {
    "data-test-subj": "privileged-user-monitoring-invalidLinesMessage",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 120,
      columnNumber: 21
    }
  }, /*#__PURE__*/_react2.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.entityAnalytics.privilegedUserMonitoring.validationStep.invalidLinesMessage",
    defaultMessage: "{invalidLinesCount, plural, one {{invalidLinesCountBold} row is invalid and won't be added} other {{invalidLinesCountBold} rows are invalid and won\u2019t be added}}",
    values: {
      invalidLinesCount: invalidLines.count,
      invalidLinesCountBold: /*#__PURE__*/_react2.default.createElement("b", {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 126,
          columnNumber: 50
        }
      }, invalidLines.count)
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 121,
      columnNumber: 23
    }
  }))))), /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 134,
      columnNumber: 15
    }
  }, invalidLines.text && /*#__PURE__*/_react2.default.createElement(_eui.EuiButtonEmpty, {
    size: "xs",
    flush: "right",
    disabled: isLoading,
    onClick: () => {
      if (invalidLines.text.length > 0) {
        (0, _download_blob.downloadBlob)(new Blob([invalidLines.text]), INVALID_FILE_NAME);
      }
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 136,
      columnNumber: 19
    }
  }, /*#__PURE__*/_react2.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.entityAnalytics.privilegedUserMonitoring.validationStep.downloadCSV",
    defaultMessage: "Download CSV",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 146,
      columnNumber: 21
    }
  })))), /*#__PURE__*/_react2.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 155,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react2.default.createElement(_eui.EuiCodeBlock, {
    overflowHeight: CODE_BLOCK_HEIGHT,
    lineNumbers: {
      annotations
    },
    language: "CSV",
    isVirtualized: true,
    css: (0, _react.css)`
                border: 1px solid ${euiTheme.colors.danger};
              `,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 156,
      columnNumber: 13
    }
  }, invalidLines.text)), /*#__PURE__*/_react2.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 170,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween",
    alignItems: "baseline",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 172,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 173,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiButtonEmpty, {
    onClick: onReturn,
    disabled: isLoading,
    "data-test-subj": "privileged-user-monitoring-modal-back-button",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 174,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react2.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.entityAnalytics.privilegedUserMonitoring.validationStep.backButtonText",
    defaultMessage: "Back",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 179,
      columnNumber: 15
    }
  }))), /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 186,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiButton, {
    fill: true,
    onClick: onConfirmClick,
    disabled: validLines.count === 0,
    "data-test-subj": "privileged-user-monitoring-assign-button",
    isLoading: isLoading,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 187,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react2.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.entityAnalytics.privilegedUserMonitoring.validationStep.addButtonText",
    defaultMessage: "Add privileged users",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 194,
      columnNumber: 15
    }
  })))));
});
PrivilegedUserMonitoringValidationStep.displayName = 'PrivilegedUserMonitoringValidationStep';