"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EsqlDashboardPanel = exports.DEFAULT_PAGE_SIZE = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _fp = require("lodash/fp");
var _react2 = require("@emotion/react");
var _Either = require("fp-ts/Either");
var _inspect = require("../../../../../common/components/inspect");
var _types = require("../../../../../common/components/visualization_actions/types");
var _use_error_toast = require("../../../../../common/hooks/use_error_toast");
var _visualization_embeddable = require("../../../../../common/components/visualization_actions/visualization_embeddable");
var _hooks = require("./hooks");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763899475283842490/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/entity_analytics/components/privileged_user_monitoring_onboarding/components/esql_dashboard_panel/esql_dashboard_panel.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const DEFAULT_PAGE_SIZE = exports.DEFAULT_PAGE_SIZE = 10;
const EsqlDashboardPanel = ({
  stackByField,
  generateVisualizationQuery,
  generateTableQuery,
  getLensAttributes,
  columns,
  timerange,
  pageSize = DEFAULT_PAGE_SIZE,
  showInspectTable = false,
  title
}) => {
  const [sortField, setSortField] = (0, _react.useState)('@timestamp');
  const [sortDirection, setSortDirection] = (0, _react.useState)('asc');
  const [currentPage, setCurrentPage] = (0, _react.useState)(1);
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const tableQuery = (0, _react.useMemo)(() => generateTableQuery(sortField, sortDirection, currentPage), [sortField, sortDirection, currentPage, generateTableQuery]);
  const visualizationQuery = (0, _react.useMemo)(() => generateVisualizationQuery(stackByField, timerange), [generateVisualizationQuery, stackByField, timerange]);
  const {
    records: items,
    error,
    isLoading,
    isInitialLoading,
    isRefetching,
    isError
  } = (0, _hooks.useDashboardTableQuery)(tableQuery);
  const onTableChange = ({
    sort
  }) => {
    if (sort) {
      const {
        field,
        direction
      } = sort;
      setSortField(field);
      setSortDirection(direction);
    }
  };
  (0, _use_error_toast.useErrorToast)(_i18n.i18n.translate('xpack.securitySolution.genericDashboard.queryError', {
    defaultMessage: 'There was an error loading the data'
  }), error);
  if ((0, _Either.isLeft)(visualizationQuery)) {
    var _visualizationQuery$l;
    return /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
      title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.securitySolution.entityAnalytics.privilegedUserMonitoring.userActivity.missingMappings.errorTitle",
        defaultMessage: "There was a problem rendering the visualization",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 107,
          columnNumber: 11
        }
      }),
      color: "warning",
      iconType: "error",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 105,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.entityAnalytics.privilegedUserMonitoring.userActivity.missingMappings.errorMessage",
      defaultMessage: "The following required fields are not present in the Security Data View:",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 115,
        columnNumber: 9
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 119,
        columnNumber: 9
      }
    }), /*#__PURE__*/_react.default.createElement("ul", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 120,
        columnNumber: 9
      }
    }, (_visualizationQuery$l = visualizationQuery.left.invalidFields) === null || _visualizationQuery$l === void 0 ? void 0 : _visualizationQuery$l.map((field, index) => /*#__PURE__*/_react.default.createElement("li", {
      key: index,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 122,
        columnNumber: 13
      }
    }, field))));
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    "data-test-subj": "genericDashboardSections",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 131,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_visualization_embeddable.VisualizationEmbeddable, {
    stackByField: stackByField,
    esql: visualizationQuery.right,
    "data-test-subj": "genericDashboardEmbeddableHistogram",
    getLensAttributes: getLensAttributes,
    height: 260,
    id: "GenericDashboard",
    timerange: timerange,
    withActions: [_types.VisualizationContextMenuActions.inspect, _types.VisualizationContextMenuActions.addToNewCase, _types.VisualizationContextMenuActions.addToExistingCase, _types.VisualizationContextMenuActions.saveToLibrary
    // Excluding VisualizationContextMenuActions.openInLens
    ],
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 132,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 149,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 151,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 152,
      columnNumber: 9
    }
  }, isLoading ? /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 154,
      columnNumber: 13
    }
  }) : isError ? /*#__PURE__*/_react.default.createElement("div", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 156,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: _i18n.i18n.translate('xpack.securitySolution.genericDashboard.errorLoadingData', {
      defaultMessage: 'Error loading data'
    }),
    color: "danger",
    iconType: "error",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 157,
      columnNumber: 15
    }
  })) : /*#__PURE__*/_react.default.createElement(_inspect.InspectButtonContainer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 166,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement("div", {
    // Anchors the position absolute inspect button (nearest positioned ancestor)
    css: (0, _react2.css)`
                  position: relative;
                `,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 167,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement("div", {
    // Position the inspect button above the table
    css: (0, _react2.css)`
                    position: absolute;
                    right: 0;
                    top: -${euiTheme.size.base};
                  `,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 173,
      columnNumber: 17
    }
  }, showInspectTable && /*#__PURE__*/_react.default.createElement(_inspect.InspectButton, {
    queryId: _hooks.DASHBOARD_TABLE_QUERY_ID,
    title: title,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 182,
      columnNumber: 21
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiBasicTable, {
    id: _hooks.DASHBOARD_TABLE_QUERY_ID,
    loading: isInitialLoading || isRefetching,
    items: (0, _fp.take)(currentPage * pageSize, items) || [],
    onChange: onTableChange,
    sorting: {
      sort: {
        field: sortField,
        direction: sortDirection
      }
    },
    columns: columns,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 185,
      columnNumber: 17
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 201,
      columnNumber: 11
    }
  })), items.length > currentPage * pageSize && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 205,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    isLoading: isInitialLoading || isRefetching,
    onClick: () => {
      setCurrentPage(page => page + 1);
    },
    flush: "right",
    color: "primary",
    size: "s",
    iconType: "sortDown",
    iconSide: "right",
    iconSize: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 206,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.genericDashboard.showMore",
    defaultMessage: "Show more",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 218,
      columnNumber: 15
    }
  })))));
};
exports.EsqlDashboardPanel = EsqlDashboardPanel;