"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.rowItems = exports.HostRiskScoreTable = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _eui = require("@elastic/eui");
var _paginated_table = require("../../../explore/components/paginated_table");
var _use_selector = require("../../../common/hooks/use_selector");
var _store = require("../../../explore/hosts/store");
var _columns = require("./columns");
var _types = require("../../../../common/entity_analytics/types");
var i18n = _interopRequireWildcard(require("../../../explore/hosts/components/hosts_table/translations"));
var i18nHosts = _interopRequireWildcard(require("./translations"));
var _severity_badges = require("../severity/severity_badges");
var _severity_bar = require("../severity/severity_bar");
var _severity_filter = require("../severity/severity_filter");
var _risk_information = require("../risk_information");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763899475283842490/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/entity_analytics/components/host_risk_score_table/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const rowItems = exports.rowItems = [{
  text: i18n.ROWS_5,
  numberOfRow: 5
}, {
  text: i18n.ROWS_10,
  numberOfRow: 10
}];
const tableType = _store.hostsModel.HostsTableType.risk;
const HostRiskScoreTableComponent = ({
  data,
  id,
  isInspect,
  loading,
  loadPage,
  setQuerySkip,
  severityCount,
  totalCount,
  type
}) => {
  const dispatch = (0, _reactRedux.useDispatch)();
  const getHostRiskScoreSelector = (0, _react.useMemo)(() => _store.hostsSelectors.hostRiskScoreSelector(), []);
  const {
    activePage,
    limit,
    sort
  } = (0, _use_selector.useDeepEqualSelector)(state => getHostRiskScoreSelector(state, _store.hostsModel.HostsType.page));
  const updateLimitPagination = (0, _react.useCallback)(newLimit => dispatch(_store.hostsActions.updateTableLimit({
    hostsType: type,
    limit: newLimit,
    tableType
  })), [type, dispatch]);
  const updateActivePage = (0, _react.useCallback)(newPage => dispatch(_store.hostsActions.updateTableActivePage({
    activePage: newPage,
    hostsType: type,
    tableType
  })), [type, dispatch]);
  const onSort = (0, _react.useCallback)(criteria => {
    if (criteria.sort != null) {
      const newSort = criteria.sort;
      if (newSort.direction !== sort.direction || newSort.field !== sort.field) {
        dispatch(_store.hostsActions.updateHostRiskScoreSort({
          sort: newSort,
          hostsType: type
        }));
      }
    }
  }, [dispatch, sort, type]);
  const dispatchSeverityUpdate = (0, _react.useCallback)(s => {
    dispatch(_store.hostsActions.updateHostRiskScoreSeverityFilter({
      severitySelection: [s],
      hostsType: type
    }));
  }, [dispatch, type]);
  const columns = (0, _react.useMemo)(() => (0, _columns.getHostRiskScoreColumns)({
    dispatchSeverityUpdate
  }), [dispatchSeverityUpdate]);
  const risk = /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 146,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 147,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_severity_badges.SeverityBadges, {
    severityCount: severityCount,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 148,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 150,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_severity_bar.SeverityBar, {
    severityCount: severityCount,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 151,
      columnNumber: 9
    }
  })));
  const getHostRiskScoreFilterQuerySelector = (0, _react.useMemo)(() => _store.hostsSelectors.hostRiskScoreSeverityFilterSelector(), []);
  const severitySelectionRedux = (0, _use_selector.useDeepEqualSelector)(state => getHostRiskScoreFilterQuerySelector(state, type));
  const onSelect = (0, _react.useCallback)(newSelection => {
    dispatch(_store.hostsActions.updateHostRiskScoreSeverityFilter({
      severitySelection: newSelection,
      hostsType: type
    }));
  }, [dispatch, type]);
  return /*#__PURE__*/_react.default.createElement(_paginated_table.PaginatedTable, {
    activePage: activePage,
    columns: columns,
    dataTestSubj: `table-${tableType}`,
    headerCount: totalCount,
    headerFilters: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      gutterSize: "s",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 183,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 184,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_risk_information.RiskInformationButtonEmpty, {
      riskEntity: _types.EntityType.host,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 185,
        columnNumber: 13
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 187,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFilterGroup, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 188,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_severity_filter.SeverityFilter, {
      selectedItems: severitySelectionRedux,
      onSelect: onSelect,
      riskEntity: _types.EntityType.host,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 189,
        columnNumber: 15
      }
    })))),
    headerSupplement: risk,
    headerTitle: i18nHosts.HOST_RISK_TITLE,
    headerUnit: i18n.UNIT(totalCount),
    id: id,
    isInspect: isInspect,
    itemsPerRow: rowItems,
    limit: limit,
    loading: loading,
    loadPage: loadPage,
    onChange: onSort,
    pageOfItems: data,
    setQuerySkip: setQuerySkip,
    showMorePagesIndicator: false,
    sorting: sort,
    split: true,
    stackHeader: true,
    totalCount: totalCount,
    updateLimitPagination: updateLimitPagination,
    updateActivePage: updateActivePage,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 177,
      columnNumber: 5
    }
  });
};
HostRiskScoreTableComponent.displayName = 'HostRiskScoreTableComponent';
const HostRiskScoreTable = exports.HostRiskScoreTable = /*#__PURE__*/_react.default.memo(HostRiskScoreTableComponent);
HostRiskScoreTable.displayName = 'HostRiskScoreTable';