"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SearchBarSection = exports.SEARCH_BAR_TEST_ID = void 0;
var _react = _interopRequireWildcard(require("react"));
var _constants = require("../../../../common/store/inputs/constants");
var _filters_global = require("../../../../common/components/filters_global");
var _search_bar = require("../../../../common/components/search_bar");
var _use_signal_helpers = require("../../../../sourcerer/containers/use_signal_helpers");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763899475283842490/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/detections/components/alerts/search_bar/search_bar_section.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const SEARCH_BAR_TEST_ID = exports.SEARCH_BAR_TEST_ID = 'alerts-page-search-bar';
/**
 * UI section of the alerts page that renders the global search bar.
 */
const SearchBarSection = exports.SearchBarSection = /*#__PURE__*/(0, _react.memo)(({
  dataView
}) => {
  const {
    pollForSignalIndex
  } = (0, _use_signal_helpers.useSignalHelpers)();
  return /*#__PURE__*/_react.default.createElement(_filters_global.FiltersGlobal, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 31,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_search_bar.SiemSearchBar, {
    dataTestSubj: SEARCH_BAR_TEST_ID,
    id: _constants.InputsModelId.global,
    pollForSignalIndex: pollForSignalIndex,
    sourcererDataView: dataView,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 32,
      columnNumber: 7
    }
  }));
});
SearchBarSection.displayName = 'SearchBarSection';