"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useSorting = void 0;
var _react = require("react");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useSorting = (defaultField, defaultOrder) => {
  const [sortField, setSortField] = (0, _react.useState)(defaultField);
  const [sortOrder, setSortOrder] = (0, _react.useState)(defaultOrder);
  const state = (0, _react.useMemo)(() => {
    return {
      sort: {
        field: sortField,
        direction: sortOrder
      }
    };
  }, [sortField, sortOrder]);
  const update = (0, _react.useCallback)(criteria => {
    if (criteria.sort) {
      setSortField(criteria.sort.field);
      setSortOrder(criteria.sort.direction);
    }
  }, [setSortField, setSortOrder]);
  return (0, _react.useMemo)(() => ({
    state,
    update
  }), [state, update]);
};
exports.useSorting = useSorting;