"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LogLevelFilter = void 0;
var _react = _interopRequireWildcard(require("react"));
var _rule_monitoring = require("../../../../../../../common/api/detection_engine/rule_monitoring");
var _log_level_indicator = require("../../indicators/log_level_indicator");
var _multiselect_filter = require("../multiselect_filter");
var i18n = _interopRequireWildcard(require("./translations"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763899475283842490/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/detection_engine/rule_monitoring/components/basic/filters/log_level_filter/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const LogLevelFilterComponent = ({
  selectedItems,
  onChange
}) => {
  const renderItem = (0, _react.useCallback)(item => {
    return /*#__PURE__*/_react.default.createElement(_log_level_indicator.LogLevelIndicator, {
      logLevel: item,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 24,
        columnNumber: 12
      }
    });
  }, []);
  return /*#__PURE__*/_react.default.createElement(_multiselect_filter.MultiselectFilter, {
    dataTestSubj: "logLevelFilter",
    title: i18n.FILTER_TITLE,
    items: _rule_monitoring.LOG_LEVELS,
    selectedItems: selectedItems,
    onSelectionChange: onChange,
    renderItem: renderItem,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 28,
      columnNumber: 5
    }
  });
};
const LogLevelFilter = exports.LogLevelFilter = /*#__PURE__*/_react.default.memo(LogLevelFilterComponent);
LogLevelFilter.displayName = 'LogLevelFilter';