"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SimpleRuleScheduleForm = SimpleRuleScheduleForm;
var _react = _interopRequireDefault(require("react"));
var _time_duration = require("@kbn/securitysolution-utils/time_duration");
var _to_simple_rule_schedule = require("../../../../../../../../../common/api/detection_engine/model/rule_schema/to_simple_rule_schedule");
var _field_final_side = require("../../../field_final_side");
var _simple_rule_schedule_adapter = require("./simple_rule_schedule_adapter");
var _invariant = require("../../../../../../../../../common/utils/invariant");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763899475283842490/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/detection_engine/rule_management/components/rule_details/three_way_diff/final_edit/fields/rule_schedule/simple_rule_schedule_form.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function SimpleRuleScheduleForm() {
  return /*#__PURE__*/_react.default.createElement(_field_final_side.RuleFieldEditFormWrapper, {
    component: _simple_rule_schedule_adapter.SimpleRuleScheduleAdapter,
    serializer: serializer,
    deserializer: deserializer,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 23,
      columnNumber: 5
    }
  });
}
function deserializer(_, finalRule) {
  const simpleRuleSchedule = (0, _to_simple_rule_schedule.toSimpleRuleSchedule)(finalRule.rule_schedule);
  (0, _invariant.invariant)(simpleRuleSchedule, 'Unable to calculate simple rule schedule');
  return {
    interval: simpleRuleSchedule.interval,
    lookback: simpleRuleSchedule.lookback
  };
}
function serializer(formData) {
  const interval = _time_duration.TimeDuration.parse(formData.interval);
  const lookBack = _time_duration.TimeDuration.parse(formData.lookback);
  (0, _invariant.invariant)(interval !== undefined && interval.value > 0, 'Rule interval is invalid');
  (0, _invariant.invariant)(lookBack !== undefined && lookBack.value >= 0, "Rule's look-back is invalid");
  const fromOffsetMs = interval.toMilliseconds() + lookBack.toMilliseconds();
  const fromOffset = _time_duration.TimeDuration.fromMilliseconds(fromOffsetMs);
  const from = `now-${fromOffset}`;
  return {
    rule_schedule: {
      interval: formData.interval,
      from,
      to: 'now'
    }
  };
}