"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DataSourceEditForm = DataSourceEditForm;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _index_pattern_validator_factory = require("../../../../../../../rule_creation_ui/validators/index_pattern_validator_factory");
var _data_view_id_validator_factory = require("../../../../../../../rule_creation_ui/validators/data_view_id_validator_factory");
var _shared_imports = require("../../../../../../../../shared_imports");
var _prebuilt_rules = require("../../../../../../../../../common/api/detection_engine/prebuilt_rules");
var _field_final_side = require("../../../field_final_side");
var _data_source_edit = require("./data_source_edit");
var _translations = require("../../../../../../../rule_creation_ui/components/step_define_rule/translations");
var i18n = _interopRequireWildcard(require("./translations"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763899475283842490/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/detection_engine/rule_management/components/rule_details/three_way_diff/final_edit/fields/data_source/data_source_edit_form.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function DataSourceEditForm() {
  return /*#__PURE__*/_react.default.createElement(_field_final_side.RuleFieldEditFormWrapper, {
    component: _data_source_edit.DataSourceEdit,
    ruleFieldFormSchema: dataSourceSchema,
    deserializer: dataSourceDeserializer,
    serializer: dataSourceSerializer,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 27,
      columnNumber: 5
    }
  });
}
function dataSourceDeserializer(defaultValue) {
  if (!defaultValue.data_source) {
    throw new Error(`dataSourceDeserializer expects "data_source" field`);
  }
  return defaultValue.data_source;
}
function dataSourceSerializer(formData) {
  return {
    data_source: formData
  };
}
const dataSourceSchema = {
  type: {
    default: _prebuilt_rules.DataSourceType.index_patterns
  },
  index_patterns: {
    defaultValue: [],
    type: _shared_imports.FIELD_TYPES.COMBO_BOX,
    label: i18n.INDEX_PATTERNS,
    helpText: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "xs",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 58,
        columnNumber: 15
      }
    }, _translations.INDEX_HELPER_TEXT),
    validations: [{
      validator: (...args) => {
        const [{
          formData
        }] = args;
        if (formData.type !== _prebuilt_rules.DataSourceType.index_patterns) {
          return;
        }
        return (0, _index_pattern_validator_factory.indexPatternValidatorFactory)()(...args);
      }
    }]
  },
  data_view_id: {
    label: i18n.DATA_VIEW,
    validations: [{
      validator: (...args) => {
        const [{
          formData
        }] = args;
        if (formData.type !== _prebuilt_rules.DataSourceType.data_view) {
          return;
        }
        return (0, _data_view_id_validator_factory.dataViewIdValidatorFactory)()(...args);
      }
    }]
  }
};