"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getSubfieldChangesForRuleSchedule = getSubfieldChangesForRuleSchedule;
var _to_simple_rule_schedule = require("../../../../../../../../common/api/detection_engine/model/rule_schema/to_simple_rule_schedule");
var _utils = require("../utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function getSubfieldChangesForRuleSchedule(oldFieldValue, newFieldValue) {
  const oldSimpleRuleSchedule = oldFieldValue ? (0, _to_simple_rule_schedule.toSimpleRuleSchedule)(oldFieldValue) : undefined;
  const newSimpleRuleSchedule = newFieldValue ? (0, _to_simple_rule_schedule.toSimpleRuleSchedule)(newFieldValue) : undefined;
  if (oldSimpleRuleSchedule && newSimpleRuleSchedule) {
    return getSubfieldChangesForSimpleRuleSchedule(oldSimpleRuleSchedule, newSimpleRuleSchedule);
  }
  const changes = [];
  if ((oldFieldValue === null || oldFieldValue === void 0 ? void 0 : oldFieldValue.interval) !== (newFieldValue === null || newFieldValue === void 0 ? void 0 : newFieldValue.interval)) {
    changes.push({
      subfieldName: 'interval',
      oldSubfieldValue: (0, _utils.stringifyToSortedJson)(oldFieldValue === null || oldFieldValue === void 0 ? void 0 : oldFieldValue.interval),
      newSubfieldValue: (0, _utils.stringifyToSortedJson)(newFieldValue === null || newFieldValue === void 0 ? void 0 : newFieldValue.interval)
    });
  }
  if ((oldFieldValue === null || oldFieldValue === void 0 ? void 0 : oldFieldValue.from) !== (newFieldValue === null || newFieldValue === void 0 ? void 0 : newFieldValue.from)) {
    changes.push({
      subfieldName: 'from',
      oldSubfieldValue: (0, _utils.stringifyToSortedJson)(oldFieldValue === null || oldFieldValue === void 0 ? void 0 : oldFieldValue.from),
      newSubfieldValue: (0, _utils.stringifyToSortedJson)(newFieldValue === null || newFieldValue === void 0 ? void 0 : newFieldValue.from)
    });
  }
  if ((oldFieldValue === null || oldFieldValue === void 0 ? void 0 : oldFieldValue.to) !== (newFieldValue === null || newFieldValue === void 0 ? void 0 : newFieldValue.to)) {
    changes.push({
      subfieldName: 'to',
      oldSubfieldValue: (0, _utils.stringifyToSortedJson)(oldFieldValue === null || oldFieldValue === void 0 ? void 0 : oldFieldValue.to),
      newSubfieldValue: (0, _utils.stringifyToSortedJson)(newFieldValue === null || newFieldValue === void 0 ? void 0 : newFieldValue.to)
    });
  }
  return changes;
}
function getSubfieldChangesForSimpleRuleSchedule(oldFieldValue, newFieldValue) {
  const changes = [];
  if (oldFieldValue.interval !== newFieldValue.interval) {
    changes.push({
      subfieldName: 'interval',
      oldSubfieldValue: (0, _utils.stringifyToSortedJson)(oldFieldValue === null || oldFieldValue === void 0 ? void 0 : oldFieldValue.interval),
      newSubfieldValue: (0, _utils.stringifyToSortedJson)(newFieldValue === null || newFieldValue === void 0 ? void 0 : newFieldValue.interval)
    });
  }
  if (oldFieldValue.lookback !== newFieldValue.lookback) {
    changes.push({
      subfieldName: 'lookback',
      oldSubfieldValue: (0, _utils.stringifyToSortedJson)(oldFieldValue.lookback),
      newSubfieldValue: (0, _utils.stringifyToSortedJson)(newFieldValue.lookback)
    });
  }
  return changes;
}