"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StopBackfill = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _use_app_toasts = require("../../../../common/hooks/use_app_toasts");
var _use_delete_backfill = require("../../api/hooks/use_delete_backfill");
var i18n = _interopRequireWildcard(require("../../translations"));
var _kibana = require("../../../../common/lib/kibana");
var _telemetry = require("../../../../common/lib/telemetry");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763899475283842490/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/detection_engine/rule_gaps/components/rule_backfills_info/stop_backfill.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const StopBackfill = ({
  backfill
}) => {
  const confirmModalTitleId = (0, _eui.useGeneratedHtmlId)();
  const {
    telemetry
  } = (0, _kibana.useKibana)().services;
  const {
    addSuccess,
    addError
  } = (0, _use_app_toasts.useAppToasts)();
  const deleteBackfillMutation = (0, _use_delete_backfill.useDeleteBackfill)({
    onSuccess: () => {
      closeModal();
      telemetry.reportEvent(_telemetry.ManualRuleRunEventTypes.ManualRuleRunCancelJob, {
        totalTasks: backfill.total,
        completedTasks: backfill.complete,
        errorTasks: backfill.error
      });
      addSuccess(i18n.BACKFILLS_TABLE_STOP_CONFIRMATION_SUCCESS);
    },
    onError: error => {
      var _error$body$message, _error$body;
      addError(error, {
        title: i18n.BACKFILLS_TABLE_STOP_CONFIRMATION_ERROR,
        toastMessage: (_error$body$message = error === null || error === void 0 ? void 0 : (_error$body = error.body) === null || _error$body === void 0 ? void 0 : _error$body.message) !== null && _error$body$message !== void 0 ? _error$body$message : error.message
      });
    }
  });
  const [isModalVisible, setIsModalVisible] = (0, _react.useState)(false);
  const showModal = () => setIsModalVisible(true);
  const closeModal = () => setIsModalVisible(false);
  const onConfirm = () => {
    deleteBackfillMutation.mutate({
      backfillId: backfill.id
    });
  };
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    size: "s",
    color: 'primary',
    onClick: showModal,
    "data-test-subj": "rule-backfills-delete-button",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 47,
      columnNumber: 7
    }
  }, i18n.BACKFILLS_TABLE_STOP), isModalVisible && /*#__PURE__*/_react.default.createElement(_eui.EuiConfirmModal, {
    "aria-labelledby": confirmModalTitleId,
    titleProps: {
      id: confirmModalTitleId
    },
    "data-test-subj": "rule-backfills-delete-modal",
    title: i18n.BACKFILLS_TABLE_STOP_CONFIRMATION_TITLE,
    onCancel: closeModal,
    onConfirm: onConfirm,
    cancelButtonText: i18n.BACKFILLS_TABLE_STOP_CONFIRMATION_CANCEL,
    confirmButtonText: i18n.BACKFILLS_TABLE_STOP_CONFIRMATION_STOP_RUNS,
    defaultFocusedButton: "confirm",
    buttonColor: "danger",
    isLoading: deleteBackfillMutation.isLoading,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 56,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 69,
      columnNumber: 11
    }
  }, i18n.BACKFILLS_TABLE_STOP_CONFIRMATION_BODY)));
};
exports.StopBackfill = StopBackfill;