"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RuleActionsOverflow = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _rule_customizations_context = require("../../../../rule_management/components/rule_details/rule_customizations_diff/rule_customizations_context");
var _detection_engine = require("../../../../../../common/api/detection_engine");
var _use_schedule_rule_run = require("../../../../rule_gaps/logic/use_schedule_rule_run");
var _common = require("../../../../../../common");
var _constants = require("../../../../../../common/detection_engine/rule_management/constants");
var _rule_management = require("../../../../../../common/api/detection_engine/rule_management");
var _redirect_to_detection_engine = require("../../../../../common/components/link_to/redirect_to_detection_engine");
var _use_bool_state = require("../../../../../common/hooks/use_bool_state");
var _user_actions = require("../../../../../common/lib/apm/user_actions");
var _use_start_transaction = require("../../../../../common/lib/apm/use_start_transaction");
var _kibana = require("../../../../../common/lib/kibana");
var _privileges = require("../../../../../common/utils/privileges");
var _use_bulk_export = require("../../../../rule_management/logic/bulk_actions/use_bulk_export");
var _use_execute_bulk_action = require("../../../../rule_management/logic/bulk_actions/use_execute_bulk_action");
var _use_download_exported_rules = require("../../../../rule_management/logic/bulk_actions/use_download_exported_rules");
var i18nActions = _interopRequireWildcard(require("../../../../common/translations"));
var i18n = _interopRequireWildcard(require("./translations"));
var _telemetry = require("../../../../../common/lib/telemetry");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763899475283842490/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/detection_engine/rule_details_ui/pages/rule_details/rule_actions_overflow/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const MyEuiButtonIcon = (0, _styledComponents.default)(_eui.EuiButtonIcon)`
  &.euiButtonIcon {
    svg {
      transform: rotate(90deg);
    }

    border: 1px solid ${({
  theme
}) => theme.euiColorPrimary};
    width: 40px;
    height: 40px;
  }
`;
/**
 * Overflow Actions for a Rule
 */
const RuleActionsOverflowComponent = ({
  rule,
  userHasPermissions,
  canDuplicateRuleWithActions,
  showBulkDuplicateExceptionsConfirmation,
  showManualRuleRunConfirmation,
  confirmDeletion
}) => {
  const [isPopoverOpen,, closePopover, togglePopover] = (0, _use_bool_state.useBoolState)();
  const {
    application: {
      navigateToApp
    },
    telemetry
  } = (0, _kibana.useKibana)().services;
  const {
    startTransaction
  } = (0, _use_start_transaction.useStartTransaction)();
  const {
    executeBulkAction
  } = (0, _use_execute_bulk_action.useExecuteBulkAction)({
    suppressSuccessToast: true
  });
  const {
    bulkExport
  } = (0, _use_bulk_export.useBulkExport)();
  const downloadExportedRules = (0, _use_download_exported_rules.useDownloadExportedRules)();
  const {
    scheduleRuleRun
  } = (0, _use_schedule_rule_run.useScheduleRuleRun)();
  const onRuleDeletedCallback = (0, _react.useCallback)(() => {
    navigateToApp(_common.APP_UI_ID, {
      deepLinkId: _common.SecurityPageName.rules,
      path: (0, _redirect_to_detection_engine.getRulesUrl)()
    });
  }, [navigateToApp]);
  const {
    actions: {
      openCustomizationsRevertFlyout
    },
    state: {
      doesBaseVersionExist
    }
  } = (0, _rule_customizations_context.useRuleCustomizationsContext)();
  const actions = (0, _react.useMemo)(() => rule != null ? [/*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
    key: i18nActions.DUPLICATE_RULE,
    icon: "copy",
    disabled: !canDuplicateRuleWithActions || !userHasPermissions,
    "data-test-subj": "rules-details-duplicate-rule",
    onClick: async () => {
      startTransaction({
        name: _user_actions.SINGLE_RULE_ACTIONS.DUPLICATE
      });
      closePopover();
      const modalDuplicationConfirmationResult = await showBulkDuplicateExceptionsConfirmation();
      if (modalDuplicationConfirmationResult === null) {
        return;
      }
      const result = await executeBulkAction({
        type: _rule_management.BulkActionTypeEnum.duplicate,
        ids: [rule.id],
        duplicatePayload: {
          include_exceptions: modalDuplicationConfirmationResult === _constants.DuplicateOptions.withExceptions || modalDuplicationConfirmationResult === _constants.DuplicateOptions.withExceptionsExcludeExpiredExceptions,
          include_expired_exceptions: !(modalDuplicationConfirmationResult === _constants.DuplicateOptions.withExceptionsExcludeExpiredExceptions)
        }
      });
      const createdRules = result === null || result === void 0 ? void 0 : result.attributes.results.created;
      if (createdRules !== null && createdRules !== void 0 && createdRules.length) {
        (0, _use_execute_bulk_action.goToRuleEditPage)(createdRules[0].id, navigateToApp);
      }
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 100,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    position: "left",
    content: !(0, _privileges.canEditRuleWithActions)(rule, canDuplicateRuleWithActions) ? i18nActions.LACK_OF_KIBANA_ACTIONS_FEATURE_PRIVILEGES : undefined,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 134,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement("span", {
    tabIndex: 0,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 142,
      columnNumber: 17
    }
  }, i18nActions.DUPLICATE_RULE))), /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
    key: i18nActions.EXPORT_RULE,
    icon: "exportAction",
    disabled: !userHasPermissions,
    "data-test-subj": "rules-details-export-rule",
    onClick: async () => {
      startTransaction({
        name: _user_actions.SINGLE_RULE_ACTIONS.EXPORT
      });
      closePopover();
      const response = await bulkExport({
        ids: [rule.id]
      });
      if (response) {
        await downloadExportedRules(response);
      }
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 145,
      columnNumber: 13
    }
  }, i18nActions.EXPORT_RULE), /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
    key: i18nActions.MANUAL_RULE_RUN,
    icon: "play",
    disabled: !userHasPermissions || !rule.enabled,
    toolTipContent: !userHasPermissions || !rule.enabled ? i18nActions.MANUAL_RULE_RUN_TOOLTIP : '',
    "data-test-subj": "rules-details-manual-rule-run",
    onClick: async () => {
      startTransaction({
        name: _user_actions.SINGLE_RULE_ACTIONS.MANUAL_RULE_RUN
      });
      closePopover();
      const modalManualRuleRunConfirmationResult = await showManualRuleRunConfirmation();
      telemetry.reportEvent(_telemetry.ManualRuleRunEventTypes.ManualRuleRunOpenModal, {
        type: 'single'
      });
      if (modalManualRuleRunConfirmationResult === null) {
        return;
      }
      await scheduleRuleRun({
        ruleIds: [rule.id],
        timeRange: modalManualRuleRunConfirmationResult
      });
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 161,
      columnNumber: 13
    }
  }, i18nActions.MANUAL_RULE_RUN), ...((0, _detection_engine.isCustomizedPrebuiltRule)(rule) // Don't display action if rule isn't a customized prebuilt rule
  ? [/*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
    key: i18nActions.REVERT_RULE,
    toolTipContent: !doesBaseVersionExist ? i18nActions.REVERT_RULE_TOOLTIP_CONTENT : undefined,
    toolTipProps: {
      title: !doesBaseVersionExist ? i18nActions.REVERT_RULE_TOOLTIP_TITLE : undefined,
      'data-test-subj': 'rules-details-revert-rule-tooltip'
    },
    icon: "timeRefresh",
    disabled: !userHasPermissions || !doesBaseVersionExist,
    "data-test-subj": "rules-details-revert-rule",
    onClick: () => {
      closePopover();
      openCustomizationsRevertFlyout();
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 189,
      columnNumber: 19
    }
  }, i18nActions.REVERT_RULE)] : []), /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
    key: i18nActions.DELETE_RULE,
    icon: "trash",
    disabled: !userHasPermissions,
    "data-test-subj": "rules-details-delete-rule",
    onClick: async () => {
      closePopover();
      if ((await confirmDeletion()) === false) {
        // User has canceled deletion
        return;
      }
      startTransaction({
        name: _user_actions.SINGLE_RULE_ACTIONS.DELETE
      });
      await executeBulkAction({
        type: _rule_management.BulkActionTypeEnum.delete,
        ids: [rule.id]
      });
      onRuleDeletedCallback();
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 212,
      columnNumber: 13
    }
  }, i18nActions.DELETE_RULE)] : [], [rule, canDuplicateRuleWithActions, userHasPermissions, doesBaseVersionExist, startTransaction, closePopover, showBulkDuplicateExceptionsConfirmation, executeBulkAction, navigateToApp, bulkExport, downloadExportedRules, showManualRuleRunConfirmation, telemetry, scheduleRuleRun, openCustomizationsRevertFlyout, confirmDeletion, onRuleDeletedCallback]);
  const button = (0, _react.useMemo)(() => /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    position: "top",
    content: i18n.ALL_ACTIONS,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 261,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(MyEuiButtonIcon, {
    iconType: "boxesHorizontal",
    "aria-label": i18n.ALL_ACTIONS,
    isDisabled: !userHasPermissions,
    "data-test-subj": "rules-details-popover-button-icon",
    onClick: togglePopover,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 262,
      columnNumber: 9
    }
  })), [togglePopover, userHasPermissions]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    anchorPosition: "leftCenter",
    button: button,
    closePopover: closePopover,
    id: "ruleActionsOverflow",
    isOpen: isPopoverOpen,
    "data-test-subj": "rules-details-popover",
    ownFocus: true,
    panelPaddingSize: "none",
    repositionOnScroll: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 276,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuPanel, {
    "data-test-subj": "rules-details-menu-panel",
    items: actions,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 287,
      columnNumber: 9
    }
  })));
};
const RuleActionsOverflow = exports.RuleActionsOverflow = /*#__PURE__*/_react.default.memo(RuleActionsOverflowComponent);
RuleActionsOverflow.displayName = 'RuleActionsOverflow';