"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getSourceEventTimeRangeColumns = exports.getMessageColumn = exports.getExecutionLogMetricsColumns = exports.expanderColumn = exports.EXECUTION_LOG_COLUMNS = void 0;
var _react = _interopRequireDefault(require("react"));
var _react2 = require("@emotion/react");
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _empty_value = require("../../../../../common/components/empty_value");
var _formatted_date = require("../../../../../common/components/formatted_date");
var _translations = require("../../../../../common/translations");
var _rule_monitoring = require("../../../../rule_monitoring");
var _popover_tooltip = require("../../../../rule_management_ui/components/rules_table/popover_tooltip");
var _table_header_tooltip_cell = require("../../../../rule_management_ui/components/rules_table/table_header_tooltip_cell");
var _rule_duration_format = require("./rule_duration_format");
var i18n = _interopRequireWildcard(require("./translations"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763899475283842490/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/detection_engine/rule_details_ui/pages/rule_details/execution_log_table/execution_log_columns.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const expanderColumn = ({
  toggleRowExpanded,
  isRowExpanded
}) => {
  return {
    align: _eui.RIGHT_ALIGNMENT,
    width: '40px',
    isExpander: true,
    name: /*#__PURE__*/_react.default.createElement(_eui.EuiScreenReaderOnly, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 55,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement("span", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 56,
        columnNumber: 9
      }
    }, i18n.EXPAND_ROW)),
    render: item => item.security_status === 'succeeded' ? null : /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
      onClick: () => toggleRowExpanded(item),
      "aria-label": isRowExpanded(item) ? i18n.COLLAPSE : i18n.EXPAND,
      iconType: isRowExpanded(item) ? 'arrowUp' : 'arrowDown',
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 61,
        columnNumber: 9
      }
    })
  };
};
exports.expanderColumn = expanderColumn;
const EXECUTION_LOG_COLUMNS = exports.EXECUTION_LOG_COLUMNS = [{
  name: /*#__PURE__*/_react.default.createElement(_table_header_tooltip_cell.TableHeaderTooltipCell, {
    title: i18n.COLUMN_STATUS,
    tooltipContent: i18n.COLUMN_STATUS_TOOLTIP,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 73,
      columnNumber: 7
    }
  }),
  field: 'security_status',
  render: value => /*#__PURE__*/_react.default.createElement(_rule_monitoring.ExecutionStatusIndicator, {
    status: value,
    showTooltip: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 80,
      columnNumber: 7
    }
  }),
  sortable: false,
  truncateText: false,
  width: '10%'
}, {
  name: i18n.COLUMN_TYPE,
  field: 'type',
  sortable: false,
  width: '10%',
  render: (value, record) => {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 93,
        columnNumber: 9
      }
    }, record.backfill ? _translations.RULE_EXECUTION_TYPE_BACKFILL : _translations.RULE_EXECUTION_TYPE_STANDARD);
  }
}, {
  field: 'timestamp',
  name: /*#__PURE__*/_react.default.createElement(_table_header_tooltip_cell.TableHeaderTooltipCell, {
    title: i18n.COLUMN_TIMESTAMP,
    tooltipContent: i18n.COLUMN_TIMESTAMP_TOOLTIP,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 102,
      columnNumber: 7
    }
  }),
  render: value => /*#__PURE__*/_react.default.createElement(_formatted_date.FormattedDate, {
    value: value,
    fieldName: "timestamp",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 107,
      columnNumber: 32
    }
  }),
  sortable: true,
  truncateText: false,
  width: '15%'
}, {
  field: 'duration_ms',
  name: /*#__PURE__*/_react.default.createElement(_table_header_tooltip_cell.TableHeaderTooltipCell, {
    title: i18n.COLUMN_DURATION,
    tooltipContent: i18n.COLUMN_DURATION_TOOLTIP,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 115,
      columnNumber: 7
    }
  }),
  render: value => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, value ? /*#__PURE__*/_react.default.createElement(_rule_duration_format.RuleDurationFormat, {
    duration: value,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 121,
      columnNumber: 18
    }
  }) : (0, _empty_value.getEmptyValue)()),
  sortable: true,
  truncateText: false,
  width: '10%'
}];
const getMessageColumn = width => ({
  field: 'security_message',
  name: /*#__PURE__*/_react.default.createElement(_table_header_tooltip_cell.TableHeaderTooltipCell, {
    title: i18n.COLUMN_MESSAGE,
    tooltipContent: i18n.COLUMN_MESSAGE_TOOLTIP,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 132,
      columnNumber: 5
    }
  }),
  render: (value, record) => {
    if (record.security_status === 'succeeded') {
      return value;
    }
    return /*#__PURE__*/_react.default.createElement("div", {
      css: (0, _react2.css)`
          display: -webkit-box;
          -webkit-line-clamp: 3;
          -webkit-box-orient: vertical;
          overflow: hidden;
        `,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 143,
        columnNumber: 7
      }
    }, value);
  },
  sortable: false,
  width
});
exports.getMessageColumn = getMessageColumn;
const getSourceEventTimeRangeColumns = () => [{
  name: /*#__PURE__*/_react.default.createElement(_table_header_tooltip_cell.TableHeaderTooltipCell, {
    title: i18n.COLUMN_SOURCE_EVENT_TIME_RANGE,
    tooltipContent: i18n.COLUMN_SOURCE_EVENT_TIME_RANGE_TOOLTIP,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 162,
      columnNumber: 7
    }
  }),
  field: 'backfill',
  render: backfill => {
    return backfill ? /*#__PURE__*/_react.default.createElement("div", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 170,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement("div", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 171,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_formatted_date.FormattedDate, {
      value: backfill.from,
      fieldName: "backfill.from",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 172,
        columnNumber: 13
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      textAlign: "center",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 174,
        columnNumber: 11
      }
    }, '-'), /*#__PURE__*/_react.default.createElement("div", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 175,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_formatted_date.FormattedDate, {
      value: backfill.to,
      fieldName: "backfill.to",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 176,
        columnNumber: 13
      }
    }))) : (0, _empty_value.getEmptyValue)();
  },
  width: '20%'
}];
exports.getSourceEventTimeRangeColumns = getSourceEventTimeRangeColumns;
const getExecutionLogMetricsColumns = docLinks => [{
  field: 'gap_duration_s',
  name: /*#__PURE__*/_react.default.createElement(_table_header_tooltip_cell.TableHeaderTooltipCell, {
    title: i18n.COLUMN_GAP_DURATION,
    customTooltip: /*#__PURE__*/_react.default.createElement("div", {
      css: {
        maxWidth: '20px'
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 196,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_popover_tooltip.PopoverTooltip, {
      columnName: i18n.COLUMN_GAP_DURATION,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 197,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: 's',
      css: {
        width: 350
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 198,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement("p", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 199,
        columnNumber: 17
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      defaultMessage: "Duration of gap in Rule execution (hh:mm:ss:SSS). Adjust Rule look-back or {seeDocs} for mitigating gaps.",
      id: "xpack.securitySolution.detectionEngine.ruleDetails.ruleExecutionLog.gapDurationColumnTooltip",
      values: {
        seeDocs: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
          href: `${docLinks.links.siem.troubleshootGaps}`,
          target: "_blank",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 205,
            columnNumber: 25
          }
        }, i18n.COLUMN_GAP_TOOLTIP_SEE_DOCUMENTATION)
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 200,
        columnNumber: 19
      }
    }))))),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 193,
      columnNumber: 7
    }
  }),
  render: value => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, value ? /*#__PURE__*/_react.default.createElement(_rule_duration_format.RuleDurationFormat, {
    duration: value,
    isSeconds: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 219,
      columnNumber: 18
    }
  }) : (0, _empty_value.getEmptyValue)()),
  sortable: true,
  truncateText: false,
  width: '10%'
}, {
  field: 'indexing_duration_ms',
  name: /*#__PURE__*/_react.default.createElement(_table_header_tooltip_cell.TableHeaderTooltipCell, {
    title: i18n.COLUMN_INDEX_DURATION,
    tooltipContent: i18n.COLUMN_INDEX_DURATION_TOOLTIP,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 228,
      columnNumber: 7
    }
  }),
  render: value => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, value ? /*#__PURE__*/_react.default.createElement(_rule_duration_format.RuleDurationFormat, {
    duration: value,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 234,
      columnNumber: 18
    }
  }) : (0, _empty_value.getEmptyValue)()),
  sortable: true,
  truncateText: false,
  width: '10%'
}, {
  field: 'search_duration_ms',
  name: /*#__PURE__*/_react.default.createElement(_table_header_tooltip_cell.TableHeaderTooltipCell, {
    title: i18n.COLUMN_SEARCH_DURATION,
    tooltipContent: i18n.COLUMN_SEARCH_DURATION_TOOLTIP,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 243,
      columnNumber: 7
    }
  }),
  render: value => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, value ? /*#__PURE__*/_react.default.createElement(_rule_duration_format.RuleDurationFormat, {
    duration: value,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 249,
      columnNumber: 18
    }
  }) : (0, _empty_value.getEmptyValue)()),
  sortable: true,
  truncateText: false,
  width: '10%'
}, {
  field: 'schedule_delay_ms',
  name: /*#__PURE__*/_react.default.createElement(_table_header_tooltip_cell.TableHeaderTooltipCell, {
    title: i18n.COLUMN_SCHEDULING_DELAY,
    tooltipContent: i18n.COLUMN_SCHEDULING_DELAY_TOOLTIP,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 258,
      columnNumber: 7
    }
  }),
  render: value => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, value ? /*#__PURE__*/_react.default.createElement(_rule_duration_format.RuleDurationFormat, {
    duration: value,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 264,
      columnNumber: 18
    }
  }) : (0, _empty_value.getEmptyValue)()),
  sortable: true,
  truncateText: false,
  width: '10%'
}];
exports.getExecutionLogMetricsColumns = getExecutionLogMetricsColumns;