"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.schema = void 0;
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _utils = require("../../../../../common/detection_engine/utils");
var _helpers = require("../../../../../common/machine_learning/helpers");
var _shared_imports = require("../../../../shared_imports");
var _types = require("../../../common/types");
var _data_view_id_validator_factory = require("../../validators/data_view_id_validator_factory");
var _index_pattern_validator_factory = require("../../validators/index_pattern_validator_factory");
var _alert_suppression_fields_validator_factory = require("../../validators/alert_suppression_fields_validator_factory");
var _alert_suppression_edit = require("../../../rule_creation/components/alert_suppression_edit");
var alertSuppressionEditI81n = _interopRequireWildcard(require("../../../rule_creation/components/alert_suppression_edit/components/translations"));
var _translations2 = require("./translations");
var _query_required_validator_factory = require("../../validators/query_required_validator_factory");
var _kuery_validator_factory = require("../../validators/kuery_validator_factory");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763899475283842490/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/detection_engine/rule_creation_ui/components/step_define_rule/schema.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const schema = exports.schema = {
  index: {
    defaultValue: [],
    fieldsToValidateOnChange: ['index', 'queryBar'],
    type: _shared_imports.FIELD_TYPES.COMBO_BOX,
    label: _i18n.i18n.translate('xpack.securitySolution.detectionEngine.createRule.stepAboutRule.fiedIndexPatternsLabel', {
      defaultMessage: 'Index patterns'
    }),
    helpText: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "xs",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 45,
        columnNumber: 15
      }
    }, _translations2.INDEX_HELPER_TEXT),
    validations: [{
      validator: (...args) => {
        const [{
          formData
        }] = args;
        if ((0, _helpers.isMlRule)(formData.ruleType) || (0, _utils.isEsqlRule)(formData.ruleType) || formData.dataSourceType !== _types.DataSourceType.IndexPatterns) {
          return;
        }
        return (0, _index_pattern_validator_factory.indexPatternValidatorFactory)()(...args);
      }
    }]
  },
  dataViewId: {
    label: _i18n.i18n.translate('xpack.securitySolution.detectionEngine.createRule.stepAboutRule.dataViewSelector', {
      defaultMessage: 'Data view'
    }),
    fieldsToValidateOnChange: ['dataViewId'],
    validations: [{
      validator: (...args) => {
        const [{
          formData
        }] = args;
        if ((0, _helpers.isMlRule)(formData.ruleType) || formData.dataSourceType !== _types.DataSourceType.DataView) {
          return;
        }
        return (0, _data_view_id_validator_factory.dataViewIdValidatorFactory)()(...args);
      }
    }]
  },
  dataViewTitle: {
    label: _i18n.i18n.translate('xpack.securitySolution.detectionEngine.createRule.stepAboutRule.dataViewTitleSelector', {
      defaultMessage: 'Data view index pattern'
    }),
    validations: []
  },
  eqlOptions: {
    fieldsToValidateOnChange: ['eqlOptions', 'queryBar']
  },
  queryBar: {
    fieldsToValidateOnChange: ['queryBar', _alert_suppression_edit.ALERT_SUPPRESSION_FIELDS_FIELD_NAME],
    validations: [{
      validator: (...args) => {
        const [{
          value,
          formData
        }] = args;
        if ((0, _helpers.isMlRule)(formData.ruleType) || value.saved_id) {
          // Ignore field validation error in this case.
          // Instead, we show the error toast when saved query object does not exist.
          // https://github.com/elastic/kibana/issues/159060
          return;
        }
        return (0, _query_required_validator_factory.queryRequiredValidatorFactory)(formData.ruleType)(...args);
      }
    }, {
      validator: (0, _kuery_validator_factory.kueryValidatorFactory)()
    }]
  },
  ruleType: {
    label: _i18n.i18n.translate('xpack.securitySolution.detectionEngine.createRule.stepDefineRule.fieldRuleTypeLabel', {
      defaultMessage: 'Rule type'
    }),
    validations: []
  },
  anomalyThreshold: {},
  machineLearningJobId: {},
  relatedIntegrations: {
    type: _shared_imports.FIELD_TYPES.JSON,
    label: _i18n.i18n.translate('xpack.securitySolution.detectionEngine.createRule.stepAboutRule.fieldRelatedIntegrationsLabel', {
      defaultMessage: 'Related integrations'
    })
  },
  requiredFields: {
    label: _i18n.i18n.translate('xpack.securitySolution.detectionEngine.createRule.stepAboutRule.fieldRequiredFieldsLabel', {
      defaultMessage: 'Required fields'
    }),
    helpText: _i18n.i18n.translate('xpack.securitySolution.detectionEngine.createRule.stepAboutRule.fieldRequiredFieldsHelpText', {
      defaultMessage: 'Fields required for this Rule to function.'
    })
  },
  timeline: {
    label: _i18n.i18n.translate('xpack.securitySolution.detectionEngine.createRule.stepAboutRule.fieldTimelineTemplateLabel', {
      defaultMessage: 'Timeline template'
    }),
    helpText: _i18n.i18n.translate('xpack.securitySolution.detectionEngine.createRule.stepAboutRule.fieldTimelineTemplateHelpText', {
      defaultMessage: 'Select which timeline to use when investigating generated alerts.'
    })
  },
  threshold: {},
  threatIndex: {},
  threatMapping: {},
  threatQueryBar: {},
  newTermsFields: {},
  historyWindowSize: {},
  [_alert_suppression_edit.ALERT_SUPPRESSION_FIELDS_FIELD_NAME]: {
    validations: [{
      validator: (...args) => {
        const [{
          formData
        }] = args;
        const needsValidation = (0, _utils.isSuppressionRuleConfiguredWithGroupBy)(formData.ruleType);
        if (!needsValidation) {
          return;
        }
        return (0, _alert_suppression_fields_validator_factory.alertSuppressionFieldsValidatorFactory)()(...args);
      }
    }]
  },
  [_alert_suppression_edit.ALERT_SUPPRESSION_DURATION_FIELD_NAME]: {
    label: _i18n.i18n.translate('xpack.securitySolution.detectionEngine.createRule.stepDefineRule.groupByDurationValueLabel', {
      defaultMessage: 'Suppress alerts for'
    })
  },
  [_alert_suppression_edit.ALERT_SUPPRESSION_MISSING_FIELDS_FIELD_NAME]: {
    label: alertSuppressionEditI81n.ALERT_SUPPRESSION_MISSING_FIELDS_LABEL
  },
  shouldLoadQueryDynamically: {
    type: _shared_imports.FIELD_TYPES.CHECKBOX,
    defaultValue: false
  }
};