"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EsqlAutocomplete = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _use_esql_fields_options = require("./use_esql_fields_options");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763899475283842490/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/detection_engine/rule_creation_ui/components/esql_autocomplete/esql_autocomplete.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const AS_PLAIN_TEXT = {
  asPlainText: true
};
const COMPONENT_WIDTH = 500;
/**
 * autocomplete form component that works with ES|QL query
 * it receives query as one of the parameters, fetches available fields and convert them to
 * options, that populate autocomplete component
 */
const EsqlAutocomplete = ({
  dataTestSubj,
  field,
  idAria,
  isDisabled,
  fieldType,
  placeholder,
  esqlQuery
}) => {
  const handleValuesChange = (0, _react.useCallback)(([newOption]) => {
    var _newOption$label;
    field.setValue((_newOption$label = newOption === null || newOption === void 0 ? void 0 : newOption.label) !== null && _newOption$label !== void 0 ? _newOption$label : '');
  }, [field]);
  const {
    options,
    isLoading
  } = (0, _use_esql_fields_options.useEsqlFieldOptions)(esqlQuery, fieldType);
  const value = field === null || field === void 0 ? void 0 : field.value;
  const selectedOptions = typeof value === 'string' && value ? [{
    label: value
  }] : [];
  const isInvalid = typeof value === 'string' && value ? !options.some(option => option.label === value) : false;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    "data-test-subj": dataTestSubj,
    describedByIds: idAria ? [idAria] : undefined,
    fullWidth: true,
    helpText: field.helpText,
    label: field.label,
    labelAppend: field.labelAppend,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 57,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
    placeholder: placeholder !== null && placeholder !== void 0 ? placeholder : '',
    options: options,
    selectedOptions: selectedOptions,
    onChange: handleValuesChange,
    isLoading: isLoading,
    isDisabled: isDisabled || isLoading,
    isClearable: false,
    singleSelection: AS_PLAIN_TEXT,
    "data-test-subj": "esqlAutocompleteComboBox",
    css: {
      width: `${COMPONENT_WIDTH}px`
    },
    fullWidth: true,
    isInvalid: isInvalid,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 65,
      columnNumber: 7
    }
  }));
};
exports.EsqlAutocomplete = EsqlAutocomplete;
EsqlAutocomplete.displayName = 'EsqlAutocomplete';