"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TypeComboBox = TypeComboBox;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var i18n = _interopRequireWildcard(require("./translations"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763899475283842490/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/detection_engine/rule_creation/components/required_fields/type_combobox.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function TypeComboBox({
  field,
  itemId,
  typesByFieldName,
  typeWarning,
  typeError
}) {
  const {
    value,
    setValue
  } = field;
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const selectableTypeOptions = (0, _react.useMemo)(() => {
    const typesAvailableForSelectedName = typesByFieldName[value.name];
    const isSelectedTypeAvailable = (typesAvailableForSelectedName || []).includes(value.type);
    if (typesAvailableForSelectedName && isSelectedTypeAvailable) {
      /*
        Case: name is available, type is not available
        Selected field name is present in index patterns, so it has one or more types available for it.
        Allowing the user to select from them.
      */

      return typesAvailableForSelectedName.map(type => ({
        label: type,
        value: type
      }));
    } else if (typesAvailableForSelectedName) {
      /*
        Case: name is available, type is not available
        Selected field name is present in index patterns, but the selected type doesn't exist for it.
        Adding the selected type to the list of selectable options since it was selected before.
      */
      return typesAvailableForSelectedName.map(type => ({
        label: type,
        value: type
      })).concat({
        label: value.type,
        value: value.type
      });
    } else if (value.name) {
      /*
        Case: name is not available (so the type is also not available)
        Field name is set (not an empty string), but it's not present in index patterns.
        In such case the only selectable type option is the currenty selected type.
      */
      return [{
        label: value.type,
        value: value.type
      }];
    }
    return [];
  }, [value.name, value.type, typesByFieldName]);

  /*
    Using a state for `selectedTypeOptions` instead of using the field value directly
    to fix the issue where pressing the backspace key in combobox input would clear the field value
    and trigger a validation error. By using a separate state, we can clear the selected option
    without clearing the field value.
  */
  const [selectedTypeOption, setSelectedTypeOption] = (0, _react.useState)(selectableTypeOptions.find(option => option.value === value.type));
  (0, _react.useEffect)(() => {
    /* Re-computing the new selected type option when the field value changes */
    setSelectedTypeOption(selectableTypeOptions.find(option => option.value === value.type));
  }, [value.type, selectableTypeOptions]);
  const handleTypeChange = (0, _react.useCallback)(selectedOptions => {
    const newlySelectedOption = selectedOptions[0];
    if (!newlySelectedOption) {
      /* This occurs when the user hits backspace in combobox */
      setSelectedTypeOption(undefined);
      return;
    }
    const updatedType = (newlySelectedOption === null || newlySelectedOption === void 0 ? void 0 : newlySelectedOption.value) || '';
    const updatedFieldValue = {
      name: value.name,
      type: updatedType
    };
    setValue(updatedFieldValue);
  }, [value.name, setValue]);
  const handleAddCustomType = (0, _react.useCallback)(newType => {
    const updatedFieldValue = {
      name: value.name,
      type: newType
    };
    setValue(updatedFieldValue);
  }, [value.name, setValue]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
    "data-test-subj": `requiredFieldTypeSelect-${value.type || 'empty'}`,
    "aria-label": i18n.FIELD_TYPE,
    placeholder: i18n.FIELD_TYPE,
    singleSelection: {
      asPlainText: true
    },
    options: selectableTypeOptions,
    selectedOptions: selectedTypeOption ? [selectedTypeOption] : [],
    onChange: handleTypeChange,
    isClearable: false,
    onCreateOption: handleAddCustomType,
    isInvalid: Boolean(typeError),
    prepend: typeWarning ? /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      size: "s",
      type: "warning",
      color: euiTheme.colors.textWarning,
      "data-test-subj": "warningIcon",
      "aria-labelledby": `warningText-${itemId}`,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 140,
        columnNumber: 11
      }
    }) : undefined,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 127,
      columnNumber: 5
    }
  });
}