"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.HelpText = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _css = require("@emotion/css");
var _i18nReact = require("@kbn/i18n-react");
var _helpers = require("../../../../../common/machine_learning/helpers");
var _kibana = require("../../../../common/lib/kibana");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763899475283842490/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/detection_engine/rule_creation/components/ml_job_select/help_text.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const HelpText = exports.HelpText = /*#__PURE__*/(0, _react.memo)(function HelpText({
  jobs,
  selectedJobIds
}) {
  const {
    getUrlForApp
  } = (0, _kibana.useKibana)().services.application;
  const mlUrl = getUrlForApp('ml');
  const notRunningJobIds = (0, _react.useMemo)(() => {
    const selectedJobs = jobs.filter(({
      id
    }) => selectedJobIds.includes(id));
    return selectedJobs.reduce((acc, job) => {
      if (!(0, _helpers.isJobStarted)(job.jobState, job.datafeedState)) {
        acc.push(job.id);
      }
      return acc;
    }, []);
  }, [jobs, selectedJobIds]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.detectionEngine.createRule.stepDefineRule.machineLearningJobIdHelpText",
    defaultMessage: "We've provided a few common jobs to get you started. To add your own custom jobs, assign a group of 'security' to those jobs in the {machineLearning} application to make them appear here.",
    values: {
      machineLearning: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        href: mlUrl,
        target: "_blank",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 45,
          columnNumber: 13
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.securitySolution.components.mlJobSelect.machineLearningLink",
        defaultMessage: "Machine Learning",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 46,
          columnNumber: 15
        }
      }))
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 40,
      columnNumber: 7
    }
  }), notRunningJobIds.length > 0 && /*#__PURE__*/_react.default.createElement("div", {
    className: warningContainerClassName,
    "data-test-subj": "ml-warning-not-running-jobs",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 55,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 56,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement("span", {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 57,
      columnNumber: 13
    }
  }, notRunningJobIds.length === 1 ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.detectionEngine.createRule.stepDefineRule.mlEnableJobSingle",
    defaultMessage: "The selected ML job, {jobName}, is not currently running. We will start {jobName} when you enable this rule.",
    values: {
      jobName: notRunningJobIds[0]
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 59,
      columnNumber: 17
    }
  }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.detectionEngine.createRule.stepDefineRule.mlEnableJobMulti",
    defaultMessage: "The selected ML jobs, {jobNames}, are not currently running. We will start all of these jobs when you enable this rule.",
    values: {
      jobNames: notRunningJobIds.reduce((acc, value, i, array) => acc + (i < array.length - 1 ? ', ' : ', and ') + value)
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 67,
      columnNumber: 17
    }
  })))));
});
const warningContainerClassName = (0, _css.css)`
  margin-top: 10px;
`;