"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DashboardRenderer = void 0;
var _react = _interopRequireWildcard(require("react"));
var _public = require("@kbn/dashboard-plugin/public");
var _reactRedux = require("react-redux");
var _rxjs = require("rxjs");
var _common = require("../../../common");
var _constants = require("../../../common/constants");
var _link_to = require("../../common/components/link_to");
var _kibana = require("../../common/lib/kibana");
var _inputs = require("../../common/store/inputs");
var _constants2 = require("../../common/store/inputs/constants");
var _dashboard_context = require("../context/dashboard_context");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763899475283842490/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/dashboards/components/dashboard_renderer.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const initialInput = new _rxjs.BehaviorSubject({});
const DashboardRendererComponent = ({
  canReadDashboard,
  dashboardContainer,
  filters,
  id,
  inputId = _constants2.InputsModelId.global,
  onDashboardContainerLoaded,
  query,
  savedObjectId,
  timeRange,
  viewMode = 'view'
}) => {
  var _securityTags$;
  const {
    embeddable
  } = (0, _kibana.useKibana)().services;
  const dispatch = (0, _reactRedux.useDispatch)();
  const securityTags = (0, _dashboard_context.useSecurityTags)();
  const {
    navigateTo
  } = (0, _kibana.useNavigateTo)();
  const getSecuritySolutionUrl = (0, _link_to.useGetSecuritySolutionUrl)();
  const firstSecurityTagId = securityTags === null || securityTags === void 0 ? void 0 : (_securityTags$ = securityTags[0]) === null || _securityTags$ === void 0 ? void 0 : _securityTags$.id;
  const isCreateDashboard = !savedObjectId;
  const getSecuritySolutionDashboardUrl = (0, _react.useCallback)(({
    dashboardId
  }) => {
    return getSecuritySolutionUrl({
      deepLinkId: _constants.SecurityPageName.dashboards,
      path: dashboardId
    });
  }, [getSecuritySolutionUrl]);
  const goToDashboard = (0, _react.useCallback)(
  /**
   * Note: Due to the query bar being separate from the portable dashboard, the "Use filters and query from origin
   * dashboard" and "Use date range from origin dashboard" Link embeddable settings do not make sense in this context.
   * Regardless of these settings, navigation to a different dashboard will **always** keep the query state the same.
   * I have chosen to keep this consistent **even when** the dashboard is opened in a new tab.
   *
   * If we want portable dashboard to interact with the query bar in the same way it does in the dashboard app so these
   * settings apply, we would need to refactor this portable dashboard. We might also want to make the security app use
   * locators in that refactor, as well - not only would this clean up some tech debt, it would also make it so that
   * control selections could also be translated to filter pills on navigation.
   */
  async params => {
    navigateTo({
      url: getSecuritySolutionDashboardUrl(params)
    });
  }, [getSecuritySolutionDashboardUrl, navigateTo]);
  const locator = (0, _react.useMemo)(() => {
    return {
      navigate: goToDashboard,
      getRedirectUrl: getSecuritySolutionDashboardUrl
    };
  }, [goToDashboard, getSecuritySolutionDashboardUrl]);
  const getCreationOptions = (0, _react.useCallback)(() => {
    return Promise.resolve({
      useSessionStorageIntegration: true,
      getInitialInput: () => {
        return initialInput.value;
      },
      getIncomingEmbeddable: () => embeddable.getStateTransfer().getIncomingEmbeddablePackage(_common.APP_UI_ID, true),
      getEmbeddableAppContext: dashboardId => ({
        getCurrentPath: () => dashboardId ? `${_constants.DASHBOARDS_PATH}/${dashboardId}/edit` : `${_constants.DASHBOARDS_PATH}/create`,
        currentAppId: _common.APP_UI_ID
      })
    });
  }, [embeddable]);
  const refetchByForceRefresh = (0, _react.useCallback)(() => {
    dashboardContainer === null || dashboardContainer === void 0 ? void 0 : dashboardContainer.forceRefresh();
  }, [dashboardContainer]);
  (0, _react.useEffect)(() => {
    dispatch(_inputs.inputsActions.setQuery({
      inputId,
      id,
      refetch: refetchByForceRefresh,
      loading: false,
      inspect: null
    }));
    return () => {
      dispatch(_inputs.inputsActions.deleteOneQuery({
        inputId,
        id
      }));
    };
  }, [dispatch, id, inputId, refetchByForceRefresh]);
  (0, _react.useEffect)(() => {
    dashboardContainer === null || dashboardContainer === void 0 ? void 0 : dashboardContainer.setFilters(filters);
  }, [dashboardContainer, filters]);
  (0, _react.useEffect)(() => {
    dashboardContainer === null || dashboardContainer === void 0 ? void 0 : dashboardContainer.setQuery(query);
  }, [dashboardContainer, query]);
  (0, _react.useEffect)(() => {
    const {
      from,
      to
    } = timeRange;
    dashboardContainer === null || dashboardContainer === void 0 ? void 0 : dashboardContainer.setTimeRange({
      from,
      to
    });
  }, [dashboardContainer, timeRange]);
  (0, _react.useEffect)(() => {
    if (isCreateDashboard && firstSecurityTagId) dashboardContainer === null || dashboardContainer === void 0 ? void 0 : dashboardContainer.setTags([firstSecurityTagId]);
  }, [dashboardContainer, firstSecurityTagId, isCreateDashboard]);
  (0, _react.useEffect)(() => {
    /** We need to update the initial input on navigation so that changes to filter pills, queries, etc. get applied */
    initialInput.next({
      timeRange,
      viewMode,
      query,
      filters
    });
  }, [timeRange, viewMode, query, filters]);

  /** Dashboard renderer is stored in the state as it's a temporary solution for
   *  https://github.com/elastic/kibana/issues/167751
   **/
  const [dashboardContainerRenderer, setDashboardContainerRenderer] = (0, _react.useState)(undefined);
  (0, _react.useEffect)(() => {
    setDashboardContainerRenderer(/*#__PURE__*/_react.default.createElement(_public.DashboardRenderer, {
      locator: locator,
      onApiAvailable: onDashboardContainerLoaded,
      savedObjectId: savedObjectId,
      getCreationOptions: getCreationOptions,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 175,
        columnNumber: 7
      }
    }));
    return () => {
      setDashboardContainerRenderer(undefined);
    };
  }, [getCreationOptions, onDashboardContainerLoaded, refetchByForceRefresh, savedObjectId, locator]);
  return canReadDashboard ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, dashboardContainerRenderer) : null;
};
DashboardRendererComponent.displayName = 'DashboardRendererComponent';
const DashboardRenderer = exports.DashboardRenderer = /*#__PURE__*/_react.default.memo(DashboardRendererComponent);