"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ConfigurationsTabs = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _reactRouterDom = require("react-router-dom");
var _securitySolutionNavigation = require("@kbn/security-solution-navigation");
var _kibana = require("../../common/lib/kibana");
var _constants = require("../constants");
var i18n = _interopRequireWildcard(require("../translations"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763899475283842490/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/configurations/page/configuration_tabs.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const CONFIGURATION_TABS = [{
  tabId: _constants.ConfigurationTabs.integrations,
  deepLinkId: _securitySolutionNavigation.SecurityPageName.configurationsIntegrations,
  name: i18n.INTEGRATIONS
}, {
  tabId: _constants.ConfigurationTabs.basicRules,
  deepLinkId: _securitySolutionNavigation.SecurityPageName.configurationsBasicRules,
  name: i18n.BASIC_RULES
}, {
  tabId: _constants.ConfigurationTabs.aiSettings,
  deepLinkId: _securitySolutionNavigation.SecurityPageName.configurationsAiSettings,
  name: i18n.AI_SETTINGS
}];
const ConfigurationsTabs = exports.ConfigurationsTabs = /*#__PURE__*/_react.default.memo(() => {
  const {
    navigateTo
  } = (0, _kibana.useNavigation)();
  const params = (0, _reactRouterDom.useParams)();
  const onSelectedTabChanged = (0, _react.useCallback)(deepLinkId => {
    navigateTo({
      deepLinkId
    });
  }, [navigateTo]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiTabs, {
    size: "m",
    bottomBorder: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 45,
      columnNumber: 5
    }
  }, CONFIGURATION_TABS.map(tab => /*#__PURE__*/_react.default.createElement(_eui.EuiTab, {
    key: tab.deepLinkId,
    onClick: () => onSelectedTabChanged(tab.deepLinkId),
    isSelected: tab.tabId === params.tab,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 47,
      columnNumber: 9
    }
  }, tab.name)));
});
ConfigurationsTabs.displayName = 'RulesTableToolbar';