"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MockAssistantProviderComponent = exports.MockAssistantProvider = void 0;
var _coreHttpBrowserMocks = require("@kbn/core-http-browser-mocks");
var _action_type_registry = require("@kbn/triggers-actions-ui-plugin/public/application/action_type_registry.mock");
var _react = _interopRequireDefault(require("react"));
var _elasticAssistant = require("@kbn/elastic-assistant");
var _coreChromeBrowserMocks = require("@kbn/core-chrome-browser-mocks");
var _rxjs = require("rxjs");
var _assistant_context = require("@kbn/elastic-assistant/impl/assistant_context");
var _mocks = require("@kbn/core/public/mocks");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763899475283842490/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/common/mock/mock_assistant_provider.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
window.scrollTo = jest.fn();
window.HTMLElement.prototype.scrollIntoView = jest.fn();

/** A utility for wrapping children in the providers required to run tests */
const MockAssistantProviderComponent = ({
  assistantAvailability,
  children
}) => {
  const actionTypeRegistry = _action_type_registry.actionTypeRegistryMock.create();
  const mockHttp = _coreHttpBrowserMocks.httpServiceMock.createStartContract({
    basePath: '/test'
  });
  const mockNavigateToApp = jest.fn();
  const defaultAssistantAvailability = {
    hasSearchAILakeConfigurations: false,
    hasAssistantPrivilege: false,
    hasConnectorsAllPrivilege: true,
    hasConnectorsReadPrivilege: true,
    hasUpdateAIAssistantAnonymization: true,
    hasManageGlobalKnowledgeBase: true,
    isAssistantEnabled: true,
    isAssistantVisible: true,
    isAssistantManagementEnabled: true
  };
  const chrome = _coreChromeBrowserMocks.chromeServiceMock.createStartContract();
  chrome.getChromeStyle$.mockReturnValue((0, _rxjs.of)('classic'));
  const docLinks = _mocks.docLinksServiceMock.createStartContract();
  const mockUserProfileService = {
    getCurrent: jest.fn(() => Promise.resolve({
      avatar: 'avatar'
    }))
  };
  const assistantContextValue = (0, _assistant_context.useAssistantContextValue)({
    actionTypeRegistry,
    assistantAvailability: assistantAvailability !== null && assistantAvailability !== void 0 ? assistantAvailability : defaultAssistantAvailability,
    augmentMessageCodeBlocks: {
      mount: jest.fn().mockReturnValue(() => {})
    },
    basePath: 'https://localhost:5601/kbn',
    docLinks,
    getComments: jest.fn(() => []),
    http: mockHttp,
    navigateToApp: mockNavigateToApp,
    currentAppId: 'test',
    productDocBase: {
      installation: {
        getStatus: jest.fn(),
        install: jest.fn(),
        uninstall: jest.fn()
      }
    },
    userProfileService: mockUserProfileService,
    chrome,
    getUrlForApp: jest.fn(),
    settings: {
      client: {
        get: jest.fn()
      }
    }
  });
  return /*#__PURE__*/_react.default.createElement(_elasticAssistant.AssistantProvider, {
    value: assistantContextValue,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 80,
      columnNumber: 10
    }
  }, children);
};
exports.MockAssistantProviderComponent = MockAssistantProviderComponent;
MockAssistantProviderComponent.displayName = 'MockAssistantProviderComponent';
const MockAssistantProvider = exports.MockAssistantProvider = /*#__PURE__*/_react.default.memo(MockAssistantProviderComponent);