"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.StatefulAlertBulkActions = exports.AlertBulkActionsComponent = void 0;
var _numeral = _interopRequireDefault(require("@elastic/numeral"));
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _public = require("@kbn/kibana-react-plugin/public");
var _securitysolutionDataTable = require("@kbn/securitysolution-data-table");
var _constants = require("../../../../../common/constants");
var _ = require(".");
var _use_bulk_action_items = require("./use_bulk_action_items");
var _store = require("../../../store");
var _use_selector = require("../../../hooks/use_selector");
var i18n = _interopRequireWildcard(require("./translations"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763899475283842490/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/common/components/toolbar/bulk_actions/alert_bulk_actions.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/**
 * Component to render status bulk actions
 */
const AlertBulkActionsComponent = exports.AlertBulkActionsComponent = /*#__PURE__*/_react.default.memo(({
  id,
  totalItems,
  filterStatus,
  query,
  selectedEventIds,
  isSelectAllChecked,
  clearSelected,
  showAlertStatusActions,
  onActionSuccess,
  onActionFailure,
  customBulkActions,
  customRefetch
}) => {
  const dispatch = (0, _reactRedux.useDispatch)();
  const [showClearSelection, setShowClearSelection] = (0, _react.useState)(false);
  const getGlobalQuerySelector = (0, _react.useMemo)(() => _store.inputsSelectors.globalQuery(), []);
  const globalQueries = (0, _use_selector.useDeepEqualSelector)(getGlobalQuerySelector);
  const refetchQuery = (0, _react.useCallback)(() => {
    globalQueries.forEach(q => q.refetch && q.refetch());
  }, [globalQueries]);
  const [defaultNumberFormat] = (0, _public.useUiSetting$)(_constants.DEFAULT_NUMBER_FORMAT);
  const selectedCount = (0, _react.useMemo)(() => Object.keys(selectedEventIds).length, [selectedEventIds]);
  const formattedTotalCount = (0, _react.useMemo)(() => (0, _numeral.default)(totalItems).format(defaultNumberFormat), [defaultNumberFormat, totalItems]);
  const formattedSelectedCount = (0, _react.useMemo)(() => (0, _numeral.default)(selectedCount).format(defaultNumberFormat), [defaultNumberFormat, selectedCount]);
  const selectText = (0, _react.useMemo)(() => showClearSelection ? i18n.SELECTED_ENTITIES(_securitysolutionDataTable.tableEntity[id], formattedTotalCount, totalItems) : i18n.SELECTED_ENTITIES(_securitysolutionDataTable.tableEntity[id], formattedSelectedCount, selectedCount), [id, showClearSelection, formattedTotalCount, formattedSelectedCount, totalItems, selectedCount]);
  const selectClearAllText = (0, _react.useMemo)(() => showClearSelection ? i18n.CLEAR_SELECTION : i18n.SELECT_ALL_ENTITIES(_securitysolutionDataTable.tableEntity[id], formattedTotalCount, totalItems), [id, showClearSelection, formattedTotalCount, totalItems]);

  // Catches state change isSelectAllChecked->false (page checkbox) upon user selection change to reset toolbar select all
  (0, _react.useEffect)(() => {
    if (isSelectAllChecked) {
      dispatch(_securitysolutionDataTable.dataTableActions.setDataTableSelectAll({
        id,
        selectAll: false
      }));
    } else {
      setShowClearSelection(false);
    }
  }, [dispatch, isSelectAllChecked, id]);

  // Callback for selecting all events on all pages from toolbar
  // Dispatches to stateful_body's selectAll via TimelineTypeContext props
  // as scope of response data required to actually set selectedEvents
  const onSelectAll = (0, _react.useCallback)(() => {
    dispatch(_securitysolutionDataTable.dataTableActions.setDataTableSelectAll({
      id,
      selectAll: true
    }));
    setShowClearSelection(true);
  }, [dispatch, id]);

  // Callback for clearing entire selection from toolbar
  const onClearSelection = (0, _react.useCallback)(() => {
    clearSelected({
      id
    });
    dispatch(_securitysolutionDataTable.dataTableActions.setDataTableSelectAll({
      id,
      selectAll: false
    }));
    setShowClearSelection(false);
  }, [clearSelected, dispatch, id]);
  const onUpdateSuccess = (0, _react.useCallback)((updated, conflicts, newStatus) => {
    if (customRefetch) {
      customRefetch();
    } else {
      refetchQuery();
    }
    if (onActionSuccess) {
      onActionSuccess(updated, conflicts, newStatus);
    }
  }, [customRefetch, onActionSuccess, refetchQuery]);
  const onUpdateFailure = (0, _react.useCallback)((newStatus, error) => {
    if (customRefetch) {
      customRefetch();
    } else {
      refetchQuery();
    }
    if (onActionFailure) {
      onActionFailure(newStatus, error);
    }
  }, [customRefetch, onActionFailure, refetchQuery]);
  const setEventsLoading = (0, _react.useCallback)(({
    eventIds,
    isLoading
  }) => {
    dispatch(_securitysolutionDataTable.dataTableActions.setEventsLoading({
      id,
      eventIds,
      isLoading
    }));
  }, [dispatch, id]);
  const setEventsDeleted = (0, _react.useCallback)(({
    eventIds,
    isDeleted
  }) => {
    dispatch(_securitysolutionDataTable.dataTableActions.setEventsDeleted({
      id,
      eventIds,
      isDeleted
    }));
  }, [dispatch, id]);
  const {
    items: bulkActionItems,
    panels: bulkActionsPanels
  } = (0, _use_bulk_action_items.useBulkActionItems)({
    eventIds: Object.keys(selectedEventIds),
    currentStatus: filterStatus,
    ...(showClearSelection ? {
      query
    } : {}),
    setEventsLoading,
    setEventsDeleted,
    showAlertStatusActions,
    onUpdateSuccess,
    onUpdateFailure,
    customBulkActions
  });
  return /*#__PURE__*/_react.default.createElement(_.BulkActions, {
    selectText: selectText,
    selectClearAllText: selectClearAllText,
    "data-test-subj": "bulk-actions",
    showClearSelection: showClearSelection,
    onSelectAll: onSelectAll,
    onClearSelection: onClearSelection,
    bulkActionItems: bulkActionItems,
    bulkActionPanels: bulkActionsPanels,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 190,
      columnNumber: 7
    }
  });
});
AlertBulkActionsComponent.displayName = 'AlertBulkActionsComponent';
const makeMapStateToProps = () => {
  const getTable = _securitysolutionDataTable.dataTableSelectors.getTableByIdSelector();
  const mapStateToProps = (state, {
    id
  }) => {
    const dataTable = getTable(state, id);
    const {
      selectedEventIds,
      isSelectAllChecked
    } = dataTable;
    return {
      isSelectAllChecked,
      selectedEventIds
    };
  };
  return mapStateToProps;
};
const mapDispatchToProps = {
  clearSelected: _securitysolutionDataTable.dataTableActions.clearSelected
};
const connector = (0, _reactRedux.connect)(makeMapStateToProps, mapDispatchToProps);
const StatefulAlertBulkActions = exports.default = exports.StatefulAlertBulkActions = connector(AlertBulkActionsComponent);

// eslint-disable-next-line import/no-default-export