"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
var _exportNames = {
  StateToasterContext: true,
  useStateToaster: true,
  ManageGlobalToaster: true,
  GlobalToaster: true
};
exports.useStateToaster = exports.StateToasterContext = exports.ManageGlobalToaster = exports.GlobalToaster = void 0;
var _eui = require("@elastic/eui");
var _fp = require("lodash/fp");
var _react = _interopRequireWildcard(require("react"));
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _modal_all_errors = require("./modal_all_errors");
var i18n = _interopRequireWildcard(require("./translations"));
var _utils = require("./utils");
Object.keys(_utils).forEach(function (key) {
  if (key === "default" || key === "__esModule") return;
  if (Object.prototype.hasOwnProperty.call(_exportNames, key)) return;
  if (key in exports && exports[key] === _utils[key]) return;
  Object.defineProperty(exports, key, {
    enumerable: true,
    get: function () {
      return _utils[key];
    }
  });
});
var _errors = require("./errors");
Object.keys(_errors).forEach(function (key) {
  if (key === "default" || key === "__esModule") return;
  if (Object.prototype.hasOwnProperty.call(_exportNames, key)) return;
  if (key in exports && exports[key] === _errors[key]) return;
  Object.defineProperty(exports, key, {
    enumerable: true,
    get: function () {
      return _errors[key];
    }
  });
});
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763899475283842490/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/common/components/toasters/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/**
 * @deprecated Use x-pack/solutions/security/plugins/security_solution/public/common/hooks/use_app_toasts.ts instead
 */

/**
 * @deprecated Use x-pack/solutions/security/plugins/security_solution/public/common/hooks/use_app_toasts.ts instead
 */

/**
 * @deprecated Use x-pack/solutions/security/plugins/security_solution/public/common/hooks/use_app_toasts.ts instead
 */
const initialToasterState = {
  toasts: []
};

/**
 * @deprecated Use x-pack/solutions/security/plugins/security_solution/public/common/hooks/use_app_toasts.ts instead
 */

/**
 * @deprecated Use x-pack/solutions/security/plugins/security_solution/public/common/hooks/use_app_toasts.ts instead
 */
const StateToasterContext = exports.StateToasterContext = /*#__PURE__*/(0, _react.createContext)([initialToasterState, () => _fp.noop]);

/**
 * @deprecated Use x-pack/solutions/security/plugins/security_solution/public/common/hooks/use_app_toasts.ts instead
 */
const useStateToaster = () => (0, _react.useContext)(StateToasterContext);

/**
 * @deprecated Use x-pack/solutions/security/plugins/security_solution/public/common/hooks/use_app_toasts.ts instead
 */
exports.useStateToaster = useStateToaster;
/**
 * @deprecated Use x-pack/solutions/security/plugins/security_solution/public/common/hooks/use_app_toasts.ts instead
 */
const ManageGlobalToaster = ({
  children
}) => {
  const reducerToaster = (state, action) => {
    switch (action.type) {
      case 'addToaster':
        return {
          ...state,
          toasts: [...state.toasts, action.toast]
        };
      case 'deleteToaster':
        return {
          ...state,
          toasts: state.toasts.filter(msg => msg.id !== action.id)
        };
      default:
        return state;
    }
  };
  return /*#__PURE__*/_react.default.createElement(StateToasterContext.Provider, {
    value: (0, _react.useReducer)(reducerToaster, initialToasterState),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 87,
      columnNumber: 5
    }
  }, children);
};

/**
 * @deprecated Use x-pack/solutions/security/plugins/security_solution/public/common/hooks/use_app_toasts.ts instead
 */
exports.ManageGlobalToaster = ManageGlobalToaster;
const GlobalToasterListContainer = _styledComponents.default.div`
  position: absolute;
  right: 0;
  bottom: 0;
`;

/**
 * @deprecated Use x-pack/solutions/security/plugins/security_solution/public/common/hooks/use_app_toasts.ts instead
 */

/**
 * @deprecated Use x-pack/solutions/security/plugins/security_solution/public/common/hooks/use_app_toasts.ts instead
 */
const GlobalToaster = ({
  toastLifeTimeMs = 5000
}) => {
  const [{
    toasts
  }, dispatch] = useStateToaster();
  const [isShowing, setIsShowing] = (0, _react.useState)(false);
  const [toastInModal, setToastInModal] = (0, _react.useState)(null);
  const toggle = toast => {
    if (isShowing) {
      dispatch({
        type: 'deleteToaster',
        id: toast.id
      });
      setToastInModal(null);
    } else {
      setToastInModal(toast);
    }
    setIsShowing(!isShowing);
  };
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, toasts.length > 0 && !isShowing && /*#__PURE__*/_react.default.createElement(GlobalToasterListContainer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 130,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiGlobalToastList, {
    toasts: [formatToErrorToastIfNeeded(toasts[0], toggle)],
    dismissToast: ({
      id
    }) => {
      dispatch({
        type: 'deleteToaster',
        id
      });
    },
    toastLifeTimeMs: toastLifeTimeMs,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 131,
      columnNumber: 11
    }
  })), toastInModal != null && /*#__PURE__*/_react.default.createElement(_modal_all_errors.ModalAllErrors, {
    isShowing: isShowing,
    toast: toastInModal,
    toggle: toggle,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 141,
      columnNumber: 9
    }
  }));
};

/**
 * @deprecated Use x-pack/solutions/security/plugins/security_solution/public/common/hooks/use_app_toasts.ts instead
 */
exports.GlobalToaster = GlobalToaster;
const formatToErrorToastIfNeeded = (toast, toggle) => {
  if (toast != null && toast.errors != null && toast.errors.length > 0) {
    toast.text = /*#__PURE__*/_react.default.createElement(ErrorToastContainer, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 156,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      "data-test-subj": "toaster-show-all-error-modal",
      size: "s",
      color: "danger",
      onClick: () => toast != null && toggle(toast),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 157,
        columnNumber: 9
      }
    }, i18n.SEE_ALL_ERRORS));
  }
  return toast;
};

/**
 * @deprecated Use x-pack/solutions/security/plugins/security_solution/public/common/hooks/use_app_toasts.ts instead
 */
const ErrorToastContainer = _styledComponents.default.div`
  text-align: right;
`;

/**
 * @deprecated Use x-pack/solutions/security/plugins/security_solution/public/common/hooks/use_app_toasts.ts instead
 */
ErrorToastContainer.displayName = 'ErrorToastContainer';