"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Table = void 0;
var _responseOpsAlertsTable = require("@kbn/response-ops-alerts-table");
var _react = _interopRequireWildcard(require("react"));
var _kibana = require("../../../common/lib/kibana");
var _actions_cell = require("../../../detections/components/alert_summary/table/actions_cell");
var _render_cell = require("../../../detections/components/alert_summary/table/render_cell");
var _use_browser_fields = require("../../../data_view_manager/hooks/use_browser_fields");
var _constants = require("../../../data_view_manager/constants");
var _table = require("../../../detections/components/alert_summary/table/table");
var _use_additional_bulk_actions = require("../../../detections/hooks/alert_summary/use_additional_bulk_actions");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763899475283842490/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/cases/components/ai_for_soc/table.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/**
 * Component used in the Cases page under Alerts tab, only in the AI4DSOC tier.
 * It leverages a lot of configurations and constants from the Alert summary page alerts table, and renders the ResponseOps AlertsTable.
 */
const Table = exports.Table = /*#__PURE__*/(0, _react.memo)(({
  dataView,
  id,
  onLoaded,
  packages,
  query
}) => {
  const {
    services: {
      application,
      cases,
      data,
      fieldFormats,
      http,
      licensing,
      notifications,
      settings
    }
  } = (0, _kibana.useKibana)();
  const services = (0, _react.useMemo)(() => ({
    cases,
    data,
    http,
    notifications,
    fieldFormats,
    application,
    licensing,
    settings
  }), [application, cases, data, fieldFormats, http, licensing, notifications, settings]);
  const browserFields = (0, _use_browser_fields.useBrowserFields)(_constants.DataViewManagerScopeName.detections, dataView);
  const additionalContext = (0, _react.useMemo)(() => ({
    packages
  }), [packages]);
  const refetchRef = (0, _react.useRef)(null);
  const refetch = (0, _react.useCallback)(() => {
    var _refetchRef$current;
    (_refetchRef$current = refetchRef.current) === null || _refetchRef$current === void 0 ? void 0 : _refetchRef$current.refresh();
  }, []);
  const bulkActions = (0, _use_additional_bulk_actions.useAdditionalBulkActions)({
    refetch
  });
  const runtimeMappings = (0, _react.useMemo)(() => dataView.getRuntimeMappings(), [dataView]);
  return /*#__PURE__*/_react.default.createElement(_table.EuiDataGridStyleWrapper, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 95,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_responseOpsAlertsTable.AlertsTable, {
    actionsColumnWidth: _table.ACTION_COLUMN_WIDTH,
    additionalBulkActions: bulkActions,
    additionalContext: additionalContext,
    browserFields: browserFields,
    casesConfiguration: _table.CASES_CONFIGURATION,
    columns: _table.columns,
    consumers: _table.ALERT_TABLE_CONSUMERS,
    gridStyle: _table.GRID_STYLE,
    id: id,
    onLoaded: onLoaded,
    query: query,
    ref: refetchRef,
    renderActionsCell: _actions_cell.ActionsCell,
    renderCellValue: _render_cell.CellValue,
    rowHeightsOptions: _table.ROW_HEIGHTS_OPTIONS,
    ruleTypeIds: _table.RULE_TYPE_IDS,
    runtimeMappings: runtimeMappings,
    services: services,
    toolbarVisibility: _table.TOOLBAR_VISIBILITY,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 96,
      columnNumber: 7
    }
  }));
});
Table.displayName = 'Table';