"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SearchNotebooks = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _constants = require("../../common/constants");
var _use_notebook_catalog = require("../hooks/use_notebook_catalog");
var _notebooks_list = require("./notebooks_list");
var _selection_panel = require("./selection_panel");
var _title_panel = require("./title_panel");
var _search_notebook = require("./search_notebook");
var _search_labs_button_panel = require("./search_labs_button_panel");
var _notebook_query_param = require("../utils/notebook_query_param");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763899475283842490/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/search/plugins/search_notebooks/public/components/search_notebooks.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const LIST_PANEL_ID = 'notebooksList';
const OUTPUT_PANEL_ID = 'notebooksOutput';
const defaultSizes = {
  [LIST_PANEL_ID]: 25,
  [OUTPUT_PANEL_ID]: 75
};
const SearchNotebooks = () => {
  var _readNotebookParamete;
  const [sizes, setSizes] = (0, _react.useState)(defaultSizes);
  const [selectedNotebookId, setSelectedNotebookId] = (0, _react.useState)((_readNotebookParamete = (0, _notebook_query_param.readNotebookParameter)()) !== null && _readNotebookParamete !== void 0 ? _readNotebookParamete : _constants.DEFAULT_NOTEBOOK_ID);
  const {
    data
  } = (0, _use_notebook_catalog.useNotebooksCatalog)();
  const onPanelWidthChange = (0, _react.useCallback)(newSizes => {
    setSizes(prevSizes => ({
      ...prevSizes,
      ...newSizes
    }));
  }, []);
  (0, _react.useEffect)(() => {
    if (!data) return;
    const selectedNotebookFound = data.notebooks.find(nb => nb.id === selectedNotebookId) !== undefined;
    if (!selectedNotebookFound) {
      // If the currently selected notebook is not in the list of notebooks revert
      // to the default notebook selection.
      setSelectedNotebookId(_constants.DEFAULT_NOTEBOOK_ID);
    }
  }, [data, selectedNotebookId]);
  const notebooks = (0, _react.useMemo)(() => {
    if (data) return data.notebooks;
    return null;
  }, [data]);
  const onNotebookSelectionClick = (0, _react.useCallback)(id => {
    setSelectedNotebookId(id);
  }, []);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiResizableContainer, {
    style: {
      height: '100%',
      width: '100%'
    },
    onPanelWidthChange: onPanelWidthChange,
    "data-test-subj": "consoleEmbeddedNotebooksContainer",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 59,
      columnNumber: 5
    }
  }, (EuiResizablePanel, EuiResizableButton) => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(EuiResizablePanel, {
    id: LIST_PANEL_ID,
    size: sizes[LIST_PANEL_ID],
    minSize: "10%",
    tabIndex: 0,
    paddingSize: "none",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 66,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "none",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 73,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_title_panel.TitlePanel, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 74,
      columnNumber: 15
    }
  }, _i18n.i18n.translate('xpack.searchNotebooks.notebooksList.introduction.title', {
    defaultMessage: 'Introduction'
  })), /*#__PURE__*/_react.default.createElement(_selection_panel.SelectionPanel, {
    id: _constants.INTRODUCTION_NOTEBOOK.id,
    title: _constants.INTRODUCTION_NOTEBOOK.title,
    description: _constants.INTRODUCTION_NOTEBOOK.description,
    onClick: onNotebookSelectionClick,
    isSelected: selectedNotebookId === _constants.INTRODUCTION_NOTEBOOK.id,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 79,
      columnNumber: 15
    }
  }), /*#__PURE__*/_react.default.createElement(_title_panel.TitlePanel, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 86,
      columnNumber: 15
    }
  }, _i18n.i18n.translate('xpack.searchNotebooks.notebooksList.availableNotebooks.title', {
    defaultMessage: 'Notebook previews'
  })), /*#__PURE__*/_react.default.createElement(_notebooks_list.NotebooksList, {
    notebooks: notebooks,
    selectedNotebookId: selectedNotebookId,
    onNotebookSelect: onNotebookSelectionClick,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 91,
      columnNumber: 15
    }
  }), /*#__PURE__*/_react.default.createElement(_search_labs_button_panel.SearchLabsButtonPanel, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 96,
      columnNumber: 15
    }
  }))), /*#__PURE__*/_react.default.createElement(EuiResizableButton, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 100,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(EuiResizablePanel, {
    id: OUTPUT_PANEL_ID,
    size: sizes[OUTPUT_PANEL_ID],
    minSize: "200px",
    tabIndex: 0,
    paddingSize: "none",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 102,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "none",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 109,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 110,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_title_panel.TitlePanel, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 111,
      columnNumber: 17
    }
  }, _i18n.i18n.translate('xpack.searchNotebooks.notebooksList.activeNotebook.title', {
    defaultMessage: 'Active notebook'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 117,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_search_notebook.SearchNotebook, {
    notebookId: selectedNotebookId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 118,
      columnNumber: 17
    }
  }))))));
};
exports.SearchNotebooks = SearchNotebooks;