"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ElasticsearchStart = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _deeplinksSearch = require("@kbn/deeplinks-search");
var _searchSharedUi = require("@kbn/search-shared-ui");
var _constants = require("../../analytics/constants");
var _use_usage_tracker = require("../../hooks/use_usage_tracker");
var _indices = require("../../utils/indices");
var _language = require("../../utils/language");
var _create_index = require("./create_index");
var _create_index_code_view = require("../shared/create_index_code_view");
var _types = require("../../types");
var _create_index_panel = require("../shared/create_index_panel/create_index_panel");
var _use_kibana = require("../../hooks/use_kibana");
var _use_user_permissions = require("../../hooks/api/use_user_permissions");
var _use_workflow = require("../shared/hooks/use_workflow");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763899475283842490/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/search/plugins/search_indices/public/components/start/elasticsearch_start.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function initCreateIndexState() {
  const defaultIndexName = (0, _indices.generateRandomIndexName)();
  return {
    indexName: defaultIndexName,
    defaultIndexName,
    codingLanguage: (0, _language.getDefaultCodingLanguage)()
  };
}
const ElasticsearchStart = () => {
  const {
    application
  } = (0, _use_kibana.useKibana)().services;
  const [formState, setFormState] = (0, _react.useState)(initCreateIndexState);
  const {
    data: userPrivileges
  } = (0, _use_user_permissions.useUserPrivilegesQuery)(formState.defaultIndexName);
  const [createIndexView, setCreateIndexViewMode] = (0, _react.useState)((userPrivileges === null || userPrivileges === void 0 ? void 0 : userPrivileges.privileges.canManageIndex) === false ? _types.CreateIndexViewMode.Code : _types.CreateIndexViewMode.UI);
  const usageTracker = (0, _use_usage_tracker.useUsageTracker)();
  const {
    workflow,
    setSelectedWorkflowId,
    createIndexExamples: selectedCodeExamples
  } = (0, _use_workflow.useWorkflow)();
  (0, _react.useEffect)(() => {
    usageTracker.load(_constants.AnalyticsEvents.startPageOpened);
  }, [usageTracker]);
  (0, _react.useEffect)(() => {
    if (userPrivileges === undefined) return;
    if (userPrivileges.privileges.canManageIndex === false) {
      setCreateIndexViewMode(_types.CreateIndexViewMode.Code);
    }
  }, [userPrivileges]);
  const onChangeView = (0, _react.useCallback)(id => {
    switch (id) {
      case _types.CreateIndexViewMode.UI:
        usageTracker.click(_constants.AnalyticsEvents.startPageShowCreateIndexUIClick);
        setCreateIndexViewMode(_types.CreateIndexViewMode.UI);
        return;
      case _types.CreateIndexViewMode.Code:
        usageTracker.click(_constants.AnalyticsEvents.startPageShowCodeClick);
        setCreateIndexViewMode(_types.CreateIndexViewMode.Code);
        return;
    }
  }, [usageTracker]);
  const onChangeCodingLanguage = (0, _react.useCallback)(language => {
    setFormState({
      ...formState,
      codingLanguage: language
    });
    usageTracker.count([_constants.AnalyticsEvents.startCreateIndexLanguageSelect, `${_constants.AnalyticsEvents.startCreateIndexLanguageSelect}_${language}`]);
  }, [usageTracker, formState, setFormState]);
  const onClose = (0, _react.useCallback)(() => {
    localStorage.setItem(_searchSharedUi.GLOBAL_EMPTY_STATE_SKIP_KEY, 'true');
    application.navigateToApp(_deeplinksSearch.SEARCH_HOMEPAGE);
  }, [application]);
  return /*#__PURE__*/_react.default.createElement(_create_index_panel.CreateIndexPanel, {
    title: _i18n.i18n.translate('xpack.searchIndices.startPage.createIndex.title', {
      defaultMessage: 'Create your first index'
    }),
    createIndexView: createIndexView,
    onChangeView: onChangeView,
    onClose: onClose,
    showSkip: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 106,
      columnNumber: 5
    }
  }, createIndexView === _types.CreateIndexViewMode.UI && /*#__PURE__*/_react.default.createElement(_create_index.CreateIndexUIView, {
    userPrivileges: userPrivileges,
    formState: formState,
    setFormState: setFormState,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 116,
      columnNumber: 9
    }
  }), createIndexView === _types.CreateIndexViewMode.Code && /*#__PURE__*/_react.default.createElement(_create_index_code_view.CreateIndexCodeView, {
    selectedLanguage: formState.codingLanguage,
    indexName: formState.indexName,
    changeCodingLanguage: onChangeCodingLanguage,
    changeWorkflowId: workflowId => {
      setSelectedWorkflowId(workflowId);
      usageTracker.click([_constants.AnalyticsEvents.startCreateIndexWorkflowSelect, `${_constants.AnalyticsEvents.startCreateIndexWorkflowSelect}_${workflowId}`]);
    },
    selectedWorkflow: workflow,
    canCreateApiKey: userPrivileges === null || userPrivileges === void 0 ? void 0 : userPrivileges.privileges.canCreateApiKeys,
    analyticsEvents: {
      runInConsole: _constants.AnalyticsEvents.startCreateIndexRunInConsole,
      installCommands: _constants.AnalyticsEvents.startCreateIndexCodeCopyInstall,
      createIndex: _constants.AnalyticsEvents.startCreateIndexCodeCopy
    },
    selectedCodeExamples: selectedCodeExamples,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 123,
      columnNumber: 9
    }
  }));
};
exports.ElasticsearchStart = ElasticsearchStart;