"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CreateIndexForm = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _sample_data_panel = require("./sample_data_panel");
var _use_ingest_data = require("../../hooks/use_ingest_data");
var _usage_tracker_context = require("../../contexts/usage_tracker_context");
var _constants = require("../../analytics/constants");
var _use_is_sample_data_available = require("../../hooks/use_is_sample_data_available");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763899475283842490/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/search/plugins/search_indices/public/components/shared/create_index_form.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const CreateIndexForm = ({
  indexName,
  indexNameHasError,
  isLoading,
  onCreateIndex,
  onFileUpload,
  onIndexNameChange,
  showAPIKeyCreateLabel,
  userPrivileges
}) => {
  var _userPrivileges$privi, _userPrivileges$privi2, _userPrivileges$privi3;
  const usageTracker = (0, _usage_tracker_context.useUsageTracker)();
  const {
    ingestSampleData,
    isLoading: isIngestingSampleData
  } = (0, _use_ingest_data.useIngestSampleData)();
  const {
    hasRequiredLicense,
    isPluginAvailable: isSampleDataPluginAvailable,
    hasPrivileges: hasSampleDataRequiredPrivileges
  } = (0, _use_is_sample_data_available.useIsSampleDataAvailable)();
  const onIngestSampleData = (0, _react.useCallback)(() => {
    usageTracker.click(_constants.AnalyticsEvents.createIndexIngestSampleDataClick);
    ingestSampleData();
  }, [usageTracker, ingestSampleData]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiForm, {
    "data-test-subj": "createIndexUIView",
    fullWidth: true,
    component: "form",
    onSubmit: onCreateIndex,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 69,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('xpack.searchIndices.shared.createIndex.name.label', {
      defaultMessage: 'Name your index'
    }),
    helpText: _i18n.i18n.translate('xpack.searchIndices.shared.createIndex.name.helpText', {
      defaultMessage: 'Index names must be lowercase and can only contain hyphens and numbers'
    }),
    fullWidth: true,
    isInvalid: indexNameHasError,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 75,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    autoFocus: true,
    fullWidth: true,
    "data-test-subj": "indexNameField",
    name: "indexName",
    value: indexName,
    isInvalid: indexNameHasError,
    disabled: (userPrivileges === null || userPrivileges === void 0 ? void 0 : (_userPrivileges$privi = userPrivileges.privileges) === null || _userPrivileges$privi === void 0 ? void 0 : _userPrivileges$privi.canManageIndex) === false,
    onChange: onIndexNameChange,
    placeholder: _i18n.i18n.translate('xpack.searchIndices.shared.createIndex.name.placeholder', {
      defaultMessage: 'Enter a name for your index'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 86,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 100,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 101,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 102,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: (userPrivileges === null || userPrivileges === void 0 ? void 0 : (_userPrivileges$privi2 = userPrivileges.privileges) === null || _userPrivileges$privi2 === void 0 ? void 0 : _userPrivileges$privi2.canManageIndex) === false ? /*#__PURE__*/_react.default.createElement("p", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 106,
        columnNumber: 19
      }
    }, _i18n.i18n.translate('xpack.searchIndices.shared.createIndex.permissionTooltip', {
      defaultMessage: 'You do not have permission to create an index.'
    })) : undefined,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 103,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    fill: true,
    color: "primary",
    iconSide: "left",
    iconType: "sparkles",
    "data-test-subj": "createIndexBtn",
    disabled: (userPrivileges === null || userPrivileges === void 0 ? void 0 : (_userPrivileges$privi3 = userPrivileges.privileges) === null || _userPrivileges$privi3 === void 0 ? void 0 : _userPrivileges$privi3.canManageIndex) === false || indexNameHasError || isLoading || isIngestingSampleData,
    isLoading: isLoading,
    type: "submit",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 114,
      columnNumber: 15
    }
  }, _i18n.i18n.translate('xpack.searchIndices.shared.createIndex.action.text', {
    defaultMessage: 'Create my index'
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 135,
      columnNumber: 11
    }
  }, showAPIKeyCreateLabel && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 137,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    size: "m",
    type: "key",
    color: "subdued",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 138,
      columnNumber: 17
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    "data-test-subj": "apiKeyLabel",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 139,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 140,
      columnNumber: 19
    }
  }, _i18n.i18n.translate('xpack.searchIndices.shared.createIndex.apiKeyCreation.description', {
    defaultMessage: "We'll create an API key for this index"
  }))))))), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "none",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 154,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    color: "transparent",
    paddingSize: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 155,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "l",
    alignItems: "center",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 156,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 157,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "xs",
    alignItems: "center",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 158,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 159,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued",
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 160,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 161,
      columnNumber: 19
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.searchIndices.shared.createIndex.fileUpload.text",
    defaultMessage: "Already have some data?",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 162,
      columnNumber: 21
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 169,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    color: "primary",
    iconSide: "left",
    iconType: "documents",
    size: "s",
    "data-test-subj": "uploadFileLink",
    onClick: onFileUpload,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 170,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.searchIndices.shared.createIndex.fileUpload.link",
    defaultMessage: "Upload a file",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 178,
      columnNumber: 19
    }
  }))))), isSampleDataPluginAvailable && hasSampleDataRequiredPrivileges && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 187,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_sample_data_panel.SampleDataPanel, {
    isLoading: isIngestingSampleData,
    onIngestSampleData: onIngestSampleData,
    hasRequiredLicense: hasRequiredLicense,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 188,
      columnNumber: 15
    }
  })))));
};
exports.CreateIndexForm = CreateIndexForm;