"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.statusDescriptionMap = exports.healthTitleMap = exports.IndexStatusStat = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _quick_stat = require("./quick_stat");
var _indices = require("../../utils/indices");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763899475283842490/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/search/plugins/search_indices/public/components/quick_stats/index_status_stat.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const healthTitleMap = exports.healthTitleMap = {
  red: _i18n.i18n.translate('xpack.searchIndices.quickStats.indexHealth.red', {
    defaultMessage: 'Red'
  }),
  green: _i18n.i18n.translate('xpack.searchIndices.quickStats.indexHealth.green', {
    defaultMessage: 'Green'
  }),
  yellow: _i18n.i18n.translate('xpack.searchIndices.quickStats.indexHealth.yellow', {
    defaultMessage: 'Yellow'
  }),
  unavailable: _i18n.i18n.translate('xpack.searchIndices.quickStats.indexHealth.unavailable', {
    defaultMessage: 'Unavailable'
  })
};
const statusDescriptionMap = exports.statusDescriptionMap = {
  open: _i18n.i18n.translate('xpack.searchIndices.quickStats.indexStatus.open', {
    defaultMessage: 'Index available'
  }),
  close: _i18n.i18n.translate('xpack.searchIndices.quickStats.indexStatus.close', {
    defaultMessage: 'Index unavailable'
  }),
  undefined: _i18n.i18n.translate('xpack.searchIndices.quickStats.indexStatus.undefined', {
    defaultMessage: 'Unknown'
  })
};
function safelyParseShardCount(count) {
  if (typeof count === 'number') return count;
  const parsedValue = parseInt(count, 10);
  if (!isNaN(parsedValue)) return parsedValue;
  return undefined;
}
const IndexStatusStat = ({
  index,
  open,
  setOpen
}) => {
  var _index$health;
  const {
    replicaShards,
    stats: indexStats
  } = (0, _react.useMemo)(() => {
    var _index$status;
    let primaryShardCount;
    let replicaShardCount;
    const stats = [{
      title: _i18n.i18n.translate('xpack.searchIndices.quickStats.indexStatus.title', {
        defaultMessage: 'Status'
      }),
      description: statusDescriptionMap[(_index$status = index.status) !== null && _index$status !== void 0 ? _index$status : 'undefined']
    }];
    if (index.primary) {
      primaryShardCount = safelyParseShardCount(index.primary);
      stats.push({
        title: _i18n.i18n.translate('xpack.searchIndices.quickStats.indexStatus.primary', {
          defaultMessage: 'Primary shards'
        }),
        description: index.primary
      });
    }
    if (index.replica) {
      replicaShardCount = safelyParseShardCount(index.replica);
      stats.push({
        title: _i18n.i18n.translate('xpack.searchIndices.quickStats.indexStatus.replica', {
          defaultMessage: 'Replica shards'
        }),
        description: index.replica
      });
    }
    return {
      stats,
      primaryShards: primaryShardCount,
      replicaShards: replicaShardCount
    };
  }, [index]);
  return /*#__PURE__*/_react.default.createElement(_quick_stat.QuickStat, {
    open: open,
    setOpen: setOpen,
    icon: "dot",
    iconColor: (0, _indices.indexHealthToHealthColor)(index.health),
    title: healthTitleMap[(0, _indices.normalizeHealth)((_index$health = index.health) !== null && _index$health !== void 0 ? _index$health : 'unavailable')],
    secondaryTitle: index.replica && _i18n.i18n.translate('xpack.searchIndices.quickStats.indexStatus.replicaTitle', {
      defaultMessage: '{replicaShards, plural, one {# Replica} other {# Replicas}}',
      values: {
        replicaShards
      }
    }),
    "data-test-subj": "QuickStatsIndexStatus",
    stats: indexStats,
    statsColumnWidths: [2, 2],
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 88,
      columnNumber: 5
    }
  });
};
exports.IndexStatusStat = IndexStatusStat;