"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.IndexDocuments = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _add_documents_code_example = require("./add_documents_code_example");
var _document_list = require("./document_list");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763899475283842490/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/search/plugins/search_indices/public/components/index_documents/index_documents.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const IndexDocuments = ({
  indexName,
  documents,
  mappings,
  userPrivileges
}) => {
  var _mappings$mappings$pr, _mappings$mappings;
  const mappingProperties = (_mappings$mappings$pr = mappings === null || mappings === void 0 ? void 0 : (_mappings$mappings = mappings.mappings) === null || _mappings$mappings === void 0 ? void 0 : _mappings$mappings.properties) !== null && _mappings$mappings$pr !== void 0 ? _mappings$mappings$pr : {};
  const hasDeleteDocumentsPrivilege = (0, _react.useMemo)(() => {
    var _userPrivileges$privi;
    return (_userPrivileges$privi = userPrivileges === null || userPrivileges === void 0 ? void 0 : userPrivileges.privileges.canDeleteDocuments) !== null && _userPrivileges$privi !== void 0 ? _userPrivileges$privi : false;
  }, [userPrivileges]);
  if (documents.length === 0) {
    return /*#__PURE__*/_react.default.createElement(_add_documents_code_example.AddDocumentsCodeExample, {
      indexName: indexName,
      mappingProperties: mappingProperties,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 37,
        columnNumber: 12
      }
    });
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 41,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement("h4", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 42,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.searchIndices.indexDetail.data.preview.title",
    defaultMessage: "Data preview",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 43,
      columnNumber: 11
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 49,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_document_list.DocumentList, {
    indexName: indexName,
    docs: documents,
    mappingProperties: mappingProperties,
    hasDeleteDocumentsPrivilege: hasDeleteDocumentsPrivilege,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 50,
      columnNumber: 7
    }
  }));
};
exports.IndexDocuments = IndexDocuments;