"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SearchHomepageHeader = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _use_asset_base_path = require("../../hooks/use_asset_base_path");
var _use_kibana = require("../../hooks/use_kibana");
var _stateful_promo = require("./stateful_promo");
var _stateless_promo = require("./stateless_promo");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763899475283842490/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/search/plugins/search_homepage/public/components/header/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const SearchHomepageHeader = () => {
  const {
    euiTheme,
    colorMode
  } = (0, _eui.useEuiTheme)();
  const assetBasePath = (0, _use_asset_base_path.useAssetBasePath)();
  const {
    cloud
  } = (0, _use_kibana.useKibana)().services;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPageTemplate.Section, {
    "data-test-subj": "search-homepage-header",
    paddingSize: "none",
    color: "subdued",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 21,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "m",
    alignItems: "stretch",
    style: {
      paddingLeft: euiTheme.size.xxl,
      paddingRight: euiTheme.size.xxl
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 26,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    style: {
      alignSelf: 'center'
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 34,
      columnNumber: 9
    }
  }, cloud !== null && cloud !== void 0 && cloud.isServerlessEnabled ? /*#__PURE__*/_react.default.createElement(_stateless_promo.StatelessHeaderPromo, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 35,
      columnNumber: 41
    }
  }) : /*#__PURE__*/_react.default.createElement(_stateful_promo.StatefulHeaderPromo, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 35,
      columnNumber: 68
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 38,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiImage, {
    size: "xl",
    src: colorMode === 'LIGHT' ? `${assetBasePath}/search_homepage_light.svg` : `${assetBasePath}/search_homepage_dark.svg`,
    alt: "",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 39,
      columnNumber: 11
    }
  }))));
};
exports.SearchHomepageHeader = SearchHomepageHeader;