"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.mountSection = void 0;
var _react = _interopRequireDefault(require("react"));
var _reactDom = _interopRequireDefault(require("react-dom"));
var _common = require("../../common");
var _tag_management_page = require("./tag_management_page");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763899475283842490/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/saved_objects_tagging/public/management/mount_section.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const RedirectToHomeIfUnauthorized = ({
  applications,
  children
}) => {
  var _applications$capabil, _applications$capabil2, _applications$capabil3, _applications$capabil4;
  const allowed = (_applications$capabil = (_applications$capabil2 = applications.capabilities) === null || _applications$capabil2 === void 0 ? void 0 : (_applications$capabil3 = _applications$capabil2.management) === null || _applications$capabil3 === void 0 ? void 0 : (_applications$capabil4 = _applications$capabil3.kibana) === null || _applications$capabil4 === void 0 ? void 0 : _applications$capabil4.tags) !== null && _applications$capabil !== void 0 ? _applications$capabil : false;
  if (!allowed) {
    applications.navigateToApp('home');
    return null;
  }
  return children;
};
const mountSection = async ({
  tagClient,
  tagCache,
  assignmentService,
  core,
  mountParams,
  title
}) => {
  const [coreStart] = await core.getStartServices();
  const {
    element,
    setBreadcrumbs
  } = mountParams;
  const capabilities = (0, _common.getTagsCapabilities)(coreStart.application.capabilities);
  const assignableTypes = await assignmentService.getAssignableTypes();
  coreStart.chrome.docTitle.change(title);
  _reactDom.default.render(coreStart.rendering.addContext(/*#__PURE__*/_react.default.createElement(RedirectToHomeIfUnauthorized, {
    applications: coreStart.application,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 56,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_tag_management_page.TagManagementPage, {
    setBreadcrumbs: setBreadcrumbs,
    core: coreStart,
    tagClient: tagClient,
    tagCache: tagCache,
    assignmentService: assignmentService,
    capabilities: capabilities,
    assignableTypes: assignableTypes,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 57,
      columnNumber: 9
    }
  }))), element);
  return () => {
    coreStart.chrome.docTitle.reset();
    _reactDom.default.unmountComponentAtNode(element);
  };
};
exports.mountSection = mountSection;