"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ActionBar = void 0;
var _react = _interopRequireWildcard(require("react"));
var _react2 = require("@emotion/react");
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763899475283842490/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/saved_objects_tagging/public/management/components/action_bar.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const actionToMenuItem = (action, onActionSelected, closePopover) => {
  return {
    name: action.label,
    icon: action.icon,
    onClick: () => {
      closePopover();
      onActionSelected(action);
    },
    'data-test-subj': `actionBar-button-${action.id}`
  };
};
const ActionBar = ({
  actions,
  onActionSelected,
  selectedCount,
  totalCount
}) => {
  const [isPopoverOpened, setPopOverOpened] = (0, _react.useState)(false);
  const closePopover = (0, _react.useCallback)(() => {
    setPopOverOpened(false);
  }, [setPopOverOpened]);
  const togglePopover = (0, _react.useCallback)(() => {
    setPopOverOpened(opened => !opened);
  }, [setPopOverOpened]);
  const contextMenuPanels = (0, _react.useMemo)(() => {
    return [{
      id: 0,
      items: actions.map(action => actionToMenuItem(action, onActionSelected, closePopover))
    }];
  }, [actions, onActionSelected, closePopover]);
  return /*#__PURE__*/_react.default.createElement("div", {
    css: styles,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 73,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "flexStart",
    alignItems: "center",
    gutterSize: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 74,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 75,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs",
    color: "subdued",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 76,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.savedObjectsTagging.management.actionBar.totalTagsLabel",
    defaultMessage: "{count, plural, one {1 tag} other {# tags}}",
    values: {
      count: totalCount
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 77,
      columnNumber: 13
    }
  }))), selectedCount > 0 && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 88,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement("div", {
    className: "tagMgt__actionBarDivider",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 89,
      columnNumber: 15
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 91,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    isOpen: isPopoverOpened,
    closePopover: closePopover,
    panelPaddingSize: "none",
    button: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "xs",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 97,
        columnNumber: 19
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      onClick: togglePopover,
      "data-test-subj": "actionBar-contextMenuButton",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 98,
        columnNumber: 21
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.savedObjectsTagging.management.actionBar.selectedTagsLabel",
      defaultMessage: "{count, plural, one {1 selected tag} other {# selected tags}}",
      values: {
        count: selectedCount
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 99,
        columnNumber: 23
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      className: "tagMgt__actionBarIcon",
      type: "arrowDown",
      size: "s",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 106,
        columnNumber: 23
      }
    }))),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 92,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenu, {
    initialPanelId: 0,
    panels: contextMenuPanels,
    "data-test-subj": "actionBar-contextMenu",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 111,
      columnNumber: 17
    }
  }))))));
};
exports.ActionBar = ActionBar;
const styles = ({
  euiTheme
}) => (0, _react2.css)({
  borderBottom: euiTheme.border.thin,
  paddingBotton: euiTheme.size.s,
  '.tagMgt__actionBarIcon': {
    marginLeft: euiTheme.size.xs
  },
  '.tagMgt__actionBarDivider': {
    height: euiTheme.size.base,
    borderRight: euiTheme.border.thin
  }
});