"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.SavedObjectFinderWithoutPersist = exports.SavedObjectFinderUi = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _lodash = require("lodash");
var _propTypes = _interopRequireDefault(require("prop-types"));
var _react = _interopRequireDefault(require("react"));
var _public = require("@kbn/saved-objects-management-plugin/public");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _src = require("@kbn/shared-ux-table-persist/src");
var _common = require("../../common");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763899475283842490/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/shared/saved_objects_finder/public/finder/saved_object_finder.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
const PAGE_SIZE_OPTIONS = [5, 10, 15, 25];
class SavedObjectFinderUiClass extends _react.default.Component {
  constructor(props) {
    super(props);
    (0, _defineProperty2.default)(this, "isComponentMounted", false);
    (0, _defineProperty2.default)(this, "debouncedFetch", (0, _lodash.debounce)(async query => {
      var _getTagFindReferences;
      const metaDataMap = this.getSavedObjectMetaDataMap();
      const {
        contentClient,
        uiSettings
      } = this.props.services;
      const {
        queryText,
        visibleTypes,
        selectedTags
      } = (0, _public.parseQuery)(query, Object.values(metaDataMap).map(metadata => ({
        name: metadata.type,
        namespaceType: 'single',
        hidden: false,
        displayName: metadata.name
      })));
      const includeTags = (_getTagFindReferences = (0, _public.getTagFindReferences)({
        selectedTags,
        taggingApi: this.props.services.savedObjectsTagging
      })) === null || _getTagFindReferences === void 0 ? void 0 : _getTagFindReferences.map(({
        id,
        type
      }) => id);
      const types = visibleTypes !== null && visibleTypes !== void 0 ? visibleTypes : Object.keys(metaDataMap);
      const response = await contentClient.mSearch({
        contentTypes: types.map(type => ({
          contentTypeId: type
        })),
        query: {
          text: queryText ? `${queryText}*` : undefined,
          ...(includeTags !== null && includeTags !== void 0 && includeTags.length ? {
            tags: {
              included: includeTags
            }
          } : {}),
          limit: uiSettings.get(_common.LISTING_LIMIT_SETTING) // TODO: support pagination,
        }
      });
      const savedObjects = response.hits.map(savedObject => {
        const {
          attributes: {
            name,
            title,
            description
          }
        } = savedObject;
        const titleToUse = typeof title === 'string' ? title : '';
        const nameToUse = name ? name : titleToUse;
        return {
          ...savedObject,
          version: savedObject.version,
          title: titleToUse,
          name: nameToUse,
          simple: savedObject,
          description
        };
      }).filter(savedObject => {
        const metaData = metaDataMap[savedObject.type];
        if (metaData.showSavedObject) {
          return metaData.showSavedObject(savedObject.simple);
        }
        return true;
      });
      if (!this.isComponentMounted) {
        return;
      }

      // We need this check to handle the case where search results come back in a different
      // order than they were sent out. Only load results for the most recent search.
      if (query.text === this.state.query.text) {
        this.setState({
          isFetchingItems: false,
          items: savedObjects
        });
      }
    }, 300));
    (0, _defineProperty2.default)(this, "fetchItems", () => {
      this.setState({
        isFetchingItems: true
      }, this.debouncedFetch.bind(null, this.state.query));
    });
    this.state = {
      items: [],
      isFetchingItems: false,
      query: _eui.Query.parse('')
    };
  }
  componentWillUnmount() {
    this.isComponentMounted = false;
    this.debouncedFetch.cancel();
  }
  componentDidMount() {
    this.isComponentMounted = true;
    this.fetchItems();
  }
  getSavedObjectMetaDataMap() {
    return this.props.savedObjectMetaData.reduce((map, metaData) => ({
      ...map,
      [metaData.type]: metaData
    }), {});
  }
  render() {
    var _this$state$query;
    const {
      onChoose,
      savedObjectMetaData,
      euiTablePersist: {
        pageSize,
        sorting,
        onTableChange
      }
    } = this.props;
    const taggingApi = this.props.services.savedObjectsTagging;
    const originalTagColumn = taggingApi === null || taggingApi === void 0 ? void 0 : taggingApi.ui.getTableColumnDefinition();
    const tagColumn = originalTagColumn ? {
      ...originalTagColumn,
      sortable: item => {
        var _originalTagColumn$so;
        return typeof originalTagColumn.sortable === 'function' ? (_originalTagColumn$so = originalTagColumn.sortable(item)) !== null && _originalTagColumn$so !== void 0 ? _originalTagColumn$so : '' : '';
      },
      ['data-test-subj']: 'savedObjectFinderTags'
    } : undefined;
    const typeColumn = savedObjectMetaData.length > 1 ? {
      field: 'type',
      name: _i18n.i18n.translate('savedObjectsFinder.typeName', {
        defaultMessage: 'Type'
      }),
      width: '70px',
      align: 'center',
      description: _i18n.i18n.translate('savedObjectsFinder.typeDescription', {
        defaultMessage: 'Type of the saved object'
      }),
      sortable: ({
        type
      }) => {
        var _currentSavedObjectMe;
        const currentSavedObjectMetaData = savedObjectMetaData.find(metaData => metaData.type === type);
        return (_currentSavedObjectMe = currentSavedObjectMetaData === null || currentSavedObjectMetaData === void 0 ? void 0 : currentSavedObjectMetaData.name) !== null && _currentSavedObjectMe !== void 0 ? _currentSavedObjectMe : '';
      },
      'data-test-subj': 'savedObjectFinderType',
      render: (_, item) => {
        const currentSavedObjectMetaData = savedObjectMetaData.find(metaData => metaData.type === item.type);
        const iconType = (currentSavedObjectMetaData || {
          getIconForSavedObject: () => 'document'
        }).getIconForSavedObject(item.simple);
        return /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
          position: "top",
          content: currentSavedObjectMetaData.name,
          "aria-label": currentSavedObjectMetaData.name,
          type: iconType,
          size: "s",
          "data-test-subj": "objectType",
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 273,
            columnNumber: 17
          }
        });
      }
    } : undefined;
    const columns = [...(typeColumn ? [typeColumn] : []), {
      field: 'title',
      name: _i18n.i18n.translate('savedObjectsFinder.titleName', {
        defaultMessage: 'Title'
      }),
      width: tagColumn ? '55%' : '100%',
      description: _i18n.i18n.translate('savedObjectsFinder.titleDescription', {
        defaultMessage: 'Title of the saved object'
      }),
      dataType: 'string',
      sortable: ({
        name
      }) => name === null || name === void 0 ? void 0 : name.toLowerCase(),
      'data-test-subj': 'savedObjectFinderTitle',
      render: (_, item) => {
        var _this$props$getToolti, _this$props;
        const currentSavedObjectMetaData = savedObjectMetaData.find(metaData => metaData.type === item.type);
        const fullName = currentSavedObjectMetaData.getTooltipForSavedObject ? currentSavedObjectMetaData.getTooltipForSavedObject(item.simple) : `${item.name} (${currentSavedObjectMetaData.name})`;
        const link = /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
          onClick: onChoose ? () => {
            onChoose(item.id, item.type, fullName, item.simple);
          } : undefined,
          title: fullName,
          "data-test-subj": `savedObjectTitle${(item.title || '').split(' ').join('-')}`,
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 308,
            columnNumber: 13
          }
        }, item.name);
        const tooltipText = (_this$props$getToolti = (_this$props = this.props).getTooltipText) === null || _this$props$getToolti === void 0 ? void 0 : _this$props$getToolti.call(_this$props, item);
        const description = !!item.simple.attributes.description && /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
          size: "xs",
          color: "subdued",
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 325,
            columnNumber: 13
          }
        }, item.simple.attributes.description);
        return tooltipText ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
          grow: false,
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 330,
            columnNumber: 13
          }
        }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
          position: "left",
          content: tooltipText,
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 331,
            columnNumber: 15
          }
        }, link), description) : /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
          grow: false,
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 337,
            columnNumber: 13
          }
        }, link, description);
      }
    }, ...(tagColumn ? [tagColumn] : [])];
    const pagination = {
      initialPageSize: !!this.props.fixedPageSize ? this.props.fixedPageSize : pageSize !== null && pageSize !== void 0 ? pageSize : 10,
      pageSize: !!this.props.fixedPageSize ? undefined : pageSize,
      pageSizeOptions: PAGE_SIZE_OPTIONS,
      showPerPageOptions: !this.props.fixedPageSize
    };
    const typeFilter = {
      type: 'field_value_selection',
      field: 'type',
      name: _i18n.i18n.translate('savedObjectsFinder.filterButtonLabel', {
        defaultMessage: 'Types'
      }),
      multiSelect: 'or',
      options: this.props.savedObjectMetaData.map(metaData => ({
        value: metaData.type,
        name: metaData.name
      }))
    };
    const search = {
      onChange: ({
        query
      }) => {
        this.setState({
          query: query !== null && query !== void 0 ? query : _eui.Query.parse('')
        }, this.fetchItems);
      },
      box: {
        incremental: true,
        'data-test-subj': 'savedObjectFinderSearchInput',
        autoFocus: true,
        inputRef: node => {
          requestAnimationFrame(() => {
            // preventing focus loss on the second rendering of the flyout
            // which seems to steal focus from the input
            node === null || node === void 0 ? void 0 : node.focus({
              preventScroll: true
            });
          });
        },
        schema: {
          recognizedFields: ['type', 'tag']
        }
      },
      filters: this.props.showFilter ? [...(savedObjectMetaData.length > 1 ? [typeFilter] : []), ...(taggingApi ? [taggingApi.ui.getSearchBarFilter({
        useName: true
      })] : [])] : undefined,
      toolsRight: this.props.children ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, this.props.children) : undefined,
      toolsLeft: this.props.leftChildren ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, this.props.leftChildren) : undefined
    };
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      direction: "column",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 394,
        columnNumber: 7
      }
    }, this.props.helpText ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 396,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s",
      color: "subdued",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 397,
        columnNumber: 13
      }
    }, this.props.helpText)) : undefined, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 402,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiInMemoryTable, {
      loading: this.state.isFetchingItems,
      itemId: "id",
      items: this.state.items,
      columns: columns,
      "data-test-subj": "savedObjectsFinderTable",
      message: this.props.noItemsMessage,
      search: search,
      pagination: pagination,
      sorting: !!((_this$state$query = this.state.query) !== null && _this$state$query !== void 0 && _this$state$query.text) ? undefined : sorting,
      onTableChange: onTableChange,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 403,
        columnNumber: 11
      }
    })));
  }
}
(0, _defineProperty2.default)(SavedObjectFinderUiClass, "propTypes", {
  onChoose: _propTypes.default.func,
  noItemsMessage: _propTypes.default.node,
  savedObjectMetaData: _propTypes.default.array.isRequired,
  initialPageSize: _propTypes.default.oneOf([5, 10, 15, 25]),
  fixedPageSize: _propTypes.default.number,
  showFilter: _propTypes.default.bool
});
const SavedObjectFinderUi = exports.SavedObjectFinderUi = (0, _src.withEuiTablePersist)(SavedObjectFinderUiClass, {
  get: props => {
    var _ref, _props$initialPageSiz;
    return {
      tableId: `soFinder-${props.id}`,
      pageSizeOptions: PAGE_SIZE_OPTIONS,
      initialPageSize: (_ref = (_props$initialPageSiz = props.initialPageSize) !== null && _props$initialPageSiz !== void 0 ? _props$initialPageSiz : props.fixedPageSize) !== null && _ref !== void 0 ? _ref : 10
    };
  }
});
const SavedObjectFinderWithoutPersist = exports.SavedObjectFinderWithoutPersist = SavedObjectFinderUiClass; // For testing

// Needed for React.lazy
// eslint-disable-next-line import/no-default-export
var _default = exports.default = SavedObjectFinderUi;