"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.App = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _reactRouterDom = require("react-router-dom");
var _sharedUxRouter = require("@kbn/shared-ux-router");
var _constants = require("./constants");
var _services = require("./services");
var _sections = require("./sections");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763899475283842490/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/remote_clusters/public/application/app.js";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
class AppComponent extends _react.Component {
  constructor(...args) {
    super(...args);
    (0, _services.setUserHasLeftApp)(false);
    this.registerRouter();
  }
  registerRouter() {
    // Share the router with the app without requiring React or context.
    const {
      history
    } = this.props;
    (0, _services.registerRouter)({
      history,
      route: {
        location: history.location
      }
    });
  }
  componentDidMount() {
    (0, _services.trackUiMetric)(_services.METRIC_TYPE.LOADED, _constants.UIM_APP_LOAD);
  }
  componentWillUnmount() {
    // Set internal flag so we can prevent reacting to route changes internally.
    (0, _services.setUserHasLeftApp)(true);
  }
  render() {
    return /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Router, {
      history: this.props.history,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 51,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Routes, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 52,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
      exact: true,
      path: [`/list`, '/', ''],
      component: _sections.RemoteClusterList,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 53,
        columnNumber: 11
      }
    }), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
      path: [`/add`],
      component: _sections.RemoteClusterAdd,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 54,
        columnNumber: 11
      }
    }), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
      path: `/edit/:name`,
      component: _sections.RemoteClusterEdit,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 55,
        columnNumber: 11
      }
    }), /*#__PURE__*/_react.default.createElement(_reactRouterDom.Redirect, {
      from: `/:anything`,
      to: "/list",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 56,
        columnNumber: 11
      }
    })));
  }
}
(0, _defineProperty2.default)(AppComponent, "propTypes", {
  history: _propTypes.default.shape({
    push: _propTypes.default.func.isRequired,
    createHref: _propTypes.default.func.isRequired
  }).isRequired
});
const App = exports.App = AppComponent;