"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StorageDetailsTable = StorageDetailsTable;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireWildcard(require("react"));
var _common = require("@kbn/observability-plugin/common");
var _common2 = require("../../../../common");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763899475283842490/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/profiling/public/views/storage_explorer/data_breakdown/storage_details_table.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const sorting = {
  sort: {
    field: 'sizeInBytes',
    direction: 'desc'
  }
};
function StorageDetailsTable({
  data = []
}) {
  const [pagination, setPagination] = (0, _react.useState)({
    pageIndex: 0
  });
  function onTableChange({
    page: {
      index
    }
  }) {
    setPagination({
      pageIndex: index
    });
  }
  const columns = (0, _react.useMemo)(() => [{
    field: 'indexName',
    name: _i18n.i18n.translate('xpack.profiling.storageExplorer.dataBreakdown.storageDetailsTable.index', {
      defaultMessage: 'Index'
    }),
    sortable: true
  }, {
    field: 'primaryShardsCount',
    width: '150px',
    name: _i18n.i18n.translate('xpack.profiling.storageExplorer.dataBreakdown.storageDetailsTable.primaries', {
      defaultMessage: 'Primaries'
    }),
    render: (_, {
      primaryShardsCount
    }) => primaryShardsCount !== null && primaryShardsCount !== void 0 ? primaryShardsCount : _common2.NOT_AVAILABLE_LABEL,
    sortable: true
  }, {
    field: 'replicaShardsCount',
    width: '150px',
    name: _i18n.i18n.translate('xpack.profiling.storageExplorer.dataBreakdown.storageDetailsTable.replicas', {
      defaultMessage: 'Replicas'
    }),
    render: (_, {
      replicaShardsCount
    }) => replicaShardsCount !== null && replicaShardsCount !== void 0 ? replicaShardsCount : _common2.NOT_AVAILABLE_LABEL,
    sortable: true
  }, {
    field: 'docCount',
    width: '150px',
    name: _i18n.i18n.translate('xpack.profiling.storageExplorer.dataBreakdown.storageDetailsTable.docCount', {
      defaultMessage: 'Doc count'
    }),
    sortable: true,
    render: (_, {
      docCount
    }) => docCount ? (0, _common.asInteger)(docCount) : _common2.NOT_AVAILABLE_LABEL
  }, {
    field: 'sizeInBytes',
    width: '150px',
    name: _i18n.i18n.translate('xpack.profiling.storageExplorer.dataBreakdown.storageDetailsTable.storageSize', {
      defaultMessage: 'Storage size'
    }),
    sortable: true,
    render: (_, {
      sizeInBytes
    }) => sizeInBytes ? (0, _common.asDynamicBytes)(sizeInBytes) : _common2.NOT_AVAILABLE_LABEL
  }, {
    field: 'dataStream',
    name: _i18n.i18n.translate('xpack.profiling.storageExplorer.dataBreakdown.storageDetailsTable.dataStream', {
      defaultMessage: 'Data stream'
    }),
    sortable: true,
    render: (_, {
      dataStream
    }) => dataStream !== null && dataStream !== void 0 ? dataStream : _common2.NOT_AVAILABLE_LABEL
  }, {
    field: 'lifecyclePhase',
    width: '150px',
    name: _i18n.i18n.translate('xpack.profiling.storageExplorer.dataBreakdown.storageDetailsTable.lifecyclePhase', {
      defaultMessage: 'Lifecycle phase'
    }),
    sortable: true,
    render: (_, {
      lifecyclePhase
    }) => lifecyclePhase !== null && lifecyclePhase !== void 0 ? lifecyclePhase : _common2.NOT_AVAILABLE_LABEL
  }], []);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xxxs",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 109,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 110,
      columnNumber: 9
    }
  }, _i18n.i18n.translate('xpack.profiling.storageExplorer.dataBreakdown.storageDetailsTable.title', {
    defaultMessage: 'Indices breakdown'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiInMemoryTable, {
    items: data,
    columns: columns,
    sorting: sorting,
    pagination: {
      pageSize: 10,
      showPerPageOptions: false,
      ...pagination
    },
    onTableChange: onTableChange,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 117,
      columnNumber: 7
    }
  }));
}