"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EmbeddableFunctionsGrid = EmbeddableFunctionsGrid;
var _profilingUtils = require("@kbn/profiling-utils");
var _react = _interopRequireWildcard(require("react"));
var _topn_functions = require("../../components/topn_functions");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763899475283842490/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/profiling/public/embeddables/functions/embeddable_functions_grid.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function EmbeddableFunctionsGrid({
  data,
  totalSeconds,
  showFullScreenSelector
}) {
  const [sortField, setSortField] = (0, _react.useState)(_profilingUtils.TopNFunctionSortField.Rank);
  const [sortDirection, setSortDirection] = (0, _react.useState)('asc');
  const [pageIndex, setPageIndex] = (0, _react.useState)(0);
  const [searchFunctionName, setSearchFunctionName] = (0, _react.useState)('');
  return /*#__PURE__*/_react.default.createElement(_topn_functions.TopNFunctionsGrid, {
    topNFunctions: data,
    totalSeconds: totalSeconds,
    isDifferentialView: false,
    pageIndex: pageIndex,
    onChangePage: setPageIndex,
    sortField: sortField,
    sortDirection: sortDirection,
    onChangeSort: sorting => {
      setSortField(sorting.id);
      setSortDirection(sorting.direction);
    },
    isEmbedded: true,
    showFullScreenSelector: showFullScreenSelector,
    onSearchFunctionNameChange: setSearchFunctionName,
    searchFunctionName: searchFunctionName,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 27,
      columnNumber: 5
    }
  });
}