"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.LabsBeakerButton = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _labs_flyout = require("./labs_flyout");
var _presentation_labs_service = require("../../services/presentation_labs_service");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763899475283842490/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/shared/presentation_util/public/components/labs/labs_beaker_button.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const LabsBeakerButton = ({
  solutions,
  ...props
}) => {
  const labsService = (0, _react.useMemo)(() => (0, _presentation_labs_service.getPresentationLabsService)(), []);
  const [isOpen, setIsOpen] = (0, _react.useState)(false);
  const projects = labsService.getProjects();
  const [overrideCount, onEnabledCountChange] = (0, _react.useState)(Object.values(projects).filter(project => project.status.isOverride).length);
  const onButtonClick = () => setIsOpen(open => !open);
  const onClose = () => setIsOpen(false);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, (0, _extends2.default)({}, props, {
    onClick: onButtonClick,
    minWidth: 0,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 36,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "beaker",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 37,
      columnNumber: 9
    }
  }), overrideCount > 0 ? /*#__PURE__*/_react.default.createElement(_eui.EuiNotificationBadge, {
    color: "subdued",
    css: {
      marginLeft: 2
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 39,
      columnNumber: 11
    }
  }, overrideCount) : null), isOpen ? /*#__PURE__*/_react.default.createElement(_labs_flyout.LabsFlyout, {
    onClose,
    solutions,
    onEnabledCountChange,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 44,
      columnNumber: 17
    }
  }) : null);
};

// required for dynamic import using React.lazy()
// eslint-disable-next-line import/no-default-export
exports.LabsBeakerButton = LabsBeakerButton;
var _default = exports.default = LabsBeakerButton;