"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SECURITY_APP_NAME = exports.AddToTimelineButton = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _lodash = require("lodash");
var _eui = require("@elastic/eui");
var _kibana = require("../common/lib/kibana");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763899475283842490/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/osquery/public/timelines/add_to_timeline_button.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const TimelineComponent = /*#__PURE__*/_react.default.memo(props => /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, (0, _extends2.default)({}, props, {
  size: "xs",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 13,
    columnNumber: 49
  }
})));
TimelineComponent.displayName = 'TimelineComponent';
const SECURITY_APP_NAME = exports.SECURITY_APP_NAME = 'Security';
const AddToTimelineButton = props => {
  const {
    timelines,
    appName,
    analytics,
    i18n,
    theme
  } = (0, _kibana.useKibana)().services;
  const startServices = {
    analytics,
    i18n,
    theme
  };
  const {
    field,
    value,
    isIcon,
    iconProps
  } = props;
  const queryIds = (0, _lodash.isArray)(value) ? value : [value];
  const TimelineIconComponent = (0, _react.useCallback)(timelineComponentProps => /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, (0, _extends2.default)({
    iconType: "timelines"
  }, timelineComponentProps, {
    size: "xs"
  }, iconProps, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 32,
      columnNumber: 7
    }
  })), [iconProps]);
  if (!timelines || appName !== SECURITY_APP_NAME || !queryIds.length) {
    return null;
  }
  const {
    getAddToTimelineButton
  } = timelines.getHoverActions();
  const providers = queryIds.map(queryId => ({
    and: [],
    enabled: true,
    excluded: false,
    id: queryId,
    kqlQuery: '',
    name: queryId,
    queryMatch: {
      field,
      value: queryId,
      operator: ':'
    }
  }));
  return getAddToTimelineButton({
    dataProvider: providers,
    field: queryIds[0],
    ownFocus: false,
    ...(isIcon ? {
      showTooltip: true,
      Component: TimelineIconComponent
    } : {
      Component: TimelineComponent
    }),
    startServices
  });
};
exports.AddToTimelineButton = AddToTimelineButton;