"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.defaultEcsFormData = exports.default = exports.OsqueryColumnField = exports.ECSMappingEditorForm = exports.ECSMappingEditorField = exports.ECSComboboxField = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _lodash = require("lodash");
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _sqlParser = _interopRequireDefault(require("@appland/sql-parser"));
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _fastDeepEqual = _interopRequireDefault(require("fast-deep-equal"));
var _reactHookForm = require("react-hook-form");
var _converters = require("../../../common/utils/converters");
var _v = _interopRequireDefault(require("../../common/schemas/ecs/v9.1.0.json"));
var _v2 = _interopRequireDefault(require("../../common/schemas/osquery/v5.18.1.json"));
var _kibana = require("../../common/lib/kibana");
var _osquery_icon = require("../../components/osquery_icon");
var _remove_multilines = require("../../../common/utils/build_query/remove_multilines");
var _utils = require("../utils");
var _ecs_field_css = require("./ecs_field_css");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763899475283842490/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/osquery/public/packs/queries/ecs_mapping_editor_field.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const typeMap = {
  binary: 'binary',
  half_float: 'number',
  scaled_float: 'number',
  float: 'number',
  integer: 'number',
  long: 'number',
  short: 'number',
  byte: 'number',
  text: 'string',
  keyword: 'string',
  '': 'string',
  geo_point: 'geo_point',
  date: 'date',
  ip: 'ip',
  boolean: 'boolean',
  constant_keyword: 'string'
};
const SINGLE_SELECTION = {
  asPlainText: true
};
const ECSSchemaOptions = _v.default.map(ecs => ({
  label: ecs.field,
  value: ecs
}));
const ECSComboboxFieldComponent = ({
  euiFieldProps = {},
  idAria,
  index,
  watch,
  control
}) => {
  var _ECSFieldState$error, _ECSFieldState$error2, _ECSFieldState$error3, _ECSFieldState$error4, _ECSFieldState$error5, _ECSFieldState$error6;
  const {
    ecsMappingArray
  } = watch();
  const ecsCurrentMapping = (0, _lodash.get)(ecsMappingArray, `[${index}].result.value`);
  const ecsFieldValidator = (0, _react.useCallback)(value => !(value !== null && value !== void 0 && value.length) && ecsCurrentMapping !== null && ecsCurrentMapping !== void 0 && ecsCurrentMapping.length ? _i18n.i18n.translate('xpack.osquery.pack.queryFlyoutForm.ecsFieldRequiredErrorMessage', {
    defaultMessage: 'ECS field is required.'
  }) : undefined, [ecsCurrentMapping === null || ecsCurrentMapping === void 0 ? void 0 : ecsCurrentMapping.length]);
  const {
    field: ECSField,
    fieldState: ECSFieldState
  } = (0, _reactHookForm.useController)({
    control,
    name: `ecsMappingArray.${index}.key`,
    rules: {
      validate: ecsFieldValidator
    },
    defaultValue: ''
  });
  const [selectedOptions, setSelected] = (0, _react.useState)([]);
  const describedByIds = (0, _react.useMemo)(() => idAria ? [idAria] : [], [idAria]);
  const {
    ecsMappingArray: watchedEcsMapping
  } = watch();
  const handleChange = (0, _react.useCallback)(newSelectedOptions => {
    var _newSelectedOptions$, _newSelectedOptions$2;
    setSelected(newSelectedOptions);
    ECSField.onChange((_newSelectedOptions$ = (_newSelectedOptions$2 = newSelectedOptions[0]) === null || _newSelectedOptions$2 === void 0 ? void 0 : _newSelectedOptions$2.label) !== null && _newSelectedOptions$ !== void 0 ? _newSelectedOptions$ : '');
  }, [ECSField]);

  // TODO: Create own component for this.
  const renderOption = (0, _react.useCallback)((option, searchValue, contentClassName) => {
    var _typeMap$option$value;
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      className: `${contentClassName} euiSuggestItem euiSuggestItem--truncate`,
      alignItems: "center",
      gutterSize: "none",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 152,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 157,
        columnNumber: 9
      }
    },
    /*#__PURE__*/
    // @ts-expect-error update types
    _react.default.createElement(_kibana.FieldIcon, {
      type: (_typeMap$option$value = typeMap[option.value.type]) !== null && _typeMap$option$value !== void 0 ? _typeMap$option$value : option.value.type,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 160,
        columnNumber: 13
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 163,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement("span", {
      css: _ecs_field_css.fieldSpanCss,
      className: "euiSuggestItem__label euiSuggestItem__label--expand",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 164,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement("b", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 165,
        columnNumber: 13
      }
    }, option.value.field))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      css: _ecs_field_css.descriptionWrapperCss,
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 169,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement("span", {
      css: _ecs_field_css.fieldSpanCss,
      className: "euiSuggestItem__description euiSuggestItem__description",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 170,
        columnNumber: 11
      }
    }, option.value.description)));
  }, []);
  const prepend = (0, _react.useMemo)(() => {
    var _typeMap$selectedOpti, _selectedOptions$, _selectedOptions$$val, _selectedOptions$2, _selectedOptions$2$va;
    return /*#__PURE__*/_react.default.createElement(_kibana.FieldIcon, {
      css: _ecs_field_css.fieldIconCss,
      size: "l",
      type: // @ts-expect-error update types
      (_typeMap$selectedOpti = typeMap[(_selectedOptions$ = selectedOptions[0]) === null || _selectedOptions$ === void 0 ? void 0 : (_selectedOptions$$val = _selectedOptions$.value) === null || _selectedOptions$$val === void 0 ? void 0 : _selectedOptions$$val.type]) !== null && _typeMap$selectedOpti !== void 0 ? _typeMap$selectedOpti : (_selectedOptions$2 = selectedOptions[0]) === null || _selectedOptions$2 === void 0 ? void 0 : (_selectedOptions$2$va = _selectedOptions$2.value) === null || _selectedOptions$2$va === void 0 ? void 0 : _selectedOptions$2$va.type,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 184,
        columnNumber: 7
      }
    });
  }, [selectedOptions]);
  const helpText = (0, _react.useMemo)(() => {
    var _selectedOptions$3, _selectedOptions$3$va, _selectedOptions$4, _selectedOptions$4$va;
    // @ts-expect-error update types
    let text = (_selectedOptions$3 = selectedOptions[0]) === null || _selectedOptions$3 === void 0 ? void 0 : (_selectedOptions$3$va = _selectedOptions$3.value) === null || _selectedOptions$3$va === void 0 ? void 0 : _selectedOptions$3$va.description;
    if (!text) return;

    // @ts-expect-error update types
    const example = (_selectedOptions$4 = selectedOptions[0]) === null || _selectedOptions$4 === void 0 ? void 0 : (_selectedOptions$4$va = _selectedOptions$4.value) === null || _selectedOptions$4$va === void 0 ? void 0 : _selectedOptions$4$va.example;
    if (example) {
      text += ` e.g. ${JSON.stringify(example)}`;
    }
    return text;
  }, [selectedOptions]);
  const availableECSSchemaOptions = (0, _react.useMemo)(() => {
    const currentFormECSFieldValues = (0, _lodash.map)(watchedEcsMapping, 'key');
    return ECSSchemaOptions.filter(({
      label
    }) => !currentFormECSFieldValues.includes(label));
  }, [watchedEcsMapping]);
  (0, _react.useEffect)(() => {
    // @ts-expect-error update types
    setSelected(() => {
      var _ECSField$value;
      if (!((_ECSField$value = ECSField.value) !== null && _ECSField$value !== void 0 && _ECSField$value.length)) return [];
      const selectedOption = (0, _lodash.find)(ECSSchemaOptions, ['label', ECSField.value]);
      return selectedOption ? [selectedOption] : [{
        label: ECSField.value,
        value: {
          value: ECSField.value
        }
      }];
    });
  }, [ECSField.value]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('xpack.osquery.pack.queryFlyoutForm.mappingEcsFieldLabel', {
      defaultMessage: 'ECS field'
    }),
    helpText: helpText,
    error: (_ECSFieldState$error = ECSFieldState.error) === null || _ECSFieldState$error === void 0 ? void 0 : _ECSFieldState$error.message,
    isInvalid: !!((_ECSFieldState$error2 = ECSFieldState.error) !== null && _ECSFieldState$error2 !== void 0 && (_ECSFieldState$error3 = _ECSFieldState$error2.message) !== null && _ECSFieldState$error3 !== void 0 && _ECSFieldState$error3.length),
    fullWidth: true,
    describedByIds: describedByIds,
    isDisabled: euiFieldProps.isDisabled,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 238,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, (0, _extends2.default)({
    isInvalid: !!((_ECSFieldState$error4 = ECSFieldState.error) !== null && _ECSFieldState$error4 !== void 0 && (_ECSFieldState$error5 = _ECSFieldState$error4.message) !== null && _ECSFieldState$error5 !== void 0 && _ECSFieldState$error5.length),
    prepend: prepend,
    fullWidth: true,
    singleSelection: SINGLE_SELECTION,
    error: (_ECSFieldState$error6 = ECSFieldState.error) === null || _ECSFieldState$error6 === void 0 ? void 0 : _ECSFieldState$error6.message
    // @ts-expect-error update types
    ,
    options: availableECSSchemaOptions,
    selectedOptions: selectedOptions,
    onChange: handleChange,
    "data-test-subj": "ECS-field-input",
    renderOption: renderOption,
    rowHeight: 32,
    isClearable: true
  }, euiFieldProps, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 249,
      columnNumber: 7
    }
  })));
};
const ECSComboboxField = exports.ECSComboboxField = /*#__PURE__*/_react.default.memo(ECSComboboxFieldComponent, _fastDeepEqual.default);
const OSQUERY_COLUMN_VALUE_TYPE_OPTIONS = [{
  value: 'field',
  inputDisplay: /*#__PURE__*/_react.default.createElement(_osquery_icon.OsqueryIcon, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 274,
      columnNumber: 19
    }
  }),
  dropdownDisplay: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "xs",
    alignItems: "center",
    justifyContent: "center",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 276,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 277,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_osquery_icon.OsqueryIcon, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 278,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 280,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    className: "eui-textNoWrap",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 281,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.osquery.pack.form.ecsMappingSection.osqueryValueOptionLabel",
    defaultMessage: "Osquery value",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 282,
      columnNumber: 13
    }
  }))))
}, {
  value: 'value',
  inputDisplay: /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "user",
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 293,
      columnNumber: 19
    }
  }),
  dropdownDisplay: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "xs",
    alignItems: "center",
    justifyContent: "center",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 295,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 296,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "user",
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 297,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 299,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    className: "eui-textNoWrap",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 300,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.osquery.pack.form.ecsMappingSection.staticValueOptionLabel",
    defaultMessage: "Static value",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 301,
      columnNumber: 13
    }
  }))))
}];
const EMPTY_ARRAY = [];
const OsqueryColumnFieldComponent = ({
  euiFieldProps,
  idAria,
  index,
  isLastItem,
  control,
  watch,
  trigger
}) => {
  var _selectedOptions$5, _selectedOptions$5$va, _resultFieldState$err, _resultFieldState$err2, _resultFieldState$err3, _resultFieldState$err4, _selectedOptions$6, _selectedOptions$6$va;
  const {
    ecsMappingArray
  } = watch();
  const osqueryResultFieldValidator = (0, _react.useCallback)(value => {
    var _currentMapping$key, _currentMapping$resul;
    const currentMapping = ecsMappingArray && ecsMappingArray[index];
    if (!(value !== null && value !== void 0 && value.length) && currentMapping !== null && currentMapping !== void 0 && (_currentMapping$key = currentMapping.key) !== null && _currentMapping$key !== void 0 && _currentMapping$key.length) {
      return _i18n.i18n.translate('xpack.osquery.pack.queryFlyoutForm.osqueryResultFieldRequiredErrorMessage', {
        defaultMessage: 'Value field is required.'
      });
    }
    if (!(value !== null && value !== void 0 && value.length) || (currentMapping === null || currentMapping === void 0 ? void 0 : (_currentMapping$resul = currentMapping.result) === null || _currentMapping$resul === void 0 ? void 0 : _currentMapping$resul.type) !== 'field') return;
    const osqueryColumnExists = (0, _lodash.find)(euiFieldProps.options, ['label', (0, _lodash.isArray)(value) ? value[0] : value]);
    return !osqueryColumnExists ? _i18n.i18n.translate('xpack.osquery.pack.queryFlyoutForm.osqueryResultFieldValueMissingErrorMessage', {
      defaultMessage: 'The current query does not return a {columnName} field',
      values: {
        columnName: (0, _lodash.isArray)(value) ? value[0] : value
      }
    }) : undefined;
  }, [ecsMappingArray, euiFieldProps.options, index]);
  const {
    field: resultTypeField
  } = (0, _reactHookForm.useController)({
    control,
    name: `ecsMappingArray.${index}.result.type`,
    defaultValue: OSQUERY_COLUMN_VALUE_TYPE_OPTIONS[0].value
  });
  const {
    field: resultField,
    fieldState: resultFieldState
  } = (0, _reactHookForm.useController)({
    control,
    name: `ecsMappingArray.${index}.result.value`,
    rules: {
      validate: osqueryResultFieldValidator
    },
    defaultValue: ''
  });
  const inputRef = (0, _react.useRef)();
  const [selectedOptions, setSelected] = (0, _react.useState)([]);
  const describedByIds = (0, _react.useMemo)(() => idAria ? [idAria] : [], [idAria]);
  const renderOsqueryOption = (0, _react.useCallback)((option, searchValue, contentClassName) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    className: `${contentClassName} euiSuggestItem euiSuggestItem--truncate`,
    alignItems: "center",
    gutterSize: "none",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 391,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 396,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement("span", {
    css: _ecs_field_css.fieldSpanCss,
    className: "euiSuggestItem__label euiSuggestItem__label--expand",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 397,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement("b", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 398,
      columnNumber: 13
    }
  }, option.value.suggestion_label))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    css: _ecs_field_css.descriptionWrapperCss,
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 401,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement("span", {
    css: _ecs_field_css.fieldSpanCss,
    className: "euiSuggestItem__description euiSuggestItem__description",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 402,
      columnNumber: 11
    }
  }, option.value.description))), []);
  const handleKeyChange = (0, _react.useCallback)(newSelectedOptions => {
    var _newSelectedOptions$3, _newSelectedOptions$4;
    setSelected(newSelectedOptions);
    resultField.onChange((0, _lodash.isArray)(newSelectedOptions) ? (0, _lodash.map)(newSelectedOptions, 'label') : (_newSelectedOptions$3 = (_newSelectedOptions$4 = newSelectedOptions[0]) === null || _newSelectedOptions$4 === void 0 ? void 0 : _newSelectedOptions$4.label) !== null && _newSelectedOptions$3 !== void 0 ? _newSelectedOptions$3 : '');
  }, [resultField]);
  const isSingleSelection = (0, _react.useMemo)(() => {
    var _ecsData$key, _ecsData$key2, _ecsData$key3;
    const ecsData = (0, _lodash.get)(ecsMappingArray, `${index}`);
    if (ecsData !== null && ecsData !== void 0 && (_ecsData$key = ecsData.key) !== null && _ecsData$key !== void 0 && _ecsData$key.length && resultTypeField.value === 'value') {
      var _ecsKeySchemaOption$v;
      const ecsKeySchemaOption = (0, _lodash.find)(ECSSchemaOptions, ['label', ecsData === null || ecsData === void 0 ? void 0 : ecsData.key]);
      return (ecsKeySchemaOption === null || ecsKeySchemaOption === void 0 ? void 0 : (_ecsKeySchemaOption$v = ecsKeySchemaOption.value) === null || _ecsKeySchemaOption$v === void 0 ? void 0 : _ecsKeySchemaOption$v.normalization) !== 'array';
    }
    if (!(ecsData !== null && ecsData !== void 0 && (_ecsData$key2 = ecsData.key) !== null && _ecsData$key2 !== void 0 && _ecsData$key2.length) && isLastItem) {
      return true;
    }
    return !!(ecsData !== null && ecsData !== void 0 && (_ecsData$key3 = ecsData.key) !== null && _ecsData$key3 !== void 0 && _ecsData$key3.length);
  }, [ecsMappingArray, index, isLastItem, resultTypeField.value]);
  const onTypeChange = (0, _react.useCallback)(newType => {
    if (newType !== resultTypeField.value) {
      resultTypeField.onChange(newType);
      resultField.onChange(newType === 'value' && isSingleSelection === false ? [] : '');
    }
  }, [isSingleSelection, resultField, resultTypeField]);
  const handleCreateOption = (0, _react.useCallback)(newOption => {
    const trimmedNewOption = (0, _lodash.trim)(newOption);
    if (!trimmedNewOption.length) return;
    if (isSingleSelection === false) {
      var _resultField$value, _inputRef$current;
      resultField.onChange([trimmedNewOption]);
      if ((_resultField$value = resultField.value) !== null && _resultField$value !== void 0 && _resultField$value.length) {
        resultField.onChange([...(0, _lodash.castArray)(resultField.value), trimmedNewOption]);
      } else {
        resultField.onChange([trimmedNewOption]);
      }
      (_inputRef$current = inputRef.current) === null || _inputRef$current === void 0 ? void 0 : _inputRef$current.blur();
    } else {
      resultField.onChange(trimmedNewOption);
    }
  }, [isSingleSelection, resultField]);
  const Prepend = (0, _react.useMemo)(() => /*#__PURE__*/_react.default.createElement(_eui.EuiSuperSelect, {
    css: _ecs_field_css.euiSuperSelectCss,
    disabled: euiFieldProps.isDisabled,
    options: OSQUERY_COLUMN_VALUE_TYPE_OPTIONS,
    "data-test-subj": `osquery-result-type-select-${index}`,
    valueOfSelected: resultTypeField.value || OSQUERY_COLUMN_VALUE_TYPE_OPTIONS[0].value
    // eslint-disable-next-line react-perf/jsx-no-new-object-as-prop
    ,
    popoverProps: {
      panelStyle: {
        minWidth: '250px'
      }
    },
    onChange: onTypeChange,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 475,
      columnNumber: 7
    }
  }), [euiFieldProps.isDisabled, index, onTypeChange, resultTypeField.value]);
  (0, _react.useEffect)(() => {
    if (isSingleSelection && (0, _lodash.isArray)(resultField.value)) {
      resultField.onChange(resultField.value.join(' '));
    }
    if (!isSingleSelection && !(0, _lodash.isArray)(resultField.value)) {
      const value = resultField.value.length ? [resultField.value] : [];
      resultField.onChange(value);
    }
  }, [index, isSingleSelection, resultField, resultField.value]);
  (0, _react.useEffect)(() => {
    // @ts-expect-error hard to type to satisfy TS, but it represents proper types
    setSelected(_ => {
      var _resultField$value2;
      if (!((_resultField$value2 = resultField.value) !== null && _resultField$value2 !== void 0 && _resultField$value2.length)) return [];

      // Static array values
      if ((0, _lodash.isArray)(resultField.value)) {
        return resultField.value.map(value => ({
          label: value
        }));
      }
      const selectedOption = (0, _lodash.find)(euiFieldProps === null || euiFieldProps === void 0 ? void 0 : euiFieldProps.options, ['label', resultField.value]);
      return selectedOption ? [selectedOption] : [{
        label: resultField.value
      }];
    });
  }, [euiFieldProps === null || euiFieldProps === void 0 ? void 0 : euiFieldProps.options, setSelected, resultField.value]);
  (0, _react.useEffect)(() => {
    trigger(`ecsMappingArray.${index}.key`);
  }, [resultField.value, trigger, index]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('xpack.osquery.pack.queryFlyoutForm.mappingValueFieldLabel', {
      defaultMessage: 'Value'
    }),
    helpText: (_selectedOptions$5 = selectedOptions[0]) === null || _selectedOptions$5 === void 0 ? void 0 : (_selectedOptions$5$va = _selectedOptions$5.value) === null || _selectedOptions$5$va === void 0 ? void 0 : _selectedOptions$5$va.description,
    error: (_resultFieldState$err = resultFieldState.error) === null || _resultFieldState$err === void 0 ? void 0 : _resultFieldState$err.message,
    isInvalid: !!((_resultFieldState$err2 = resultFieldState.error) !== null && _resultFieldState$err2 !== void 0 && (_resultFieldState$err3 = _resultFieldState$err2.message) !== null && _resultFieldState$err3 !== void 0 && _resultFieldState$err3.length),
    fullWidth: true,
    describedByIds: describedByIds,
    isDisabled: euiFieldProps.isDisabled,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 527,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "none",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 538,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    css: _utils.overflowCss,
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 539,
      columnNumber: 9
    }
  }, Prepend), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    css: _utils.overflowCss,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 542,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, (0, _extends2.default)({
    css: _ecs_field_css.resultComboBoxCss,
    error: (_resultFieldState$err4 = resultFieldState.error) === null || _resultFieldState$err4 === void 0 ? void 0 : _resultFieldState$err4.message
    // eslint-disable-next-line react/jsx-no-bind, react-perf/jsx-no-new-function-as-prop
    ,
    inputRef: ref => {
      inputRef.current = ref;
    },
    fullWidth: true,
    selectedOptions: selectedOptions,
    onChange: handleKeyChange,
    onCreateOption: handleCreateOption,
    renderOption: renderOsqueryOption,
    rowHeight: 32,
    isClearable: true,
    singleSelection: isSingleSelection ? SINGLE_SELECTION : false,
    idAria: idAria,
    helpText: (_selectedOptions$6 = selectedOptions[0]) === null || _selectedOptions$6 === void 0 ? void 0 : (_selectedOptions$6$va = _selectedOptions$6.value) === null || _selectedOptions$6$va === void 0 ? void 0 : _selectedOptions$6$va.description
  }, euiFieldProps, {
    "data-test-subj": "osqueryColumnValueSelect",
    options: resultTypeField.value === 'field' && euiFieldProps.options || EMPTY_ARRAY,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 545,
      columnNumber: 11
    }
  })))));
};
const OsqueryColumnField = exports.OsqueryColumnField = /*#__PURE__*/_react.default.memo(OsqueryColumnFieldComponent, _fastDeepEqual.default);
const defaultEcsFormData = exports.defaultEcsFormData = {
  key: '',
  result: {
    type: 'field',
    value: ''
  }
};
const ECSMappingEditorForm = ({
  isDisabled,
  osquerySchemaOptions,
  isLastItem,
  index,
  onDelete,
  control,
  watch,
  trigger
}) => {
  const handleDeleteClick = (0, _react.useCallback)(() => {
    if (onDelete) {
      onDelete(index);
    }
  }, [index, onDelete]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    "data-test-subj": "ECSMappingEditorForm",
    alignItems: "flexStart",
    gutterSize: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 615,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    css: _utils.overflowCss,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 616,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "flexStart",
    gutterSize: "s",
    wrap: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 617,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    css: _utils.overflowCss,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 618,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(ECSComboboxField, {
    control: control,
    watch: watch,
    index: index
    // eslint-disable-next-line react-perf/jsx-no-new-object-as-prop
    ,
    euiFieldProps: {
      isDisabled
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 619,
      columnNumber: 15
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    css: _ecs_field_css.semicolonWrapperCss,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 629,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 630,
      columnNumber: 15
    }
  }, ":")))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    css: _utils.overflowCss,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 634,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "flexStart",
    gutterSize: "s",
    wrap: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 635,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    css: _ecs_field_css.ECSFieldWrapperCss,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 636,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(OsqueryColumnField, {
    control: control,
    watch: watch,
    trigger: trigger,
    index: index,
    isLastItem: isLastItem
    // eslint-disable-next-line react-perf/jsx-no-new-object-as-prop
    ,
    euiFieldProps: {
      // @ts-expect-error update types
      options: osquerySchemaOptions,
      isDisabled
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 637,
      columnNumber: 15
    }
  })), !isDisabled && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 652,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement("div", {
    css: _ecs_field_css.buttonWrapperCss,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 653,
      columnNumber: 17
    }
  }, !isLastItem && /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    "aria-label": _i18n.i18n.translate('xpack.osquery.pack.queryFlyoutForm.deleteECSMappingRowButtonAriaLabel', {
      defaultMessage: 'Delete ECS mapping row'
    }),
    iconType: "trash",
    color: "danger",
    onClick: handleDeleteClick,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 655,
      columnNumber: 21
    }
  })))))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 673,
      columnNumber: 7
    }
  }));
};
exports.ECSMappingEditorForm = ECSMappingEditorForm;
// eslint-disable-next-line react/display-name
const ECSMappingEditorField = exports.ECSMappingEditorField = /*#__PURE__*/_react.default.memo(({
  euiFieldProps
}) => {
  const {
    setError,
    clearErrors,
    watch: watchRoot,
    register: registerRoot,
    setValue: setValueRoot
  } = (0, _reactHookForm.useFormContext)();
  const latestErrors = (0, _react.useRef)(undefined);
  const [query, ecsMapping] = watchRoot(['query', 'ecs_mapping']);
  const {
    control,
    trigger,
    watch,
    formState,
    resetField,
    getFieldState
  } = (0, _reactHookForm.useForm)({
    mode: 'all',
    shouldUnregister: true,
    defaultValues: {
      ecsMappingArray: !(0, _lodash.isEmpty)((0, _converters.convertECSMappingToArray)(ecsMapping)) ? [...(0, _converters.convertECSMappingToArray)(ecsMapping), defaultEcsFormData] : [defaultEcsFormData]
    }
  });
  const {
    fields,
    append,
    remove,
    replace
  } = (0, _reactHookForm.useFieldArray)({
    control,
    name: 'ecsMappingArray'
  });
  const formValue = watch();
  const ecsMappingArrayState = getFieldState('ecsMappingArray', formState);
  const [osquerySchemaOptions, setOsquerySchemaOptions] = (0, _react.useState)([]);
  (0, _react.useEffect)(() => {
    registerRoot('ecs_mapping');
  }, [registerRoot]);
  (0, _react.useEffect)(() => {
    if (!(0, _fastDeepEqual.default)(latestErrors.current, formState.errors.ecsMappingArray)) {
      var _formState$errors$ecs, _formState$errors$ecs2;
      // @ts-expect-error update types
      latestErrors.current = formState.errors.ecsMappingArray;
      if ((_formState$errors$ecs = formState.errors.ecsMappingArray) !== null && _formState$errors$ecs !== void 0 && _formState$errors$ecs.length && (_formState$errors$ecs2 = formState.errors.ecsMappingArray[0]) !== null && _formState$errors$ecs2 !== void 0 && _formState$errors$ecs2.key) {
        setError('ecs_mapping', formState.errors.ecsMappingArray[0].key);
      } else {
        clearErrors('ecs_mapping');
      }
    }
  }, [formState, setError, clearErrors]);
  (0, _react.useEffect)(() => {
    const subscription = watchRoot((data, payload) => {
      if (payload.name === 'ecs_mapping') {
        const parsedMapping = (0, _converters.convertECSMappingToObject)(formValue.ecsMappingArray);
        if (!(0, _fastDeepEqual.default)(data.ecs_mapping, parsedMapping)) {
          resetField('ecsMappingArray', {
            defaultValue: [...(0, _converters.convertECSMappingToArray)(data.ecs_mapping), defaultEcsFormData]
          });
          replace([...(0, _converters.convertECSMappingToArray)(data.ecs_mapping), defaultEcsFormData]);
        }
      }
    });
    return () => subscription.unsubscribe();
  }, [watchRoot, ecsMapping, replace, resetField, formValue.ecsMappingArray]);
  (0, _react.useEffect)(() => {
    const subscription = watch((data, payload) => {
      if (data !== null && data !== void 0 && data.ecsMappingArray) {
        var _data$ecsMappingArray, _payload$name;
        const lastEcsIndex = (data === null || data === void 0 ? void 0 : (_data$ecsMappingArray = data.ecsMappingArray) === null || _data$ecsMappingArray === void 0 ? void 0 : _data$ecsMappingArray.length) - 1;
        if ((_payload$name = payload.name) !== null && _payload$name !== void 0 && _payload$name.startsWith(`ecsMappingArray.${lastEcsIndex}.`)) {
          var _lastEcs$key, _lastEcs$result, _lastEcs$result$value;
          const lastEcs = (0, _lodash.last)(data.ecsMappingArray);
          if (lastEcs !== null && lastEcs !== void 0 && (_lastEcs$key = lastEcs.key) !== null && _lastEcs$key !== void 0 && _lastEcs$key.length && lastEcs !== null && lastEcs !== void 0 && (_lastEcs$result = lastEcs.result) !== null && _lastEcs$result !== void 0 && (_lastEcs$result$value = _lastEcs$result.value) !== null && _lastEcs$result$value !== void 0 && _lastEcs$result$value.length) {
            append(defaultEcsFormData);
          }
        }
      }
    });
    return () => subscription.unsubscribe();
  }, [formValue, append, watch]);
  (0, _react.useEffect)(() => {
    var _reduce, _ast, _ast2, _ast2$result;
    if (!(query !== null && query !== void 0 && query.length)) {
      return;
    }
    const oneLineQuery = (0, _remove_multilines.removeMultilines)(query);
    let ast;
    try {
      var _sqliteParser, _sqliteParser$stateme;
      ast = (_sqliteParser = (0, _sqlParser.default)(oneLineQuery)) === null || _sqliteParser === void 0 ? void 0 : (_sqliteParser$stateme = _sqliteParser.statement) === null || _sqliteParser$stateme === void 0 ? void 0 : _sqliteParser$stateme[0];
    } catch (e) {
      return;
    }
    const astOsqueryTables = (_reduce = (0, _lodash.reduce)(ast, (acc, data) => {
      // select * from uptime
      if ((data === null || data === void 0 ? void 0 : data.type) === 'identifier' && (data === null || data === void 0 ? void 0 : data.variant) === 'table') {
        const osqueryTable = (0, _lodash.find)(_v2.default, ['name', data.name]);
        if (osqueryTable) {
          acc[data.alias || data.name] = {
            columns: osqueryTable.columns,
            order: Object.keys(acc).length
          };
        }
      }

      // select * from uptime, routes
      if ((data === null || data === void 0 ? void 0 : data.type) === 'map' && (data === null || data === void 0 ? void 0 : data.variant) === 'join') {
        var _data$source, _data$source2, _data$source6, _data$source7;
        if ((data === null || data === void 0 ? void 0 : (_data$source = data.source) === null || _data$source === void 0 ? void 0 : _data$source.type) === 'identifier' && (data === null || data === void 0 ? void 0 : (_data$source2 = data.source) === null || _data$source2 === void 0 ? void 0 : _data$source2.variant) === 'table') {
          var _data$source3;
          const osqueryTable = (0, _lodash.find)(_v2.default, ['name', data === null || data === void 0 ? void 0 : (_data$source3 = data.source) === null || _data$source3 === void 0 ? void 0 : _data$source3.name]);
          if (osqueryTable) {
            var _data$source4, _data$source5;
            acc[(data === null || data === void 0 ? void 0 : (_data$source4 = data.source) === null || _data$source4 === void 0 ? void 0 : _data$source4.alias) || (data === null || data === void 0 ? void 0 : (_data$source5 = data.source) === null || _data$source5 === void 0 ? void 0 : _data$source5.name)] = {
              columns: osqueryTable.columns,
              order: Object.keys(acc).length
            };
          }
        }
        if ((data === null || data === void 0 ? void 0 : (_data$source6 = data.source) === null || _data$source6 === void 0 ? void 0 : _data$source6.type) === 'statement' && (data === null || data === void 0 ? void 0 : (_data$source7 = data.source) === null || _data$source7 === void 0 ? void 0 : _data$source7.variant) === 'compound') {
          var _data$source8, _data$source9;
          if ((data === null || data === void 0 ? void 0 : (_data$source8 = data.source) === null || _data$source8 === void 0 ? void 0 : _data$source8.statement.from.type) === 'identifier' && (data === null || data === void 0 ? void 0 : (_data$source9 = data.source) === null || _data$source9 === void 0 ? void 0 : _data$source9.statement.from.variant) === 'table') {
            var _data$source10;
            const osqueryTable = (0, _lodash.find)(_v2.default, ['name', data === null || data === void 0 ? void 0 : (_data$source10 = data.source) === null || _data$source10 === void 0 ? void 0 : _data$source10.statement.from.name]);
            if (osqueryTable) {
              var _data$source11, _data$source12;
              acc[(data === null || data === void 0 ? void 0 : (_data$source11 = data.source) === null || _data$source11 === void 0 ? void 0 : _data$source11.statement.from.alias) || (data === null || data === void 0 ? void 0 : (_data$source12 = data.source) === null || _data$source12 === void 0 ? void 0 : _data$source12.statement.from.name)] = {
                columns: osqueryTable.columns,
                order: Object.keys(acc).length
              };
            }
          }
        }
        (0, _lodash.each)(data === null || data === void 0 ? void 0 : data.map, mapValue => {
          if ((mapValue === null || mapValue === void 0 ? void 0 : mapValue.type) === 'join') {
            var _mapValue$source, _mapValue$source2;
            if ((mapValue === null || mapValue === void 0 ? void 0 : (_mapValue$source = mapValue.source) === null || _mapValue$source === void 0 ? void 0 : _mapValue$source.type) === 'identifier' && (mapValue === null || mapValue === void 0 ? void 0 : (_mapValue$source2 = mapValue.source) === null || _mapValue$source2 === void 0 ? void 0 : _mapValue$source2.variant) === 'table') {
              var _mapValue$source3;
              const osqueryTable = (0, _lodash.find)(_v2.default, ['name', mapValue === null || mapValue === void 0 ? void 0 : (_mapValue$source3 = mapValue.source) === null || _mapValue$source3 === void 0 ? void 0 : _mapValue$source3.name]);
              if (osqueryTable) {
                var _mapValue$source4, _mapValue$source5;
                acc[(mapValue === null || mapValue === void 0 ? void 0 : (_mapValue$source4 = mapValue.source) === null || _mapValue$source4 === void 0 ? void 0 : _mapValue$source4.alias) || (mapValue === null || mapValue === void 0 ? void 0 : (_mapValue$source5 = mapValue.source) === null || _mapValue$source5 === void 0 ? void 0 : _mapValue$source5.name)] = {
                  columns: osqueryTable.columns,
                  order: Object.keys(acc).length
                };
              }
            }
          }
        });
      }
      return acc;
    }, {})) !== null && _reduce !== void 0 ? _reduce : {};

    // Table doesn't exist in osquery schema
    if ((0, _lodash.isEmpty)(astOsqueryTables)) {
      return;
    }
    const suggestions = (0, _lodash.isArray)((_ast = ast) === null || _ast === void 0 ? void 0 : _ast.result) ? (_ast2 = ast) === null || _ast2 === void 0 ? void 0 : (_ast2$result = _ast2.result) === null || _ast2$result === void 0 ? void 0 : _ast2$result.map(selectItem => {
      if (selectItem.type === 'identifier') {
        var _ast3;
        /*
          select * from routes, uptime;
        */
        if (((_ast3 = ast) === null || _ast3 === void 0 ? void 0 : _ast3.result.length) === 1 && selectItem.name === '*') {
          return (0, _lodash.reduce)(astOsqueryTables, (acc, {
            columns: osqueryColumns,
            order: tableOrder
          }, table) => {
            acc.push(...osqueryColumns.map(osqueryColumn => ({
              label: osqueryColumn.name,
              value: {
                name: osqueryColumn.name,
                description: osqueryColumn.description,
                table,
                tableOrder,
                suggestion_label: osqueryColumn.name
              }
            })));
            return acc;
          }, []);
        }

        /*
          select i.*, p.resident_size, p.user_time, p.system_time, time.minutes as counter from osquery_info i, processes p, time where p.pid = i.pid;
        */

        const [table, column] = selectItem.name.includes('.') ? selectItem.name.split('.') : [Object.keys(astOsqueryTables)[0], selectItem.name];
        if (column === '*' && astOsqueryTables[table]) {
          const {
            columns: osqueryColumns,
            order: tableOrder
          } = astOsqueryTables[table];
          return osqueryColumns.map(osqueryColumn => ({
            label: osqueryColumn.name,
            value: {
              name: osqueryColumn.name,
              description: osqueryColumn.description,
              table,
              tableOrder,
              suggestion_label: `${osqueryColumn.name}`
            }
          }));
        }
        if (astOsqueryTables[table]) {
          const osqueryColumn = (0, _lodash.find)(astOsqueryTables[table].columns, ['name', column]);
          if (osqueryColumn) {
            var _selectItem$alias;
            const label = (_selectItem$alias = selectItem.alias) !== null && _selectItem$alias !== void 0 ? _selectItem$alias : column;
            return [{
              label,
              value: {
                name: osqueryColumn.name,
                description: osqueryColumn.description,
                table,
                tableOrder: astOsqueryTables[table].order,
                suggestion_label: `${label}`
              }
            }];
          }
        }
      }

      /*
        SELECT pid, uid, name, ROUND((
          (user_time + system_time) / (cpu_time.tsb - cpu_time.itsb)
        ) * 100, 2) AS percentage
        FROM processes, (
        SELECT (
          SUM(user) + SUM(nice) + SUM(system) + SUM(idle) * 1.0) AS tsb,
          SUM(COALESCE(idle, 0)) + SUM(COALESCE(iowait, 0)) AS itsb
          FROM cpu_time
        ) AS cpu_time
        ORDER BY user_time+system_time DESC
        LIMIT 5;
      */

      if (selectItem.type === 'function' && selectItem.alias) {
        return [{
          label: selectItem.alias,
          value: {
            name: selectItem.alias,
            description: '',
            table: '',
            tableOrder: -1,
            suggestion_label: selectItem.alias
          }
        }];
      }
      return [];
    }).flat() : [];

    // Remove column duplicates by keeping the column from the table that appears last in the query
    const newOptions = (0, _lodash.sortedUniqBy)((0, _lodash.orderBy)(suggestions, ['value.suggestion_label', 'value.tableOrder'], ['asc', 'desc']), 'label');
    setOsquerySchemaOptions(prevValue => {
      if (!(0, _fastDeepEqual.default)(prevValue, newOptions)) {
        trigger();
        return newOptions;
      }
      return prevValue;
    });
  }, [query, trigger]);
  (0, _react.useEffect)(() => {
    const parsedMapping = (0, _converters.convertECSMappingToObject)(formValue.ecsMappingArray);
    if (ecsMappingArrayState.isDirty && !(0, _fastDeepEqual.default)(parsedMapping, ecsMapping)) {
      setValueRoot('ecs_mapping', parsedMapping, {
        shouldTouch: true
      });
    }
  }, [setValueRoot, formValue, ecsMappingArrayState.isDirty, ecsMapping]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 1023,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 1024,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 1025,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement("h5", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 1026,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.osquery.pack.form.ecsMappingSection.title",
    defaultMessage: "ECS mapping",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 1027,
      columnNumber: 15
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 1033,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.osquery.pack.form.ecsMappingSection.description",
    defaultMessage: "Use the fields below to map results from this query to ECS fields.",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 1034,
      columnNumber: 13
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 1041,
      columnNumber: 7
    }
  }), fields.map((item, index, array) => /*#__PURE__*/_react.default.createElement("div", {
    key: item.id,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 1044,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(ECSMappingEditorForm, {
    osquerySchemaOptions: osquerySchemaOptions,
    index: index,
    isLastItem: index === array.length - 1,
    onDelete: remove,
    isDisabled: !!(euiFieldProps !== null && euiFieldProps !== void 0 && euiFieldProps.isDisabled),
    control: control,
    watch: watch,
    trigger: trigger,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 1045,
      columnNumber: 11
    }
  }))));
});

// eslint-disable-next-line import/no-default-export
var _default = exports.default = ECSMappingEditorField;