"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AddPackButton = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _kibana = require("../common/lib/kibana");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763899475283842490/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/osquery/public/packs/add_pack_button.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const AddPackButtonComponent = ({
  fill = true
}) => {
  const permissions = (0, _kibana.useKibana)().services.application.capabilities.osquery;
  const newQueryLinkProps = (0, _kibana.useRouterNavigate)('packs/add');
  return /*#__PURE__*/_react.default.createElement(_eui.EuiButton, (0, _extends2.default)({
    fill: !!fill
  }, newQueryLinkProps, {
    iconType: "plusInCircle",
    isDisabled: !permissions.writePacks,
    "data-test-subj": 'add-pack-button',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 23,
      columnNumber: 5
    }
  }), /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.osquery.packList.addPackButtonLabel",
    defaultMessage: "Add pack",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 30,
      columnNumber: 7
    }
  }));
};
const AddPackButton = exports.AddPackButton = /*#__PURE__*/_react.default.memo(AddPackButtonComponent);