"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LiveQueryForm = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _react = _interopRequireWildcard(require("react"));
var _reactHookForm = require("react-hook-form");
var _lodash = require("lodash");
var _constants = require("../../../common/constants");
var _replace_params_query = require("../../../common/utils/replace_params_query");
var _query_pack_selectable = require("./query_pack_selectable");
var _kibana = require("../../common/lib/kibana");
var _tabs = require("../../routes/saved_queries/edit/tabs");
var _saved_queries = require("../../saved_queries");
var _use_packs = require("../../packs/use_packs");
var _use_create_live_query_action = require("../use_create_live_query_action");
var _use_live_query_details = require("../../actions/use_live_query_details");
var _live_query_query_field = _interopRequireDefault(require("./live_query_query_field"));
var _agents_table_field = require("./agents_table_field");
var _use_saved_query_form = require("../../saved_queries/form/use_saved_query_form");
var _pack_field_wrapper = require("../../shared_components/osquery_response_action_type/pack_field_wrapper");
var _contexts = require("../../common/contexts");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763899475283842490/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/osquery/public/live_queries/form/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const LiveQueryFormComponent = ({
  defaultValue,
  onSuccess,
  queryField = true,
  formType = 'steps',
  enabled = true,
  hideAgentsField = false
}) => {
  const alertAttachmentContext = (0, _react.useContext)(_contexts.AlertAttachmentContext);
  const {
    application
  } = (0, _kibana.useKibana)().services;
  const permissions = application.capabilities.osquery;
  const canRunPacks = (0, _react.useMemo)(() => !!((permissions.runSavedQueries || permissions.writeLiveQueries) && permissions.readPacks), [permissions]);
  const hooksForm = (0, _reactHookForm.useForm)();
  const {
    handleSubmit,
    watch,
    setValue,
    resetField,
    clearErrors,
    getFieldState,
    register
  } = hooksForm;
  const canRunSingleQuery = (0, _react.useMemo)(() => !!(permissions.writeLiveQueries || permissions.runSavedQueries && permissions.readSavedQueries), [permissions]);
  const [showSavedQueryFlyout, setShowSavedQueryFlyout] = (0, _react.useState)(false);
  const [isLive, setIsLive] = (0, _react.useState)(false);
  const queryState = getFieldState('query');
  const watchedValues = watch();
  const handleShowSaveQueryFlyout = (0, _react.useCallback)(() => setShowSavedQueryFlyout(true), []);
  const handleCloseSaveQueryFlyout = (0, _react.useCallback)(() => setShowSavedQueryFlyout(false), []);
  const {
    queryType
  } = watchedValues;
  const {
    data,
    isLoading,
    mutateAsync,
    isError,
    isSuccess,
    reset: cleanupLiveQuery
  } = (0, _use_create_live_query_action.useCreateLiveQuery)({
    onSuccess
  });
  const {
    data: liveQueryDetails
  } = (0, _use_live_query_details.useLiveQueryDetails)({
    actionId: data === null || data === void 0 ? void 0 : data.action_id,
    isLive
  });
  (0, _react.useEffect)(() => {
    register('savedQueryId');
    register('alertIds');
  }, [register]);
  const queryStatus = (0, _react.useMemo)(() => {
    if (isError || queryState.error) return 'danger';
    if (isLoading) return 'loading';
    if (isSuccess) return 'complete';
    return 'incomplete';
  }, [isError, isLoading, isSuccess, queryState]);
  const resultsStatus = (0, _react.useMemo)(() => queryStatus === 'complete' ? 'incomplete' : 'disabled', [queryStatus]);
  const onSubmit = (0, _react.useCallback)(async values => {
    var _values$packId;
    // Temporary, frontend solution for params substitution. To be removed once alert_ids refactored in create_live_query_route
    const query = values.query && (0, _replace_params_query.containsDynamicQuery)(values.query) && alertAttachmentContext ? (0, _replace_params_query.replaceParamsQuery)(values.query, alertAttachmentContext).result : values.query;
    const serializedData = (0, _lodash.pickBy)({
      agentSelection: values.agentSelection,
      saved_query_id: values.savedQueryId,
      query,
      alert_ids: values.alertIds,
      pack_id: queryType === 'pack' && values !== null && values !== void 0 && (_values$packId = values.packId) !== null && _values$packId !== void 0 && _values$packId.length ? values === null || values === void 0 ? void 0 : values.packId[0] : undefined,
      ecs_mapping: values.ecs_mapping,
      ...(queryType === 'query' ? {
        timeout: values.timeout
      } : {})
    }, value => !(0, _lodash.isEmpty)(value) || (0, _lodash.isNumber)(value));
    await mutateAsync(serializedData);
  }, [alertAttachmentContext, mutateAsync, queryType]);
  const serializedData = (0, _react.useMemo)(() => (0, _use_saved_query_form.savedQueryDataSerializer)(watchedValues), [watchedValues]);
  const {
    data: packsData,
    isFetched: isPackDataFetched
  } = (0, _use_packs.usePacks)({});
  const submitButtonContent = (0, _react.useMemo)(() => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 174,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "flexEnd",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 175,
      columnNumber: 9
    }
  }, formType === 'steps' && queryType !== 'pack' && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 177,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    disabled: !permissions.writeSavedQueries || resultsStatus === 'disabled',
    onClick: handleShowSaveQueryFlyout,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 178,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.osquery.liveQueryForm.form.saveForLaterButtonLabel",
    defaultMessage: "Save for later",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 182,
      columnNumber: 17
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 189,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    id: "submit-button",
    disabled: !enabled,
    isLoading: isLoading,
    onClick: handleSubmit(onSubmit),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 190,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.osquery.liveQueryForm.form.submitButtonLabel",
    defaultMessage: "Submit",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 196,
      columnNumber: 15
    }
  }))))), [formType, queryType, permissions.writeSavedQueries, resultsStatus, handleShowSaveQueryFlyout, enabled, isLoading, handleSubmit, onSubmit]);
  const singleQueryDetails = (0, _react.useMemo)(() => {
    var _liveQueryDetails$que;
    return liveQueryDetails === null || liveQueryDetails === void 0 ? void 0 : (_liveQueryDetails$que = liveQueryDetails.queries) === null || _liveQueryDetails$que === void 0 ? void 0 : _liveQueryDetails$que[0];
  }, [liveQueryDetails]);
  const liveQueryActionId = (0, _react.useMemo)(() => liveQueryDetails === null || liveQueryDetails === void 0 ? void 0 : liveQueryDetails.action_id, [liveQueryDetails]);
  const resultsStepContent = (0, _react.useMemo)(() => singleQueryDetails !== null && singleQueryDetails !== void 0 && singleQueryDetails.action_id ? /*#__PURE__*/_react.default.createElement(_tabs.ResultTabs, {
    actionId: singleQueryDetails === null || singleQueryDetails === void 0 ? void 0 : singleQueryDetails.action_id,
    startDate: liveQueryDetails === null || liveQueryDetails === void 0 ? void 0 : liveQueryDetails['@timestamp'],
    ecsMapping: serializedData.ecs_mapping,
    endDate: singleQueryDetails === null || singleQueryDetails === void 0 ? void 0 : singleQueryDetails.expiration,
    agentIds: singleQueryDetails === null || singleQueryDetails === void 0 ? void 0 : singleQueryDetails.agents,
    liveQueryActionId: liveQueryActionId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 224,
      columnNumber: 9
    }
  }) : null, [singleQueryDetails === null || singleQueryDetails === void 0 ? void 0 : singleQueryDetails.action_id, singleQueryDetails === null || singleQueryDetails === void 0 ? void 0 : singleQueryDetails.expiration, singleQueryDetails === null || singleQueryDetails === void 0 ? void 0 : singleQueryDetails.agents, liveQueryDetails, serializedData.ecs_mapping, liveQueryActionId]);
  (0, _react.useEffect)(() => {
    if (defaultValue) {
      var _defaultValue$alertId;
      if (defaultValue.agentSelection) {
        setValue('agentSelection', defaultValue.agentSelection);
      }
      if ((_defaultValue$alertId = defaultValue.alertIds) !== null && _defaultValue$alertId !== void 0 && _defaultValue$alertId.length) {
        setValue('alertIds', defaultValue.alertIds);
      }
      if (defaultValue.packId && canRunPacks) {
        setValue('queryType', 'pack');
        if (!isPackDataFetched) return;
        const selectedPackOption = (0, _lodash.find)(packsData === null || packsData === void 0 ? void 0 : packsData.data, ['saved_object_id', defaultValue.packId]);
        if (selectedPackOption) {
          setValue('packId', [defaultValue.packId]);
        }
        return;
      }
      if (defaultValue.query && canRunSingleQuery) {
        var _defaultValue$ecs_map, _defaultValue$timeout;
        setValue('query', defaultValue.query);
        setValue('savedQueryId', defaultValue.savedQueryId);
        setValue('ecs_mapping', (_defaultValue$ecs_map = defaultValue.ecs_mapping) !== null && _defaultValue$ecs_map !== void 0 ? _defaultValue$ecs_map : {});
        setValue('timeout', (_defaultValue$timeout = defaultValue.timeout) !== null && _defaultValue$timeout !== void 0 ? _defaultValue$timeout : _constants.QUERY_TIMEOUT.DEFAULT);
        return;
      }
      if (canRunSingleQuery) {
        return setValue('queryType', 'query');
      }
      if (canRunPacks) {
        return setValue('queryType', 'pack');
      }
    }
  }, [canRunPacks, canRunSingleQuery, defaultValue, isPackDataFetched, packsData === null || packsData === void 0 ? void 0 : packsData.data, setValue]);
  (0, _react.useEffect)(() => {
    setIsLive(() => !((liveQueryDetails === null || liveQueryDetails === void 0 ? void 0 : liveQueryDetails.status) === 'completed'));
  }, [liveQueryDetails === null || liveQueryDetails === void 0 ? void 0 : liveQueryDetails.status]);
  (0, _react.useEffect)(() => {
    cleanupLiveQuery();
    if (!defaultValue) {
      resetField('packId');
      resetField('query');
      resetField('ecs_mapping');
      resetField('savedQueryId');
      resetField('alertIds');
      clearErrors();
    }
  }, [queryType, cleanupLiveQuery, resetField, setValue, clearErrors, defaultValue]);
  const groupStyles = (0, _react.useMemo)(() => ({
    gap: 16
  }), []);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_reactHookForm.FormProvider, (0, _extends2.default)({}, hooksForm, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 304,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    css: groupStyles,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 305,
      columnNumber: 9
    }
  }, queryField && /*#__PURE__*/_react.default.createElement(_query_pack_selectable.QueryPackSelectable, {
    canRunPacks: canRunPacks,
    canRunSingleQuery: canRunSingleQuery,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 307,
      columnNumber: 13
    }
  }), !hideAgentsField && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 310,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_agents_table_field.AgentsTableField, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 311,
      columnNumber: 15
    }
  })), queryType === 'pack' ? /*#__PURE__*/_react.default.createElement(_pack_field_wrapper.PackFieldWrapper, {
    liveQueryDetails: liveQueryDetails,
    submitButtonContent: submitButtonContent,
    showResultsHeader: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 315,
      columnNumber: 13
    }
  }) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 322,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_live_query_query_field.default, {
    handleSubmitForm: handleSubmit(onSubmit),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 323,
      columnNumber: 17
    }
  })), submitButtonContent, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 326,
      columnNumber: 15
    }
  }, resultsStepContent)))), showSavedQueryFlyout ? /*#__PURE__*/_react.default.createElement(_saved_queries.SavedQueryFlyout, {
    onClose: handleCloseSaveQueryFlyout,
    defaultValue: serializedData,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 333,
      columnNumber: 9
    }
  }) : null);
};
const LiveQueryForm = exports.LiveQueryForm = /*#__PURE__*/_react.default.memo(LiveQueryFormComponent);