"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AgentsTable = void 0;
var _fp = require("lodash/fp");
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _fastDeepEqual = _interopRequireDefault(require("fast-deep-equal"));
var _useDebounce = _interopRequireDefault(require("react-use/lib/useDebounce"));
var _i18nReact = require("@kbn/i18n-react");
var _kibana = require("../common/lib/kibana");
var _use_all_agents = require("./use_all_agents");
var _agent_grouper = require("./agent_grouper");
var _helpers = require("./helpers");
var _translations = require("./translations");
var _types = require("./types");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763899475283842490/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/osquery/public/agents/agents_table.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const perPage = 10;
const DEBOUNCE_DELAY = 300; // ms

const AgentsTableComponent = ({
  agentSelection,
  onChange,
  error
}) => {
  var _agentList$groups2;
  const {
    docLinks
  } = (0, _kibana.useKibana)().services;
  // search related
  const [searchValue, setSearchValue] = (0, _react.useState)('');
  const [modifyingSearch, setModifyingSearch] = (0, _react.useState)(false);
  const [debouncedSearchValue, setDebouncedSearchValue] = (0, _react.useState)('');
  (0, _useDebounce.default)(() => {
    // update the real search value, set the typing flag
    setDebouncedSearchValue(searchValue);
    setModifyingSearch(false);
  }, DEBOUNCE_DELAY, [searchValue]);
  const {
    isLoading: agentsLoading,
    isRefetching: agentsRefetching,
    data: agentList,
    isFetched: agentsFetched
  } = (0, _use_all_agents.useAllAgents)(debouncedSearchValue, {
    perPage,
    agentIds: agentSelection === null || agentSelection === void 0 ? void 0 : agentSelection.agents
  });

  // option related
  const [options, setOptions] = (0, _react.useState)([]);
  const [selectedOptions, setSelectedOptions] = (0, _react.useState)([]);
  const defaultValueInitialized = (0, _react.useRef)(false);
  const numAgentsSelected = (0, _react.useMemo)(() => {
    const {
      newAgentSelection,
      selectedAgents,
      selectedGroups
    } = (0, _helpers.generateAgentSelection)(selectedOptions);
    if (newAgentSelection.allAgentsSelected) {
      var _agentList$total;
      return (_agentList$total = agentList === null || agentList === void 0 ? void 0 : agentList.total) !== null && _agentList$total !== void 0 ? _agentList$total : 0;
    } else {
      var _agentList$groups$ove, _agentList$groups;
      const checkAgent = (0, _helpers.generateAgentCheck)(selectedGroups);
      return (
        // filter out all the agents counted by selected policies and platforms
        selectedAgents.filter(checkAgent).length +
        // add the number of agents added via policy and platform groups
        (0, _helpers.getNumAgentsInGrouping)(selectedGroups) -
        // subtract the number of agents double counted by policy/platform selections
        (0, _helpers.getNumOverlapped)(selectedGroups, (_agentList$groups$ove = agentList === null || agentList === void 0 ? void 0 : (_agentList$groups = agentList.groups) === null || _agentList$groups === void 0 ? void 0 : _agentList$groups.overlap) !== null && _agentList$groups$ove !== void 0 ? _agentList$groups$ove : {})
      );
    }
  }, [agentList === null || agentList === void 0 ? void 0 : (_agentList$groups2 = agentList.groups) === null || _agentList$groups2 === void 0 ? void 0 : _agentList$groups2.overlap, agentList === null || agentList === void 0 ? void 0 : agentList.total, selectedOptions]);
  const onSelection = (0, _react.useCallback)(selection => {
    const {
      newAgentSelection
    } = (0, _helpers.generateAgentSelection)(selection);
    onChange(newAgentSelection);
    setSelectedOptions(selection);
  }, [onChange]);
  (0, _react.useEffect)(() => {
    const handleSelectedOptions = (selection, label) => {
      const agentOptions = (0, _fp.find)(['label', label], options);
      if (agentOptions) {
        var _agentOptions$options;
        const defaultOptions = (_agentOptions$options = agentOptions.options) === null || _agentOptions$options === void 0 ? void 0 : _agentOptions$options.filter(option => {
          if (option.key) {
            return selection.includes(option.key);
          }
        });
        if (defaultOptions !== null && defaultOptions !== void 0 && defaultOptions.length) {
          onSelection(defaultOptions);
          defaultValueInitialized.current = true;
        }
      }
    };
    if (agentSelection && !(0, _fp.isEmpty)(agentSelection) && !defaultValueInitialized.current && options.length && !agentsRefetching) {
      var _agentSelection$polic, _agentSelection$agent;
      if (agentSelection.allAgentsSelected) {
        const allAgentsOptions = (0, _fp.find)(['label', _translations.ALL_AGENTS_LABEL], options);
        if (allAgentsOptions !== null && allAgentsOptions !== void 0 && allAgentsOptions.options) {
          onSelection(allAgentsOptions.options);
          defaultValueInitialized.current = true;
        }
      }
      if ((_agentSelection$polic = agentSelection.policiesSelected) !== null && _agentSelection$polic !== void 0 && _agentSelection$polic.length) {
        handleSelectedOptions(agentSelection.policiesSelected, _translations.AGENT_POLICY_LABEL);
      }
      if ((_agentSelection$agent = agentSelection.agents) !== null && _agentSelection$agent !== void 0 && _agentSelection$agent.length) {
        handleSelectedOptions(agentSelection.agents, _translations.AGENT_SELECTION_LABEL);
      }
    }
  }, [agentSelection, agentsFetched, agentsRefetching, onSelection, options, selectedOptions]);
  (0, _react.useEffect)(() => {
    if (agentsFetched && agentList !== null && agentList !== void 0 && agentList.groups) {
      var _agentList$groups3, _agentList$groups$pla, _agentList$groups4;
      // Cap policies to 10 on init dropdown
      const policies = (((_agentList$groups3 = agentList.groups) === null || _agentList$groups3 === void 0 ? void 0 : _agentList$groups3.policies) || []).slice(0, searchValue === '' ? 10 : undefined);
      const grouper = new _agent_grouper.AgentGrouper();
      // update the groups when groups or agents have changed
      grouper.setTotalAgents(agentList.total);
      grouper.updateGroup(_types.AGENT_GROUP_KEY.Platform, (_agentList$groups$pla = agentList === null || agentList === void 0 ? void 0 : (_agentList$groups4 = agentList.groups) === null || _agentList$groups4 === void 0 ? void 0 : _agentList$groups4.platforms) !== null && _agentList$groups$pla !== void 0 ? _agentList$groups$pla : []);
      grouper.updateGroup(_types.AGENT_GROUP_KEY.Policy, policies);
      grouper.updateGroup(_types.AGENT_GROUP_KEY.Agent, agentList === null || agentList === void 0 ? void 0 : agentList.agents);
      const newOptions = grouper.generateOptions();
      setOptions(prevOptions => !(0, _fastDeepEqual.default)(prevOptions, newOptions) ? newOptions : prevOptions);
    }
  }, [agentList === null || agentList === void 0 ? void 0 : agentList.agents, agentList === null || agentList === void 0 ? void 0 : agentList.groups, agentList === null || agentList === void 0 ? void 0 : agentList.total, agentsFetched, searchValue]);
  const renderOption = (0, _react.useCallback)((option, searchVal, contentClassName) => {
    var _value$size;
    const {
      label,
      value
    } = option;
    return (value === null || value === void 0 ? void 0 : value.groupType) === _types.AGENT_GROUP_KEY.Agent ? /*#__PURE__*/_react.default.createElement(_eui.EuiHealth, {
      color: (value === null || value === void 0 ? void 0 : value.status) === 'online' ? 'success' : 'danger',
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 180,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement("span", {
      className: contentClassName,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 181,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiHighlight, {
      search: searchVal,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 182,
        columnNumber: 11
      }
    }, label))) : /*#__PURE__*/_react.default.createElement("span", {
      className: contentClassName,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 186,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement("span", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 187,
        columnNumber: 9
      }
    }, "[", (_value$size = value === null || value === void 0 ? void 0 : value.size) !== null && _value$size !== void 0 ? _value$size : 0, "]"), "\xA0", /*#__PURE__*/_react.default.createElement(_eui.EuiHighlight, {
      search: searchVal,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 189,
        columnNumber: 9
      }
    }, label));
  }, []);
  const onSearchChange = (0, _react.useCallback)(v => {
    // set the typing flag and update the search value
    setModifyingSearch(v !== '');
    setSearchValue(v);
  }, []);
  const renderNoAgentAvailableWarning = () => {
    if (agentsFetched && agentList !== null && agentList !== void 0 && agentList.groups && !options.length) {
      return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
        color: "danger",
        size: "s",
        iconType: "warning",
        title: _translations.NO_AGENT_AVAILABLE_TITLE,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 204,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.osquery.agents.noAgentAvailableDescription",
        defaultMessage: "Before you can query agents, they must be enrolled in an agent policy with the Osquery integration installed. Refer to {docsLink} for more information."
        // eslint-disable-next-line react-perf/jsx-no-new-object-as-prop
        ,
        values: {
          docsLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
            href: `${docLinks.links.fleet.agentPolicy}#apply-a-policy`,
            target: '_blank',
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 211,
              columnNumber: 19
            }
          }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
            id: "xpack.osquery.agents.noAgentAvailableDescription.docsLink",
            defaultMessage: "Apply a policy",
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 215,
              columnNumber: 21
            }
          }))
        },
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 205,
          columnNumber: 13
        }
      })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
        size: "s",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 224,
          columnNumber: 11
        }
      }));
    }
    return null;
  };
  return /*#__PURE__*/_react.default.createElement("div", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 233,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _translations.AGENT_SELECTION_LABEL,
    fullWidth: true,
    isInvalid: !!error,
    error: error,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 234,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, renderNoAgentAvailableWarning(), /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
    "data-test-subj": "agentSelection",
    placeholder: _translations.SELECT_AGENT_LABEL,
    isLoading: agentsLoading || modifyingSearch,
    options: options,
    isClearable: true,
    fullWidth: true,
    onSearchChange: onSearchChange,
    selectedOptions: selectedOptions,
    onChange: onSelection,
    renderOption: renderOption,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 237,
      columnNumber: 11
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 251,
      columnNumber: 7
    }
  }), numAgentsSelected > 0 ? /*#__PURE__*/_react.default.createElement("span", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 252,
      columnNumber: 32
    }
  }, (0, _translations.generateSelectedAgentsMessage)(numAgentsSelected)) : '');
};
AgentsTableComponent.displayName = 'AgentsTable';
const AgentsTable = exports.AgentsTable = /*#__PURE__*/_react.default.memo(AgentsTableComponent, _fastDeepEqual.default);