"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ToolIdWithDescription = void 0;
var _eui = require("@elastic/eui");
var _react = require("@emotion/react");
var _react2 = _interopRequireDefault(require("react"));
var _truncate_at_newline = require("../../../utils/truncate_at_newline");
var _tools_provider = require("../../../context/tools_provider");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763899475283842490/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/onechat/public/application/components/tools/table/tools_table_id.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const ToolIdWithDescription = ({
  tool
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const {
    getEditToolUrl,
    getViewToolUrl
  } = (0, _tools_provider.useToolsActions)();
  const toolIdStyle = (0, _react.css)`
    font-weight: ${euiTheme.font.weight.semiBold};
  `;
  return /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 28,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiLink, {
    href: !tool.readonly ? getEditToolUrl(tool.id) : getViewToolUrl(tool.id),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 29,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiText, {
    size: "s",
    css: toolIdStyle,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 30,
      columnNumber: 9
    }
  }, tool.id)), /*#__PURE__*/_react2.default.createElement(_eui.EuiText, {
    size: "s",
    color: "subdued",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 34,
      columnNumber: 7
    }
  }, (0, _truncate_at_newline.truncateAtNewline)(tool.description)));
};
exports.ToolIdWithDescription = ToolIdWithDescription;