"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MetricsSection = MetricsSection;
var _eui = require("@elastic/eui");
var _numeral = _interopRequireDefault(require("@elastic/numeral"));
var _i18n = require("@kbn/i18n");
var _react = _interopRequireWildcard(require("react"));
var _public = require("@kbn/observability-shared-plugin/public");
var _section_container = require("../section_container");
var _data_handler = require("../../../../../context/has_data_context/data_handler");
var _use_has_data = require("../../../../../hooks/use_has_data");
var _use_date_picker_context = require("../../../../../hooks/use_date_picker_context");
var _host_link = require("./host_link");
var _format_duration = require("./lib/format_duration");
var _metric_with_sparkline = require("./metric_with_sparkline");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763899475283842490/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/observability/public/pages/overview/components/sections/metrics/metrics_section.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const percentFormatter = value => value === null ? '' : (0, _numeral.default)(value).format('0[.0]%');
const numberFormatter = value => value === null ? '' : (0, _numeral.default)(value).format('0[.0]');
const bytesPerSecondFormatter = value => value === null ? '' : (0, _numeral.default)(value).format('0b') + '/s';
function MetricsSection({
  bucketSize
}) {
  var _hasDataMap$infra_met, _viewData$series;
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const {
    forceUpdate,
    hasDataMap
  } = (0, _use_has_data.useHasData)();
  const {
    relativeStart,
    relativeEnd,
    absoluteStart,
    absoluteEnd,
    lastUpdated
  } = (0, _use_date_picker_context.useDatePickerContext)();
  const [sortDirection, setSortDirection] = (0, _react.useState)('asc');
  const [sortField, setSortField] = (0, _react.useState)('uptime');
  const [sortedData, setSortedData] = (0, _react.useState)(null);
  const {
    data,
    status
  } = (0, _public.useFetcher)(() => {
    if (bucketSize && absoluteStart && absoluteEnd) {
      var _getDataHandler;
      return (_getDataHandler = (0, _data_handler.getDataHandler)('infra_metrics')) === null || _getDataHandler === void 0 ? void 0 : _getDataHandler.fetchData({
        absoluteTime: {
          start: absoluteStart,
          end: absoluteEnd
        },
        relativeTime: {
          start: relativeStart,
          end: relativeEnd
        },
        ...bucketSize
      });
    }
    // `forceUpdate` and `lastUpdated` should trigger a reload
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [bucketSize, relativeStart, relativeEnd, absoluteStart, absoluteEnd, forceUpdate, lastUpdated]);
  const handleTableChange = (0, _react.useCallback)(({
    sort
  }) => {
    if (sort) {
      const {
        field,
        direction
      } = sort;
      setSortField(field);
      setSortDirection(direction);
      if (data) {
        (async () => {
          const response = await data.sort(field, direction);
          setSortedData(response || null);
        })();
      }
    }
  }, [data, setSortField, setSortDirection]);
  if (!((_hasDataMap$infra_met = hasDataMap.infra_metrics) !== null && _hasDataMap$infra_met !== void 0 && _hasDataMap$infra_met.hasData)) {
    return null;
  }
  const isLoading = status === _public.FETCH_STATUS.LOADING;
  const isInitialLoad = isLoading && !data;
  const columns = [{
    field: 'uptime',
    name: _i18n.i18n.translate('xpack.observability.overview.metrics.colunms.uptime', {
      defaultMessage: 'Uptime'
    }),
    sortable: true,
    width: '80px',
    render: value => value == null ? 'N/A' : (0, _format_duration.formatDuration)(value / 1000)
  }, {
    field: 'name',
    name: _i18n.i18n.translate('xpack.observability.overview.metrics.colunms.hostname', {
      defaultMessage: 'Hostname'
    }),
    sortable: true,
    truncateText: true,
    isExpander: true,
    textOnly: true,
    render: (value, record) => /*#__PURE__*/_react.default.createElement(_host_link.HostLink, {
      id: record.id,
      name: value,
      timerange: {
        from: absoluteStart,
        to: absoluteEnd
      },
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 115,
        columnNumber: 9
      }
    })
  }, {
    field: 'cpu',
    name: _i18n.i18n.translate('xpack.observability.overview.metrics.colunms.cpu', {
      defaultMessage: 'CPU %'
    }),
    sortable: true,
    render: (value, record) => /*#__PURE__*/_react.default.createElement(_metric_with_sparkline.MetricWithSparkline, {
      id: "cpu",
      value: value,
      formatter: percentFormatter,
      timeseries: record.timeseries,
      color: euiTheme.colors.vis.euiColorVis0,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 129,
        columnNumber: 9
      }
    })
  }, {
    field: 'load',
    name: _i18n.i18n.translate('xpack.observability.overview.metrics.colunms.load15', {
      defaultMessage: 'Load 15'
    }),
    sortable: true,
    render: (value, record) => /*#__PURE__*/_react.default.createElement(_metric_with_sparkline.MetricWithSparkline, {
      id: "load",
      value: value,
      formatter: numberFormatter,
      timeseries: record.timeseries,
      color: euiTheme.colors.vis.euiColorVis1,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 145,
        columnNumber: 9
      }
    })
  }, {
    field: 'rx',
    name: 'RX',
    sortable: true,
    render: (value, record) => /*#__PURE__*/_react.default.createElement(_metric_with_sparkline.MetricWithSparkline, {
      id: "rx",
      value: value,
      formatter: bytesPerSecondFormatter,
      timeseries: record.timeseries,
      color: euiTheme.colors.vis.euiColorVis2,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 159,
        columnNumber: 9
      }
    })
  }, {
    field: 'tx',
    name: 'TX',
    sortable: true,
    render: (value, record) => /*#__PURE__*/_react.default.createElement(_metric_with_sparkline.MetricWithSparkline, {
      id: "tx",
      value: value,
      formatter: bytesPerSecondFormatter,
      timeseries: record.timeseries,
      color: euiTheme.colors.vis.euiColorVis3,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 173,
        columnNumber: 9
      }
    })
  }];
  const sorting = {
    sort: {
      field: sortField,
      direction: sortDirection
    }
  };
  const viewData = sortedData || data;
  const {
    appLink
  } = data || {};
  return /*#__PURE__*/_react.default.createElement(_section_container.SectionContainer, {
    title: _i18n.i18n.translate('xpack.observability.overview.metrics.title', {
      defaultMessage: 'Hosts'
    }),
    appLink: {
      href: appLink,
      label: _i18n.i18n.translate('xpack.observability.overview.metrics.appLink', {
        defaultMessage: 'Show inventory'
      })
    },
    hasError: status === _public.FETCH_STATUS.FAILURE,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 193,
      columnNumber: 5
    }
  }, isInitialLoad ? /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": "loading",
    style: {
      height: 240,
      display: 'flex',
      alignItems: 'center',
      justifyContent: 'center'
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 206,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingChart, {
    size: "l",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 215,
      columnNumber: 11
    }
  })) : /*#__PURE__*/_react.default.createElement(_eui.EuiBasicTable, {
    onChange: handleTableChange,
    sorting: sorting,
    items: (_viewData$series = viewData === null || viewData === void 0 ? void 0 : viewData.series) !== null && _viewData$series !== void 0 ? _viewData$series : [],
    columns: columns,
    loading: isLoading,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 218,
      columnNumber: 9
    }
  }));
}