"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ANNOTATIONS_PAGE_ID = void 0;
exports.AnnotationsPage = AnnotationsPage;
var _react = _interopRequireDefault(require("react"));
var _public = require("@kbn/observability-shared-plugin/public");
var _i18n = require("@kbn/i18n");
var _annotations_privileges = require("./annotations_privileges");
var _create_annotation_btn = require("./create_annotation_btn");
var _annotations_list = require("./annotations_list");
var _kibana_react = require("../../utils/kibana_react");
var _use_plugin_context = require("../../hooks/use_plugin_context");
var _paths = require("../../../common/locators/paths");
var _header_menu = require("../overview/components/header_menu/header_menu");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763899475283842490/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/observability/public/pages/annotations/annotations.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const ANNOTATIONS_PAGE_ID = exports.ANNOTATIONS_PAGE_ID = 'annotations-container';
function AnnotationsPage() {
  const {
    http: {
      basePath
    },
    serverless
  } = (0, _kibana_react.useKibana)().services;
  const {
    ObservabilityPageTemplate
  } = (0, _use_plugin_context.usePluginContext)();
  const checkPrivileges = (0, _annotations_privileges.useAnnotationsPrivileges)();
  (0, _public.useBreadcrumbs)([{
    href: basePath.prepend(_paths.paths.observability.annotations),
    text: _i18n.i18n.translate('xpack.observability.breadcrumbs.annotationsLinkText', {
      defaultMessage: 'Annotations'
    }),
    deepLinkId: 'observability-overview'
  }], {
    serverless
  });
  return /*#__PURE__*/_react.default.createElement(ObservabilityPageTemplate, {
    "data-test-subj": "annotationsPage",
    pageHeader: {
      pageTitle: _i18n.i18n.translate('xpack.observability.annotations.heading', {
        defaultMessage: 'Annotations'
      }),
      rightSideItems: [/*#__PURE__*/_react.default.createElement(_create_annotation_btn.CreateAnnotationBtn, {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 51,
          columnNumber: 26
        }
      })]
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 45,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_header_menu.HeaderMenu, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 54,
      columnNumber: 7
    }
  }), checkPrivileges ? checkPrivileges : /*#__PURE__*/_react.default.createElement(_annotations_list.AnnotationsList, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 55,
      columnNumber: 44
    }
  }));
}