"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.aggregationType = exports.ExpressionRow = void 0;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireWildcard(require("react"));
var _public = require("@kbn/triggers-actions-ui-plugin/public");
var _lodash = require("lodash");
var _alertingComparators = require("@kbn/alerting-comparators");
var _convert_legacy_outside_comparator = require("../../../../common/utils/convert_legacy_outside_comparator");
var _types = require("../../../../common/custom_threshold_rule/types");
var _custom_equation = require("./custom_equation");
var _i18n_strings = require("../i18n_strings");
var _corrected_percent_convert = require("../helpers/corrected_percent_convert");
var _threshold_unit = require("../helpers/threshold_unit");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763899475283842490/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/observability/public/components/custom_threshold/components/expression_row.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
// eslint-disable-next-line react/function-component-definition
const ExpressionRow = props => {
  var _ref;
  const {
    dataView,
    children,
    setRuleParams,
    expression,
    errors,
    expressionId,
    remove,
    fields,
    canDelete,
    title
  } = props;
  const {
    metrics,
    comparator = _alertingComparators.COMPARATORS.GREATER_THAN,
    threshold = []
  } = expression;
  const isMetricPct = (0, _react.useMemo)(() => (0, _threshold_unit.isPercent)(metrics), [metrics]);
  const [label, setLabel] = (0, _react.useState)((expression === null || expression === void 0 ? void 0 : expression.label) || undefined);
  const updateComparator = (0, _react.useCallback)(c => {
    setRuleParams(expressionId, {
      ...expression,
      comparator: c
    });
  }, [expressionId, expression, setRuleParams]);
  const convertThreshold = (0, _react.useCallback)(enteredThreshold => isMetricPct ? enteredThreshold.map(v => (0, _corrected_percent_convert.pctToDecimal)(v)) : enteredThreshold, [isMetricPct]);
  const updateThreshold = (0, _react.useCallback)(enteredThreshold => {
    const t = convertThreshold(enteredThreshold);
    if (t.join() !== expression.threshold.join()) {
      setRuleParams(expressionId, {
        ...expression,
        threshold: t
      });
    }
  }, [expressionId, expression, convertThreshold, setRuleParams]);
  const handleCustomMetricChange = (0, _react.useCallback)(exp => {
    setRuleParams(expressionId, exp);
  }, [expressionId, setRuleParams]);
  const debouncedLabelChange = (0, _react.useMemo)(() => (0, _lodash.debounce)(handleCustomMetricChange, 300), [handleCustomMetricChange]);
  const criticalThresholdExpression = /*#__PURE__*/_react.default.createElement(ThresholdElement, {
    comparator: comparator,
    threshold: threshold,
    updateComparator: updateComparator,
    updateThreshold: updateThreshold,
    errors: (_ref = errors.critical) !== null && _ref !== void 0 ? _ref : {},
    isMetricPct: isMetricPct,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 101,
      columnNumber: 5
    }
  });
  const normalizedFields = fields.map(f => ({
    normalizedType: f.type,
    esTypes: f.esTypes,
    name: f.name
  }));
  const handleLabelChange = (0, _react.useCallback)(e => {
    setLabel(e.target.value);
    debouncedLabelChange({
      ...expression,
      label: e.target.value
    });
  }, [debouncedLabelChange, expression]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "xs",
    alignItems: "center",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 126,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 127,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 128,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement("h5", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 129,
      columnNumber: 13
    }
  }, title))), canDelete && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 133,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    "data-test-subj": "o11yExpressionRowButton",
    "aria-label": _i18n.i18n.translate('xpack.observability.customThreshold.rule.alertFlyout.removeCondition', {
      defaultMessage: 'Remove condition'
    }),
    color: 'text',
    iconType: 'trash',
    onClick: () => remove(expressionId),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 134,
      columnNumber: 13
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 149,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 150,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: 'xs',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 152,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement(_custom_equation.CustomEquationEditor, {
    expression: expression,
    fields: normalizedFields,
    aggregationTypes: aggregationType,
    onChange: handleCustomMetricChange,
    errors: errors,
    dataView: dataView,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 153,
      columnNumber: 13
    }
  }), criticalThresholdExpression, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: 's',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 162,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 163,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 164,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n_strings.LABEL_LABEL,
    fullWidth: true,
    helpText: _i18n_strings.LABEL_HELP_MESSAGE,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 165,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    "data-test-subj": "thresholdRuleCustomEquationEditorFieldTextLabel",
    compressed: true,
    fullWidth: true,
    value: label,
    placeholder: _i18n_strings.CUSTOM_EQUATION,
    onChange: handleLabelChange,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 166,
      columnNumber: 19
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 177,
      columnNumber: 13
    }
  })))), children);
};
exports.ExpressionRow = ExpressionRow;
const ThresholdElement = ({
  updateComparator,
  updateThreshold,
  threshold,
  isMetricPct,
  comparator,
  errors
}) => {
  const displayedThreshold = (0, _react.useMemo)(() => {
    if (isMetricPct) return threshold.map(v => (0, _corrected_percent_convert.decimalToPct)(v));
    return threshold;
  }, [threshold, isMetricPct]);
  const thresholdComparator = (0, _react.useCallback)(() => {
    if (!comparator) return _alertingComparators.COMPARATORS.GREATER_THAN;
    // Check if the rule had a legacy OUTSIDE_RANGE inside its params.
    // Then, change it on-the-fly to NOT_BETWEEN
    return (0, _convert_legacy_outside_comparator.convertToBuiltInComparators)(comparator);
  }, [comparator]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_public.ThresholdExpression, {
    thresholdComparator: thresholdComparator(),
    threshold: displayedThreshold,
    onChangeSelectedThresholdComparator: updateComparator,
    onChangeSelectedThreshold: updateThreshold,
    errors: errors,
    display: "fullWidth",
    unit: isMetricPct ? '%' : '',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 208,
      columnNumber: 7
    }
  }));
};
const aggregationType = exports.aggregationType = {
  avg: {
    text: _i18n.i18n.translate('xpack.observability.customThreshold.rule.alertFlyout.aggregationText.avg', {
      defaultMessage: 'Average'
    }),
    fieldRequired: true,
    validNormalizedTypes: ['number', 'histogram'],
    value: _types.Aggregators.AVERAGE
  },
  max: {
    text: _i18n.i18n.translate('xpack.observability.customThreshold.rule.alertFlyout.aggregationText.max', {
      defaultMessage: 'Max'
    }),
    fieldRequired: true,
    validNormalizedTypes: ['number', 'date', 'histogram'],
    value: _types.Aggregators.MAX
  },
  min: {
    text: _i18n.i18n.translate('xpack.observability.customThreshold.rule.alertFlyout.aggregationText.min', {
      defaultMessage: 'Min'
    }),
    fieldRequired: true,
    validNormalizedTypes: ['number', 'date', 'histogram'],
    value: _types.Aggregators.MIN
  },
  cardinality: {
    text: _i18n.i18n.translate('xpack.observability.customThreshold.rule.alertFlyout.aggregationText.cardinality', {
      defaultMessage: 'Cardinality'
    }),
    fieldRequired: false,
    value: _types.Aggregators.CARDINALITY,
    validNormalizedTypes: ['number', 'string', 'ip', 'date']
  },
  count: {
    text: _i18n.i18n.translate('xpack.observability.customThreshold.rule.alertFlyout.aggregationText.count', {
      defaultMessage: 'Count'
    }),
    fieldRequired: false,
    value: _types.Aggregators.COUNT,
    validNormalizedTypes: ['number']
  },
  sum: {
    text: _i18n.i18n.translate('xpack.observability.customThreshold.rule.alertFlyout.aggregationText.sum', {
      defaultMessage: 'Sum'
    }),
    fieldRequired: false,
    value: _types.Aggregators.SUM,
    validNormalizedTypes: ['number', 'histogram']
  },
  p95: {
    text: _i18n.i18n.translate('xpack.observability.customThreshold.rule.alertFlyout.aggregationText.p95', {
      defaultMessage: '95th Percentile'
    }),
    fieldRequired: false,
    value: _types.Aggregators.P95,
    validNormalizedTypes: ['number', 'histogram']
  },
  p99: {
    text: _i18n.i18n.translate('xpack.observability.customThreshold.rule.alertFlyout.aggregationText.p99', {
      defaultMessage: '99th Percentile'
    }),
    fieldRequired: false,
    value: _types.Aggregators.P99,
    validNormalizedTypes: ['number', 'histogram']
  },
  rate: {
    text: _i18n.i18n.translate('xpack.observability..customThreshold.rule.alertFlyout.aggregationText.rate', {
      defaultMessage: 'Rate'
    }),
    fieldRequired: false,
    value: _types.Aggregators.RATE,
    validNormalizedTypes: ['number']
  },
  last_value: {
    text: _i18n.i18n.translate('xpack.observability..customThreshold.rule.alertFlyout.aggregationText.last_value', {
      defaultMessage: 'Last value'
    }),
    fieldRequired: false,
    value: _types.Aggregators.LAST_VALUE,
    validNormalizedTypes: ['number']
  }
};