"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CustomEquationEditor = CustomEquationEditor;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _lodash = require("lodash");
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _threshold_unit = require("../../helpers/threshold_unit");
var _types = require("../../../../../common/custom_threshold_rule/types");
var _metric_row_with_agg = require("./metric_row_with_agg");
var _closable_popover_title = require("../closable_popover_title");
var _i18n_strings = require("../../i18n_strings");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763899475283842490/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/observability/public/components/custom_threshold/components/custom_equation/custom_equation_editor.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const NEW_METRIC = {
  name: 'A',
  aggType: _types.Aggregators.COUNT
};
const MAX_VARIABLES = 26;
const CHAR_CODE_FOR_A = 65;
const CHAR_CODE_FOR_Z = CHAR_CODE_FOR_A + MAX_VARIABLES;
const VAR_NAMES = (0, _lodash.range)(CHAR_CODE_FOR_A, CHAR_CODE_FOR_Z).map(c => String.fromCharCode(c));
function CustomEquationEditor({
  onChange,
  expression,
  fields,
  aggregationTypes,
  errors,
  dataView
}) {
  var _expression$metrics;
  const [customMetrics, setCustomMetrics] = (0, _react.useState)((_expression$metrics = expression === null || expression === void 0 ? void 0 : expression.metrics) !== null && _expression$metrics !== void 0 ? _expression$metrics : [NEW_METRIC]);
  const [customEqPopoverOpen, setCustomEqPopoverOpen] = (0, _react.useState)(false);
  const [equation, setEquation] = (0, _react.useState)(expression === null || expression === void 0 ? void 0 : expression.equation);
  const debouncedOnChange = (0, _react.useMemo)(() => (0, _lodash.debounce)(onChange, 500), [onChange]);
  (0, _react.useEffect)(() => {
    var _expression$metrics2;
    setCustomMetrics((_expression$metrics2 = expression === null || expression === void 0 ? void 0 : expression.metrics) !== null && _expression$metrics2 !== void 0 ? _expression$metrics2 : [NEW_METRIC]);
    setEquation(expression === null || expression === void 0 ? void 0 : expression.equation);
  }, [expression === null || expression === void 0 ? void 0 : expression.metrics, expression === null || expression === void 0 ? void 0 : expression.equation]);
  const handleAddNewRow = (0, _react.useCallback)(() => {
    setCustomMetrics(previous => {
      var _previous$map;
      const currentVars = (_previous$map = previous === null || previous === void 0 ? void 0 : previous.map(m => m.name)) !== null && _previous$map !== void 0 ? _previous$map : [];
      const name = (0, _lodash.first)((0, _lodash.xor)(VAR_NAMES, currentVars));
      const nextMetrics = [...(previous || []), {
        ...NEW_METRIC,
        name
      }];
      debouncedOnChange({
        ...expression,
        metrics: nextMetrics,
        equation,
        threshold: (0, _threshold_unit.convertToApiThreshold)(previous, nextMetrics, expression.threshold)
      });
      return nextMetrics;
    });
  }, [debouncedOnChange, equation, expression]);
  const handleDelete = (0, _react.useCallback)(name => {
    setCustomMetrics(previous => {
      var _previous$filter;
      const nextMetrics = (_previous$filter = previous === null || previous === void 0 ? void 0 : previous.filter(row => row.name !== name)) !== null && _previous$filter !== void 0 ? _previous$filter : [NEW_METRIC];
      const finalMetrics = nextMetrics.length && nextMetrics || [NEW_METRIC];
      debouncedOnChange({
        ...expression,
        metrics: finalMetrics,
        equation,
        threshold: (0, _threshold_unit.convertToApiThreshold)(previous, nextMetrics, expression.threshold)
      });
      return finalMetrics;
    });
  }, [equation, expression, debouncedOnChange]);
  const handleChange = (0, _react.useCallback)(metric => {
    setCustomMetrics(previous => {
      const nextMetrics = previous === null || previous === void 0 ? void 0 : previous.map(m => m.name === metric.name ? metric : m);
      debouncedOnChange({
        ...expression,
        metrics: nextMetrics,
        equation,
        threshold: (0, _threshold_unit.convertToApiThreshold)(previous, nextMetrics, expression.threshold)
      });
      return nextMetrics;
    });
  }, [equation, expression, debouncedOnChange]);
  const handleEquationChange = (0, _react.useCallback)(e => {
    setEquation(e.target.value);
    debouncedOnChange({
      ...expression,
      metrics: customMetrics,
      equation: e.target.value
    });
  }, [debouncedOnChange, expression, customMetrics]);
  const disableAdd = (customMetrics === null || customMetrics === void 0 ? void 0 : customMetrics.length) === MAX_VARIABLES;
  const disableDelete = (customMetrics === null || customMetrics === void 0 ? void 0 : customMetrics.length) === 1;
  const metricRows = customMetrics === null || customMetrics === void 0 ? void 0 : customMetrics.map(row => /*#__PURE__*/_react.default.createElement(_metric_row_with_agg.MetricRowWithAgg, {
    key: row.name,
    name: row.name,
    aggType: row.aggType,
    aggregationTypes: aggregationTypes,
    field: row.field,
    filter: row.filter,
    fields: fields,
    onAdd: handleAddNewRow,
    onDelete: handleDelete,
    disableAdd: disableAdd,
    disableDelete: disableDelete,
    onChange: handleChange,
    errors: errors,
    dataView: dataView,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 133,
      columnNumber: 5
    }
  }));
  const placeholder = (0, _react.useMemo)(() => {
    return customMetrics === null || customMetrics === void 0 ? void 0 : customMetrics.map(row => row.name).join(' + ');
  }, [customMetrics]);
  return /*#__PURE__*/_react.default.createElement("div", {
    style: {
      minWidth: '100%'
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 156,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: 's',
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 157,
      columnNumber: 7
    }
  }), metricRows, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 159,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": "thresholdRuleCustomEquationEditorAddAggregationFieldButton",
    color: 'primary',
    flush: 'left',
    size: "xs",
    iconType: 'plusInCircleFilled',
    onClick: handleAddNewRow,
    isDisabled: disableAdd,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 160,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.observability.customThreshold.rule.alertFlyout.customEquationEditor.addCustomRow",
    defaultMessage: "Add aggregation/field",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 169,
      columnNumber: 11
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: 'm',
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 175,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 176,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    button: /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      "data-test-subj": "equationAndThreshold",
      fullWidth: true,
      label: _i18n.i18n.translate('xpack.observability.customThreshold.rule.alertFlyout.customEquationEditor.equationAndThreshold', {
        defaultMessage: 'Equation and threshold'
      }),
      error: [errors.equation],
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 179,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "xs",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 189,
        columnNumber: 17
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiExpression, {
      "data-test-subj": "customEquation",
      description: _i18n.i18n.translate('xpack.observability.customThreshold.rule.alertFlyout.customEquationEditor.equationLabel', {
        defaultMessage: 'Equation'
      }),
      value: equation !== null && equation !== void 0 ? equation : placeholder,
      display: 'columns',
      onClick: () => {
        setCustomEqPopoverOpen(true);
      },
      isInvalid: errors.equation != null,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 190,
        columnNumber: 17
      }
    }))),
    isOpen: customEqPopoverOpen,
    closePopover: () => {
      setCustomEqPopoverOpen(false);
    },
    display: "block",
    ownFocus: true,
    anchorPosition: 'downLeft',
    repositionOnScroll: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 177,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement("div", {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 215,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_closable_popover_title.ClosablePopoverTitle, {
    onClose: () => setCustomEqPopoverOpen(false),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 216,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement("span", {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 217,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.observability.customThreshold.rule.alertFlyout.customEquationLabel",
    defaultMessage: "Custom equation",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 218,
      columnNumber: 17
    }
  }), "\xA0", /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
    content: _i18n.i18n.translate('xpack.observability.customThreshold.rule.alertFlyout.customEquationTooltip', {
      defaultMessage: 'This supports basic math (A + B / C) and boolean logic (A < B ? A : B).'
    }),
    position: "top",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 223,
      columnNumber: 17
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    helpText: _i18n_strings.EQUATION_HELP_MESSAGE,
    isInvalid: errors.equation != null,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 235,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    "data-test-subj": "thresholdRuleCustomEquationEditorFieldText",
    isInvalid: errors.equation != null,
    compressed: true,
    fullWidth: true,
    placeholder: placeholder,
    onChange: handleEquationChange,
    value: equation !== null && equation !== void 0 ? equation : '',
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 240,
      columnNumber: 15
    }
  }))))));
}