"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.OtelApmPage = void 0;
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _public = require("@kbn/kibana-react-plugin/public");
var _template = require("./template");
var _header = require("../header");
var _otel_apm = require("../quickstart_flows/otel_apm");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763899475283842490/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/observability_onboarding/public/application/pages/otel_apm.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const OtelApmPage = () => {
  const {
    services: {
      context: {
        isServerless
      }
    }
  } = (0, _public.useKibana)();
  return /*#__PURE__*/_react.default.createElement(_template.PageTemplate, {
    customHeader: /*#__PURE__*/_react.default.createElement(_header.CustomHeader, {
      logo: "opentelemetry",
      headlineCopy: _i18n.i18n.translate('xpack.observability_onboarding.onboarding.otelApmQuickstartFlow.customHeader.otel.text', {
        defaultMessage: 'Monitor your application using OpenTelemetry SDK'
      }),
      captionCopy: _i18n.i18n.translate('xpack.observability_onboarding.onboarding.otelApmQuickstartFlow.customHeader.otel.description', {
        defaultMessage: 'Instrument your applications to send traces, logs, and metrics directly to Elastic’s managed OTLP endpoint.'
      }),
      isTechnicalPreview: !isServerless,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 26,
        columnNumber: 9
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 24,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_otel_apm.OtelApmQuickstartFlow, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 45,
      columnNumber: 7
    }
  }));
};
exports.OtelApmPage = OtelApmPage;