"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NavControl = NavControl;
exports.NavControlWithProvider = void 0;
var _react = _interopRequireWildcard(require("react"));
var _public = require("@kbn/observability-ai-assistant-plugin/public");
var _eui = require("@elastic/eui");
var _uuid = require("uuid");
var _useObservable2 = _interopRequireDefault(require("react-use/lib/useObservable"));
var _i18n = require("@kbn/i18n");
var _aiAssistant = require("@kbn/ai-assistant");
var _aiAssistantIcon = require("@kbn/ai-assistant-icon");
var _use_kibana = require("../../hooks/use_kibana");
var _use_nav_control_screen_context = require("../../hooks/use_nav_control_screen_context");
var _shared_providers = require("../../utils/shared_providers");
var _use_nav_control_scope = require("../../hooks/use_nav_control_scope");
var _use_local_storage = require("../../hooks/use_local_storage");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763899475283842490/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/observability_ai_assistant_app/public/components/nav_control/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const NavControlWithProvider = ({
  appService,
  coreStart,
  pluginsStart,
  isServerless
}) => {
  return /*#__PURE__*/_react.default.createElement(_shared_providers.SharedProviders, {
    coreStart: coreStart,
    pluginsStart: pluginsStart,
    service: appService,
    theme$: coreStart.theme.theme$,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 39,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(NavControl, {
    isServerless: isServerless,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 45,
      columnNumber: 7
    }
  }));
};
exports.NavControlWithProvider = NavControlWithProvider;
function NavControl({
  isServerless
}) {
  var _useObservable;
  const service = (0, _aiAssistant.useAIAssistantAppService)();
  const {
    services: {
      application,
      http,
      notifications,
      plugins: {
        start: {
          observabilityAIAssistant: {
            ObservabilityAIAssistantChatServiceContext
          },
          aiAssistantManagementSelection
        }
      }
    }
  } = (0, _use_kibana.useKibana)();
  (0, _use_nav_control_screen_context.useNavControlScreenContext)();
  (0, _use_nav_control_scope.useNavControlScope)();
  const [flyoutSettings, setFlyoutSettings] = (0, _use_local_storage.useLocalStorage)('observabilityAIAssistant.flyoutSettings', {
    mode: _aiAssistant.FlyoutPositionMode.OVERLAY,
    isOpen: false
  });

  // only open on mount when in docked mode
  const [isOpen, setIsOpen] = (0, _react.useState)(() => flyoutSettings.mode === _aiAssistant.FlyoutPositionMode.PUSH ? flyoutSettings.isOpen : false);
  const [hasBeenOpened, setHasBeenOpened] = (0, _react.useState)(isOpen);
  const keyRef = (0, _react.useRef)((0, _uuid.v4)());
  const chatService = (0, _public.useAbortableAsync)(({
    signal
  }) => {
    return hasBeenOpened ? service.start({
      signal
    }).catch(error => {
      notifications.toasts.addError(error, {
        title: _i18n.i18n.translate('xpack.observabilityAiAssistant.navControl.initFailureErrorTitle', {
          defaultMessage: 'Failed to initialize Observability AI Assistant'
        })
      });
      setHasBeenOpened(false);
      setIsOpen(false);
      throw error;
    }) : undefined;
  }, [service, hasBeenOpened, notifications.toasts]);
  (0, _react.useEffect)(() => {
    const conversationSubscription = service.conversations.predefinedConversation$.subscribe(() => {
      keyRef.current = (0, _uuid.v4)();
      setHasBeenOpened(true);
      setFlyoutSettings(prev => ({
        ...prev,
        isOpen: true
      }));
      setIsOpen(true);
    });
    return () => {
      conversationSubscription.unsubscribe();
    };
  }, [service.conversations.predefinedConversation$, setFlyoutSettings]);
  (0, _react.useEffect)(() => {
    const openChatSubscription = aiAssistantManagementSelection.openChat$.subscribe(event => {
      if (event.assistant === 'observability') {
        service.conversations.openNewConversation({
          messages: []
        });
        aiAssistantManagementSelection.completeOpenChat();
      }
    });
    return () => {
      openChatSubscription.unsubscribe();
    };
  }, [aiAssistantManagementSelection, service.conversations]);
  const {
    messages,
    title,
    hideConversationList
  } = (_useObservable = (0, _useObservable2.default)(service.conversations.predefinedConversation$)) !== null && _useObservable !== void 0 ? _useObservable : {
    messages: [],
    title: undefined,
    hideConversationList: false
  };
  (0, _react.useEffect)(() => {
    const keyboardListener = event => {
      if (event.ctrlKey && event.code === 'Semicolon') {
        service.conversations.openNewConversation({
          messages: []
        });
      }
    };
    window.addEventListener('keypress', keyboardListener);
    return () => {
      window.removeEventListener('keypress', keyboardListener);
    };
  }, [service.conversations]);
  const EuiButtonBasicOrEmpty = isServerless ? _eui.EuiButtonEmpty : _eui.EuiButton;
  const tooltipRef = (0, _react.useRef)(null);
  const hideToolTip = () => {
    var _tooltipRef$current;
    return (_tooltipRef$current = tooltipRef.current) === null || _tooltipRef$current === void 0 ? void 0 : _tooltipRef$current.hideToolTip();
  };
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    ref: tooltipRef,
    content: _i18n.i18n.translate('xpack.observabilityAiAssistant.navControl.openTheAIAssistantPopoverLabel', {
      defaultMessage: 'Keyboard shortcut Ctrl ;'
    }),
    disableScreenReaderOutput: true,
    onMouseOut: hideToolTip,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 165,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(EuiButtonBasicOrEmpty, {
    "aria-label": _i18n.i18n.translate('xpack.observabilityAiAssistant.navControl.assistantNavLinkAriaLabel', {
      defaultMessage: 'Open the AI Assistant'
    }),
    "data-test-subj": "observabilityAiAssistantAppNavControlButton",
    onClick: () => {
      hideToolTip();
      service.conversations.openNewConversation({
        messages: []
      });
    },
    color: "primary",
    size: "s",
    iconType: _aiAssistantIcon.AssistantIcon,
    isLoading: chatService.loading,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 174,
      columnNumber: 9
    }
  }, _i18n.i18n.translate('xpack.observabilityAiAssistant.navControl.assistantNavLink', {
    defaultMessage: 'AI Assistant'
  }))), chatService.value ? /*#__PURE__*/_react.default.createElement(ObservabilityAIAssistantChatServiceContext.Provider, {
    value: chatService.value,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 197,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_aiAssistant.ChatFlyout, {
    key: keyRef.current,
    isOpen: isOpen,
    initialMessages: messages,
    initialTitle: title !== null && title !== void 0 ? title : '',
    initialFlyoutPositionMode: flyoutSettings.mode,
    onClose: () => {
      setFlyoutSettings(prev => ({
        ...prev,
        isOpen: false
      }));
      setIsOpen(false);
    },
    onFlyoutPositionModeChange: next => {
      setFlyoutSettings(prev => ({
        ...prev,
        mode: next
      }));
    },
    navigateToConversation: conversationId => {
      application.navigateToUrl(http.basePath.prepend(`/app/observabilityAIAssistant/conversations/${conversationId || ''}`));
    },
    hideConversationList: hideConversationList,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 198,
      columnNumber: 11
    }
  })) : undefined);
}