"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RouteInit = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRouterDom = require("react-router-dom");
var _sharedUxRouter = require("@kbn/shared-ux-router");
var _use_clusters = require("./hooks/use_clusters");
var _global_state_context = require("./contexts/global_state_context");
var _get_cluster_from_clusters = require("../lib/get_cluster_from_clusters");
var _setup_mode = require("../lib/setup_mode");
var _loading_page = require("./pages/loading_page");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763899475283842490/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/monitoring/public/application/route_init.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const RouteInit = ({
  path,
  component,
  codePaths,
  fetchAllClusters,
  unsetGlobalState = false
}) => {
  const globalState = (0, _react.useContext)(_global_state_context.GlobalStateContext);
  const clusterUuid = fetchAllClusters ? null : globalState.cluster_uuid;
  const location = (0, _reactRouterDom.useLocation)();
  const {
    clusters,
    loaded
  } = (0, _use_clusters.useClusters)(clusterUuid, undefined, codePaths);
  const inSetupMode = (0, _setup_mode.isInSetupMode)(undefined, globalState);
  const cluster = (0, _get_cluster_from_clusters.getClusterFromClusters)(clusters, globalState, unsetGlobalState);

  // TODO: check for setupMode too when the setup mode is migrated
  if (loaded && !cluster && !inSetupMode) {
    return /*#__PURE__*/_react.default.createElement(_reactRouterDom.Redirect, {
      to: "/no-data",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 47,
        columnNumber: 12
      }
    });
  }
  if (loaded && cluster) {
    // check if we need to redirect because of license problems
    if (location.pathname !== 'license' && location.pathname !== 'home' && isExpired(cluster.license)) {
      return /*#__PURE__*/_react.default.createElement(_reactRouterDom.Redirect, {
        to: "/license",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 57,
          columnNumber: 14
        }
      });
    }

    // check if we need to redirect because of attempt at unsupported multi-cluster monitoring
    const clusterSupported = cluster.isSupported || clusters.length === 1;
    if (location.pathname !== '/home' && !clusterSupported) {
      return /*#__PURE__*/_react.default.createElement(_reactRouterDom.Redirect, {
        to: "/home",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 63,
          columnNumber: 14
        }
      });
    }
  }
  const Component = component;
  return loaded ? /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: path,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 69,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(Component, {
    clusters: clusters,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 70,
      columnNumber: 7
    }
  })) : /*#__PURE__*/_react.default.createElement(_loading_page.LoadingPage, {
    staticLoadingState: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 73,
      columnNumber: 5
    }
  });
};
exports.RouteInit = RouteInit;
const isExpired = license => {
  const {
    expiry_date_in_millis: expiryDateInMillis
  } = license;
  if (expiryDateInMillis !== undefined) {
    return new Date().getTime() >= expiryDateInMillis;
  }
  return false;
};